/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.edapt.common.ui.DialogUtils;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.migration.ui.MigrationUIActivator;

public final class LaunchUtils {
    private LaunchUtils() {
    }

    public static String getAttribute(ILaunchConfiguration configuration, String attributeName, String defaultValue) {
        try {
            return configuration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            LaunchUtils.showAttributeAccessError(attributeName, e);
            return null;
        }
    }

    public static List<String> getAttribute(ILaunchConfiguration configuration, String attributeName, List<String> defaultValue) {
        try {
            return configuration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            LaunchUtils.showAttributeAccessError(attributeName, e);
            return null;
        }
    }

    public static boolean getAttribute(ILaunchConfiguration configuration, String attributeName, boolean defaultValue) {
        try {
            return configuration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            LaunchUtils.showAttributeAccessError(attributeName, e);
            return defaultValue;
        }
    }

    public static int getAttribute(ILaunchConfiguration configuration, String attributeName, int defaultValue) {
        try {
            return configuration.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            LaunchUtils.showAttributeAccessError(attributeName, e);
            return defaultValue;
        }
    }

    private static void showAttributeAccessError(String attributeName, CoreException e) {
        String message = "Could read attribute " + attributeName + " from the launch configuration: " + e.getMessage();
        DialogUtils.openErrorDialogAsync((String)"Error reading launch configuration", (String)message);
        LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (String)message, (Throwable)e);
    }
}

