/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.common.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.internal.common.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public abstract class SelectModelElementWizardFactory {
    public static Set<EObject> openModelElementSelectionDialog(Set<EObject> elements, boolean isMany) {
        SelectionComposite<TableViewer> tableSelectionComposite = CompositeFactory.getTableSelectionComposite(elements.toArray(), isMany);
        SelectModelElementWizard wizard = new SelectModelElementWizard("Select Elements", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.ModelelementSelectionDialog_DialogTitle, Messages.ModelelementSelectionDialog_DialogMessage_SearchPattern, EObject.class);
        HashSet<EObject> selectedElements = new HashSet<EObject>();
        wizard.setCompositeProvider(tableSelectionComposite);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        int result = wd.open();
        if (result == 0) {
            Object[] selection = tableSelectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return selectedElements;
            }
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    selectedElements.add((EObject)object);
                }
                ++n2;
            }
        }
        return selectedElements;
    }

    public static EObject openCreateNewModelElementDialog(SelectionComposite<TreeViewer> selectionComposite) {
        SelectModelElementWizard wizard = new SelectModelElementWizard("New Reference Element", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement);
        wizard.setCompositeProvider(selectionComposite);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EObject newMEInstance = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = selectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            EClass eClasse = (EClass)selection[0];
            EPackage ePackage = eClasse.getEPackage();
            newMEInstance = ePackage.getEFactoryInstance().create(eClasse);
        }
        return newMEInstance;
    }
}

