/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.edit.internal.swt.SWTImageHelper;
import org.eclipse.emf.ecp.edit.spi.swt.reference.DeleteReferenceAction;
import org.eclipse.emf.ecp.edit.spi.swt.reference.NewReferenceAction;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateDomainModelReferenceWizard;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceImpl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DomainModelReferenceControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private final EMFFormsEditSupport emfFormsEditSupport;
    private Composite mainComposite;
    private StackLayout stackLayout;
    private Label unsetLabel;
    private EObject eObject;
    private EStructuralFeature structuralFeature;
    private ECPModelElementChangeListener modelElementChangeListener;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private Composite parentComposite;
    private Label setLabel;
    private Label imageLabel;
    private Composite contentSetComposite;

    @Inject
    public DomainModelReferenceControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.emfFormsEditSupport = emfFormsEditSupport;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding[] bindings = new Binding[3];
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)this.setLabel);
        bindings[0] = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(){

            public Object convert(Object value) {
                try {
                    return DomainModelReferenceControlSWTRenderer.this.getModelValue().getValue();
                }
                catch (DatabindingFailedException ex) {
                    DomainModelReferenceControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return null;
                }
            }
        }), new UpdateValueStrategy(){

            public Object convert(Object value) {
                DomainModelReferenceControlSWTRenderer.this.updateChangeListener((EObject)value);
                return DomainModelReferenceControlSWTRenderer.this.getText(value);
            }
        });
        ISWTObservableValue imageValue = WidgetProperties.image().observe((Widget)this.imageLabel);
        bindings[1] = this.getDataBindingContext().bindValue((IObservableValue)imageValue, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER)), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return DomainModelReferenceControlSWTRenderer.this.getImage(value);
            }
        });
        ISWTObservableValue setLabelTooltip = WidgetProperties.tooltipText().observe((Widget)this.setLabel);
        bindings[2] = this.getDataBindingContext().bindValue((IObservableValue)setLabelTooltip, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER)), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!EObject.class.isInstance(value)) {
                    return "";
                }
                EObject eObject = (EObject)EObject.class.cast(value);
                Resource resource = eObject.eResource();
                if (!VViewResourceImpl.class.isInstance(resource)) {
                    return "";
                }
                String id = ((VViewResourceImpl)VViewResourceImpl.class.cast(resource)).getID(eObject);
                return MessageFormat.format("UUID: {0}", id);
            }
        });
        return bindings;
    }

    private Object getImage(Object value) {
        Object image = this.adapterFactoryItemDelegator.getImage(value);
        return SWTImageHelper.getImage((Object)image);
    }

    private Object getText(Object object) {
        String linkText;
        VFeaturePathDomainModelReference modelReference = (VFeaturePathDomainModelReference)object;
        if (VTableDomainModelReference.class.isInstance(modelReference)) {
            VTableDomainModelReference tableRef = (VTableDomainModelReference)VTableDomainModelReference.class.cast(modelReference);
            while (tableRef.getDomainModelReference() != null && VTableDomainModelReference.class.isInstance(tableRef.getDomainModelReference())) {
                tableRef = (VTableDomainModelReference)VTableDomainModelReference.class.cast(tableRef.getDomainModelReference());
            }
            modelReference = (VFeaturePathDomainModelReference)tableRef.getDomainModelReference();
        }
        if (modelReference == null) {
            return null;
        }
        EStructuralFeature value = modelReference.getDomainModelEFeature();
        String className = "";
        String attributeName = " -> " + this.adapterFactoryItemDelegator.getText((Object)value);
        String referencePath = "";
        for (EReference ref : modelReference.getDomainModelEReferencePath()) {
            if (className.isEmpty()) {
                className = ref.getEContainingClass().getName();
            }
            referencePath = String.valueOf(referencePath) + " -> " + this.adapterFactoryItemDelegator.getText((Object)ref);
        }
        if (className.isEmpty() && modelReference.getDomainModelEFeature() != null && modelReference.getDomainModelEFeature().getEContainingClass() != null) {
            className = modelReference.getDomainModelEFeature().getEContainingClass().getName();
        }
        if ((linkText = String.valueOf(className) + referencePath + attributeName).equals(" -> ")) {
            return null;
        }
        return linkText;
    }

    private void updateChangeListener(EObject value) {
        if (this.modelElementChangeListener != null) {
            if (this.modelElementChangeListener.getTarget().equals(value)) {
                return;
            }
            this.modelElementChangeListener.remove();
            this.modelElementChangeListener = null;
        }
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.mainComposite.layout();
            }
        } else {
            if (this.stackLayout.topControl != this.contentSetComposite) {
                this.stackLayout.topControl = this.contentSetComposite;
                this.mainComposite.layout();
            }
            this.modelElementChangeListener = new ECPModelElementChangeListener(value){

                public void onChange(Notification notification) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DomainModelReferenceControlSWTRenderer.this.getDataBindingContext().updateTargets();
                        }
                    });
                }
            };
        }
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        IObservableValue observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        this.eObject = (EObject)((IObserving)observableValue).getObserved();
        this.structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().applyTo(containerComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)containerComposite);
        this.parentComposite = new Composite(containerComposite, 0);
        this.parentComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(0, 0).equalWidth(false).applyTo(this.parentComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.parentComposite);
        this.stackLayout = new StackLayout();
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainComposite.setBackground(this.parentComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.mainComposite);
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.mainComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.unsetLabel);
        this.unsetLabel.setText(LocalizationServiceHelper.getString(DomainModelReferenceControlSWTRenderer.class, (String)"LinkControl_NotSet"));
        this.unsetLabel.setBackground(this.mainComposite.getBackground());
        this.unsetLabel.setForeground(this.parentComposite.getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.contentSetComposite = new Composite(this.mainComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.contentSetComposite);
        this.contentSetComposite.setBackground(this.mainComposite.getBackground());
        this.imageLabel = new Label(this.contentSetComposite, 0);
        this.imageLabel.setBackground(this.contentSetComposite.getBackground());
        GridDataFactory.fillDefaults().grab(false, false).align(4, 4).hint(17, -1).applyTo((Control)this.imageLabel);
        this.setLabel = new Label(this.contentSetComposite, 0);
        this.setLabel.setBackground(this.contentSetComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.setLabel);
        this.stackLayout.topControl = this.eObject.eIsSet(this.structuralFeature) ? this.contentSetComposite : this.unsetLabel;
        this.createButtons(this.parentComposite);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        return containerComposite;
    }

    private void createButtons(Composite composite) throws DatabindingFailedException {
        Button unsetBtn = this.createButtonForAction((Action)new DeleteReferenceAction(this.getEditingDomain(this.eObject), this.eObject, this.structuralFeature, null), composite);
        unsetBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Command setCommand = SetCommand.create((EditingDomain)DomainModelReferenceControlSWTRenderer.this.getEditingDomain(DomainModelReferenceControlSWTRenderer.this.eObject), (Object)DomainModelReferenceControlSWTRenderer.this.eObject, (Object)DomainModelReferenceControlSWTRenderer.this.structuralFeature, (Object)SetCommand.UNSET_VALUE);
                DomainModelReferenceControlSWTRenderer.this.getEditingDomain(DomainModelReferenceControlSWTRenderer.this.eObject).getCommandStack().execute(setCommand);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button setBtn = this.createButtonForAction((Action)new NewReferenceAction(this.getEditingDomain(this.eObject), this.eObject, this.structuralFeature, this.emfFormsEditSupport, this.getEMFFormsLabelProvider(), null, this.getReportService(), ((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()), composite);
        setBtn.addSelectionListener((SelectionListener)new SelectionAdapterExtension(this.setLabel, this.getModelValue(), this.getViewModelContext(), this.getDataBindingContext(), this.structuralFeature));
    }

    protected Button createButtonForAction(Action action, Composite composite) {
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(Activator.getImage(action));
        selectButton.setEnabled(true);
        selectButton.setToolTipText(action.getToolTipText());
        return selectButton;
    }

    protected String getUnsetText() {
        return LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"LinkControl_NoLinkSetClickToSetLink");
    }

    private class SelectionAdapterExtension
    extends SelectionAdapter {
        private final EStructuralFeature eStructuralFeature;

        SelectionAdapterExtension(Label label, IObservableValue modelValue, ViewModelContext viewModelContext, DataBindingContext dataBindingContext, EStructuralFeature eStructuralFeature) {
            this.eStructuralFeature = eStructuralFeature;
        }

        public void widgetSelected(SelectionEvent e) {
            Collection classes = EMFUtils.getSubClasses((EClass)((EReferenceImpl)this.eStructuralFeature).getEReferenceType());
            EClass eclass = Helper.getRootEClass(DomainModelReferenceControlSWTRenderer.this.getViewModelContext().getDomainModel());
            VDomainModelReference reference = null;
            if (VControl.class.isInstance(DomainModelReferenceControlSWTRenderer.this.eObject)) {
                reference = ((VControl)VControl.class.cast(DomainModelReferenceControlSWTRenderer.this.eObject)).getDomainModelReference();
            } else if (VLabel.class.isInstance(DomainModelReferenceControlSWTRenderer.this.eObject)) {
                reference = ((VLabel)VLabel.class.cast(DomainModelReferenceControlSWTRenderer.this.eObject)).getDomainModelReference();
            }
            CreateDomainModelReferenceWizard wizard = new CreateDomainModelReferenceWizard(DomainModelReferenceControlSWTRenderer.this.eObject, DomainModelReferenceControlSWTRenderer.this.structuralFeature, DomainModelReferenceControlSWTRenderer.this.getEditingDomain(DomainModelReferenceControlSWTRenderer.this.eObject), eclass, reference == null ? "New Reference Element" : "Configure " + reference.eClass().getName(), Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement, reference);
            SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
            wizard.setCompositeProvider((CompositeProvider)helper);
            WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wd.open();
        }
    }
}

