/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.datatemplate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.ui.view.swt.reference.DefaultCreateNewModelElementStrategyProvider;
import org.eclipse.emf.ecp.ui.view.swt.reference.EClassSelectionStrategy;
import org.eclipse.emfforms.core.services.datatemplate.TemplateProvider;
import org.eclipse.emfforms.datatemplate.DataTemplateFactory;
import org.eclipse.emfforms.datatemplate.Template;
import org.eclipse.emfforms.spi.common.BundleResolver;
import org.eclipse.emfforms.spi.common.BundleResolverFactory;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="BlankTemplateProvider")
public class BlankTemplateProvider
implements TemplateProvider {
    private BundleResolver bundleResolver;
    private EMFFormsLocalizationService localizationService;
    private DefaultCreateNewModelElementStrategyProvider defaultNewElementStrategyProvider;

    public BlankTemplateProvider() {
        this.setBundleResolver(BundleResolverFactory.createBundleResolver());
    }

    @Reference
    void setLocalizationService(EMFFormsLocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    @Reference
    void setDefaultNewElementStrategyProvider(DefaultCreateNewModelElementStrategyProvider defaultNewElementStrategyProvider) {
        this.defaultNewElementStrategyProvider = defaultNewElementStrategyProvider;
    }

    @Override
    public boolean canProvideTemplates(EObject owner, EReference reference) {
        for (EClass subClass : EMFUtils.getSubClasses((EClass)reference.getEReferenceType())) {
            if (subClass.isAbstract() || subClass.isInterface()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Template> provideTemplates(EObject owner, EReference reference) {
        return this.provideTemplates(owner, reference, EClassSelectionStrategy.NULL);
    }

    public Set<Template> provideTemplates(EObject owner, EReference reference, EClassSelectionStrategy eClassSelectionStrategy) {
        HashMap<EClass, EObject> descriptors;
        HashMap<EClass, EObject> hashMap = descriptors = this.defaultNewElementStrategyProvider == null ? Collections.emptyMap() : this.defaultNewElementStrategyProvider.getNewObjectsByDescriptors(owner, reference);
        if (descriptors.isEmpty()) {
            descriptors = new HashMap<EClass, EObject>();
            Collection subClasses = EMFUtils.getSubClasses((EClass)reference.getEReferenceType());
            for (EClass subClass : subClasses) {
                if (subClass.isAbstract() || subClass.isInterface()) continue;
                descriptors.put(subClass, EcoreUtil.create((EClass)subClass));
            }
        }
        Collection allowedEClasses = eClassSelectionStrategy.collectEClasses(owner, reference, new LinkedHashSet(descriptors.keySet()));
        descriptors.keySet().retainAll(allowedEClasses);
        LinkedHashSet<Template> result = new LinkedHashSet<Template>();
        for (Map.Entry next : descriptors.entrySet()) {
            result.add(this.createTemplate((EClass)next.getKey(), (EObject)next.getValue()));
        }
        return result;
    }

    protected Template createTemplate(EClass type, EObject instance) {
        Template template = DataTemplateFactory.eINSTANCE.createTemplate();
        template.setInstance(instance);
        String nameTemplate = this.localizationService.getString(BlankTemplateProvider.class, "BlankTemplateProvider_blankTemplateLabel");
        template.setName(NLS.bind((String)nameTemplate, (Object)this.getDisplayName(type)));
        return template;
    }

    protected void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected String getDisplayName(EClass type) {
        try {
            Bundle editBundle = this.bundleResolver.getEditBundle((EClassifier)type);
            return this.localizationService.getString(editBundle, String.format("_UI_%s_type", type.getName()));
        }
        catch (BundleResolver.NoBundleFoundException noBundleFoundException) {
            return type.getName();
        }
    }
}

