/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.defaultheuristic;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsDomainExpanderImpl")
public class EMFFormsDomainExpanderImpl
implements EMFFormsDomainExpander {
    private final Set<EMFFormsDMRExpander> emfFormsDMRExpanders = new CopyOnWriteArraySet<EMFFormsDMRExpander>();
    private final Set<EMFFormsDMRSegmentExpander> emfFormsDMRSegmentExpanders = new CopyOnWriteArraySet<EMFFormsDMRSegmentExpander>();
    private static final RankingHelper<EMFFormsDMRExpander> DMR_RANKING_HELPER = new RankingHelper(EMFFormsDMRExpander.class, EMFFormsDMRExpander.NOT_APPLICABLE.doubleValue(), EMFFormsDMRExpander.NOT_APPLICABLE);
    private static final RankingHelper<EMFFormsDMRSegmentExpander> SEGMENTS_RANKING_HELPER = new RankingHelper(EMFFormsDMRSegmentExpander.class, EMFFormsDMRSegmentExpander.NOT_APPLICABLE.doubleValue(), EMFFormsDMRSegmentExpander.NOT_APPLICABLE);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.add(emfFormsDMRExpander);
    }

    protected void removeEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.remove(emfFormsDMRExpander);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsDMRSegmentExpander(EMFFormsDMRSegmentExpander emfFormsDMRSegmentExpander) {
        this.emfFormsDMRSegmentExpanders.add(emfFormsDMRSegmentExpander);
    }

    protected void removeEMFFormsDMRSegmentExpander(EMFFormsDMRSegmentExpander emfFormsDMRSegmentExpander) {
        this.emfFormsDMRSegmentExpanders.remove(emfFormsDMRSegmentExpander);
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            EMFFormsDMRExpander bestDMRExpander = this.getBestDmrExpander(domainModelReference);
            bestDMRExpander.prepareDomainObject(domainModelReference, domainObject);
            return;
        }
        Optional currentDomainObject = Optional.ofNullable(domainObject);
        int i = 0;
        while (i < segments.size()) {
            if (!currentDomainObject.isPresent()) {
                throw new EMFFormsExpandingFailedException("Could not finish expansion because a segment could not be expanded.");
            }
            VDomainModelReferenceSegment segment = (VDomainModelReferenceSegment)segments.get(i);
            EMFFormsDMRSegmentExpander expander = this.getBestSegmentExpander(segment);
            if (i == segments.size() - 1 && !expander.needsToExpandLastSegment()) break;
            currentDomainObject = expander.prepareDomainObject(segment, currentDomainObject.get());
            ++i;
        }
    }

    private EMFFormsDMRExpander getBestDmrExpander(VDomainModelReference domainModelReference) throws EMFFormsExpandingFailedException {
        EMFFormsDMRExpander bestDMRExpander = (EMFFormsDMRExpander)DMR_RANKING_HELPER.getHighestRankingElement(this.emfFormsDMRExpanders, dmrExpander -> dmrExpander.isApplicable(domainModelReference));
        if (bestDMRExpander == null) {
            throw new EMFFormsExpandingFailedException("There is no suitable EMFFormsDMRExpander for the given domain model reference.");
        }
        return bestDMRExpander;
    }

    private EMFFormsDMRSegmentExpander getBestSegmentExpander(VDomainModelReferenceSegment segment) throws EMFFormsExpandingFailedException {
        EMFFormsDMRSegmentExpander bestSegmentExpander = (EMFFormsDMRSegmentExpander)SEGMENTS_RANKING_HELPER.getHighestRankingElement(this.emfFormsDMRSegmentExpanders, expander -> expander.isApplicable(segment));
        if (bestSegmentExpander == null) {
            throw new EMFFormsExpandingFailedException(String.format("There is no suitable EMFFormsDMRSegmentExpander for the given segment %1$s.", segment));
        }
        return bestSegmentExpander;
    }
}

