/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.view.control.multiattribute;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPObservableValue;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.internal.view.control.multiattribute.Messages;
import org.eclipse.emfforms.internal.view.control.multiattribute.celleditor.CellEditorFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerRow;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class MultiAttributeSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private static final String ICONS_ARROW_DOWN_PNG = "icons/arrow_down.png";
    private static final String ICONS_ARROW_UP_PNG = "icons/arrow_up.png";
    private final ImageRegistryService imageRegistryService;
    private AdapterFactoryLabelProvider labelProvider;
    private ComposedAdapterFactory composedAdapterFactory;
    private Composite mainComposite;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;
    private final EMFDataBindingContext viewModelDBC;
    private Label validationIcon;
    private AddButtonSelectionAdapter addButtonSelectionAdapter;
    private RemoveButtonSelectionAdapter removeButtonSelectionAdapter;
    private UpButtonSelectionAdapter upButtonSelectionAdapter;
    private DownButtonSelectionAdapter downButtonSelectionAdapter;
    private ECPListEditingSupport observableSupport;

    @Inject
    public MultiAttributeSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
    }

    protected int getTableHeightHint() {
        return 200;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected Image getImage(String path) {
        return this.imageRegistryService.getImage(FrameworkUtil.getBundle(MultiAttributeSWTRenderer.class), path);
    }

    private Button createRemoveRowButton(Composite buttonComposite, IObservableList list, EAttribute attribute) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_DELETE);
        this.removeButton.setImage(image);
        this.removeButton.setEnabled(!((VControl)this.getVElement()).isReadonly());
        if (list.size() <= attribute.getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
        return this.removeButton;
    }

    private Button createAddRowButton(Composite buttonComposite, IObservableList list, EAttribute attribute) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_ADD);
        this.addButton.setImage(image);
        if (attribute.getUpperBound() != -1 && list.size() >= attribute.getUpperBound()) {
            this.addButton.setEnabled(false);
        }
        return this.addButton;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        IObservableList list;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(parent.getBackground());
        try {
            list = this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex1) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex1));
            return composite;
        }
        EAttribute attribute = (EAttribute)EAttribute.class.cast(list.getElementType());
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        this.createLabelProvider();
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Button addButton = null;
        Button removeButton = null;
        Composite buttonComposite = new Composite(titleComposite, 0);
        buttonComposite.setBackground(titleComposite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
        int numButtons = 0;
        if (attribute.isOrdered()) {
            this.createUpDownButtons(buttonComposite, list);
            numButtons += 2;
        }
        addButton = this.createAddRowButton(buttonComposite, list, attribute);
        removeButton = this.createRemoveRowButton(buttonComposite, list, attribute);
        GridLayoutFactory.fillDefaults().numColumns(numButtons += 2).equalWidth(false).applyTo(buttonComposite);
        Composite controlComposite = this.createControlComposite(composite);
        this.createContent(controlComposite, attribute, list);
        this.initAddButton(addButton, list);
        this.initRemoveButton(removeButton, list);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiAttributeSWTRenderer.this.removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        SWTDataElementIdHelper.setElementIdDataForVControl((Widget)composite, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        return composite;
    }

    private void createLabelProvider() {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        this.labelProvider.setFireLabelUpdateNotifications(true);
    }

    private void initAddButton(Button addButton, IObservableList list) {
        if (addButton == null) {
            return;
        }
        this.addButtonSelectionAdapter = new AddButtonSelectionAdapter(list);
        addButton.addSelectionListener((SelectionListener)this.addButtonSelectionAdapter);
    }

    private void initRemoveButton(Button removeButton, IObservableList list) {
        if (removeButton == null) {
            return;
        }
        this.removeButtonSelectionAdapter = new RemoveButtonSelectionAdapter(list);
        removeButton.addSelectionListener((SelectionListener)this.removeButtonSelectionAdapter);
    }

    private void createUpDownButtons(Composite composite, IObservableList list) {
        Image up = this.getImage(ICONS_ARROW_UP_PNG);
        Image down = this.getImage(ICONS_ARROW_DOWN_PNG);
        Button upB = new Button(composite, 8);
        upB.setImage(up);
        upB.setEnabled(!((VControl)this.getVElement()).isReadonly());
        this.upButtonSelectionAdapter = new UpButtonSelectionAdapter(list);
        upB.addSelectionListener((SelectionListener)this.upButtonSelectionAdapter);
        Button downB = new Button(composite, 8);
        downB.setImage(down);
        downB.setEnabled(!((VControl)this.getVElement()).isReadonly());
        this.downButtonSelectionAdapter = new DownButtonSelectionAdapter(list);
        downB.addSelectionListener((SelectionListener)this.downButtonSelectionAdapter);
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    private void createContent(Composite composite, EAttribute attribute, IObservableList list) {
        this.tableViewer = new TableViewer(composite, 68098);
        this.tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_multiattribute");
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setResizable(false);
        column.getColumn().setMoveable(false);
        EClass clazz = attribute.getEContainingClass();
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        CellEditor cellEditor = this.createCellEditor((EObject)tempInstance, attribute, this.tableViewer.getTable());
        ISWTObservableValue textObservableValue = SWTObservables.observeText((Widget)column.getColumn());
        ISWTObservableValue tooltipObservableValue = SWTObservables.observeTooltipText((Widget)column.getColumn());
        try {
            this.viewModelDBC.bindValue((IObservableValue)textObservableValue, labelService.getDisplayName(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
            this.viewModelDBC.bindValue((IObservableValue)tooltipObservableValue, labelService.getDescription(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)cp);
        this.tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, false));
        VDomainModelReference dmr = ((VControl)this.getVElement()).getDomainModelReference();
        this.observableSupport = new ECPListEditingSupport((ColumnViewer)this.tableViewer, cellEditor, (VControl)this.getVElement(), dmr, list);
        column.setEditingSupport((EditingSupport)this.observableSupport);
    }

    private CellEditor createCellEditor(EObject tempInstance, EAttribute attribute, Table table) {
        return CellEditorFactory.INSTANCE.createCellEditor(attribute, tempInstance, table, this.getViewModelContext());
    }

    protected Object getValueForNewRow(EAttribute attribute) {
        try {
            Object defaultValue = attribute.getEType().getDefaultValue();
            if (defaultValue == null) {
                defaultValue = attribute.getEType().getInstanceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return defaultValue;
        }
        catch (InstantiationException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (IllegalAccessException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (IllegalArgumentException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (InvocationTargetException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (NoSuchMethodException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (SecurityException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        throw new IllegalStateException();
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MultiAttributeSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (MultiAttributeSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VControl)MultiAttributeSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                MultiAttributeSWTRenderer.this.validationIcon.setImage(MultiAttributeSWTRenderer.this.getValidationIcon(((VControl)MultiAttributeSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                MultiAttributeSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)MultiAttributeSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
            }
        });
    }

    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        super.dispose();
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        IObservableList oldList = (IObservableList)this.getTableViewer().getInput();
        oldList.dispose();
        IObservableList list = this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        this.getTableViewer().setInput((Object)list);
        this.addButtonSelectionAdapter.setObservableList(list);
        this.removeButtonSelectionAdapter.setObservableList(list);
        this.upButtonSelectionAdapter.setObservableList(list);
        this.downButtonSelectionAdapter.setObservableList(list);
        this.observableSupport.setObservableList(list);
    }

    private final class AddButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        AddButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent event) {
            try {
                IObserving observing = (IObserving)IObserving.class.cast(this.list);
                EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
                EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
                Object defaultValue = MultiAttributeSWTRenderer.this.getValueForNewRow(attribute);
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(MultiAttributeSWTRenderer.this.getViewModelContext().getDomainModel());
                editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)attribute, (Object)defaultValue));
                MultiAttributeSWTRenderer.this.tableViewer.refresh();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private final class DownButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        DownButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            int currentIndex = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelectionIndex();
            if (currentIndex + 1 < MultiAttributeSWTRenderer.this.tableViewer.getTable().getItems().length) {
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
                editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, (EStructuralFeature)attribute, currentIndex, currentIndex + 1));
                MultiAttributeSWTRenderer.this.tableViewer.refresh();
            }
        }
    }

    private class ECPListEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final VControl control;
        private IObservableList valueProperty;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        ECPListEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VControl control, VDomainModelReference domainModelReference, IObservableList valueProperty) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.control = control;
            this.valueProperty = valueProperty;
        }

        protected boolean canEdit(Object element) {
            boolean editable;
            boolean bl = editable = this.control.isEnabled() && !this.control.isReadonly();
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            TableViewerRow viewerRow = (TableViewerRow)cell.getViewerRow();
            TableItem item = (TableItem)viewerRow.getItem();
            int index = item.getParent().indexOf(item);
            ECPObservableValue model = new ECPObservableValue(this.valueProperty, index, (Object)((EAttribute)EAttribute.class.cast(this.valueProperty.getElementType())).getEAttributeType().getInstanceClass());
            Binding binding = this.createBinding(target, (IObservableValue)model);
            this.editingState = new EditingState(binding, target, (IObservableValue)model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return MultiAttributeSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(MultiAttributeSWTRenderer.this.getDataBindingContext()), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy(MultiAttributeSWTRenderer.this.getDataBindingContext()));
            }
            return MultiAttributeSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)16);
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        public void setObservableList(IObservableList list) {
            this.valueProperty = list;
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPListEditingSupport.this.editingState.dispose();
                ECPListEditingSupport.this.editingState = null;
                ECPListEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPListEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPListEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private final class RemoveButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        RemoveButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
            IStructuredSelection selection = MultiAttributeSWTRenderer.this.tableViewer.getStructuredSelection();
            if (!selection.isEmpty()) {
                editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)attribute, (Collection)selection.toList()));
            }
        }
    }

    private final class UpButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        UpButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            int currentIndex = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelectionIndex();
            if (currentIndex != 0) {
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
                editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, (EStructuralFeature)attribute, currentIndex, currentIndex - 1));
                MultiAttributeSWTRenderer.this.tableViewer.refresh();
            }
        }
    }
}

