/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.view.control.multiattribute.celleditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.PreSetValidationListeners;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.view.control.multiattribute.celleditor.MultiAttributeSWTRendererCellEditorTester;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class CellEditorFactory {
    public static final CellEditorFactory INSTANCE = new CellEditorFactory();
    private static final String POINT_ID = "org.eclipse.emfforms.swt.control.multiattribute.cellEditor";
    private static final String CLAZZ = "class";
    private static final String TESTER = "tester";
    private final Set<CellEditorDescriptor> descriptors = new LinkedHashSet<CellEditorDescriptor>();

    private CellEditorFactory() {
        this.parseExtensionPoint();
    }

    private void parseExtensionPoint() {
        IConfigurationElement[] editors;
        IConfigurationElement[] iConfigurationElementArray = editors = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT_ID);
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement editor = iConfigurationElementArray[n2];
            try {
                String clazz = editor.getAttribute(CLAZZ);
                Class resolvedClass = CellEditorFactory.loadClass(editor.getContributor().getName(), clazz);
                MultiAttributeSWTRendererCellEditorTester tester = (MultiAttributeSWTRendererCellEditorTester)MultiAttributeSWTRendererCellEditorTester.class.cast(editor.createExecutableExtension(TESTER));
                this.descriptors.add(new CellEditorDescriptor(resolvedClass, tester));
            }
            catch (ClassNotFoundException e) {
                this.reportException(e);
            }
            catch (CoreException e) {
                this.reportException(e);
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(MessageFormat.format("Class {0} cannot be loaded because bundle {1} cannot be resolved", clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    public CellEditor createCellEditor(EAttribute multiAttribute, EObject eObject, Table table, ViewModelContext viewModelContext) {
        double bestPriority = -4.9E-324;
        CellEditorDescriptor bestCandidate = null;
        for (CellEditorDescriptor descriptor : this.descriptors) {
            double priority = descriptor.getTester().isApplicable(eObject, multiAttribute, viewModelContext);
            if (Double.isNaN(priority) || !(priority > bestPriority)) continue;
            bestCandidate = descriptor;
            bestPriority = priority;
        }
        TextCellEditor result = null;
        if (bestCandidate != null) {
            result = this.createCellEditor((EStructuralFeature)multiAttribute, table, viewModelContext, bestCandidate, (CellEditor)result);
        }
        if (result == null) {
            result = new TextCellEditor((Composite)table);
        }
        if (Text.class.isInstance(result.getControl())) {
            PreSetValidationListeners.create().verify((Text)result.getControl(), (EStructuralFeature)multiAttribute);
        }
        return result;
    }

    private CellEditor createCellEditor(EStructuralFeature eStructuralFeature, Table table, ViewModelContext viewModelContext, CellEditorDescriptor bestCandidate, CellEditor result) {
        try {
            Constructor constructor = bestCandidate.getCellEditorClass().getConstructor(Composite.class);
            result = (CellEditor)constructor.newInstance(table);
            ECPCellEditor ecpCellEditor = (ECPCellEditor)result;
            ecpCellEditor.instantiate(eStructuralFeature, viewModelContext);
        }
        catch (SecurityException e) {
            this.reportException(e);
        }
        catch (NoSuchMethodException e) {
            this.reportException(e);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
        }
        catch (InstantiationException e) {
            this.reportException(e);
        }
        catch (IllegalAccessException e) {
            this.reportException(e);
        }
        catch (InvocationTargetException e) {
            this.reportException(e);
        }
        catch (ClassCastException e) {
            this.reportException(e);
        }
        return result;
    }

    private void reportException(Throwable throwable) {
        Bundle bundle = FrameworkUtil.getBundle(CellEditorFactory.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
        ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
        reportService.report(new AbstractReport(throwable));
        bundleContext.ungetService(serviceReference);
    }

    private static final class CellEditorDescriptor {
        private final Class<? extends CellEditor> cellEditorClass;
        private final MultiAttributeSWTRendererCellEditorTester tester;

        private CellEditorDescriptor(Class<? extends CellEditor> cellEditorClass, MultiAttributeSWTRendererCellEditorTester tester) {
            this.cellEditorClass = cellEditorClass;
            this.tester = tester;
        }

        private Class<? extends CellEditor> getCellEditorClass() {
            return this.cellEditorClass;
        }

        private MultiAttributeSWTRendererCellEditorTester getTester() {
            return this.tester;
        }
    }
}

