/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt;

import org.eclipse.emf.ecp.view.internal.core.swt.ComboUtil;
import org.eclipse.emf.ecp.view.internal.core.swt.TimeBoundStringBuffer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class MatchItemComboViewer
extends ComboViewer {
    private final TimeBoundStringBuffer searchBuffer = new TimeBoundStringBuffer();
    private String initialText;

    public MatchItemComboViewer(CCombo combo) {
        super(combo);
        this.setupListeners();
    }

    public void onEnter() {
        this.setClosestMatch(this.getCCombo().getText());
    }

    public TimeBoundStringBuffer getBuffer() {
        return this.searchBuffer;
    }

    public void setClosestMatch(String text) {
        boolean matchFound = ComboUtil.setClosestMatch(this.getCCombo(), text);
        if (!matchFound) {
            this.reset();
        }
    }

    protected void onEscape() {
    }

    protected void setupListeners() {
        this.getCCombo().addKeyListener((KeyListener)new MatchItemKeyAdapter());
        this.getCCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MatchItemComboViewer.this.searchBuffer.reset();
            }

            public void focusGained(FocusEvent e) {
                MatchItemComboViewer.this.initialText = MatchItemComboViewer.this.getCCombo().getText();
            }
        });
    }

    protected void reset() {
        this.getCCombo().setText(this.initialText);
        this.searchBuffer.reset();
    }

    class MatchItemKeyAdapter
    extends KeyAdapter {
        MatchItemKeyAdapter() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 27) {
                MatchItemComboViewer.this.onEscape();
            } else if (keyEvent.keyCode == 13) {
                keyEvent.doit = true;
                MatchItemComboViewer.this.onEnter();
                MatchItemComboViewer.this.searchBuffer.reset();
            } else if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                keyEvent.doit = true;
                MatchItemComboViewer.this.searchBuffer.reset();
            } else {
                keyEvent.doit = false;
                if (!Character.isISOControl(keyEvent.character) || keyEvent.keyCode == 8) {
                    MatchItemComboViewer.this.setClosestMatch(MatchItemComboViewer.this.searchBuffer.asString());
                } else if (keyEvent.keyCode != 131072) {
                    MatchItemComboViewer.this.searchBuffer.reset();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.doit = false;
            if (MatchItemComboViewer.this.searchBuffer.timedOut() && keyEvent.keyCode != 13) {
                MatchItemComboViewer.this.searchBuffer.reset();
            }
            if (keyEvent.keyCode == 27) {
                MatchItemComboViewer.this.getCCombo().setText(MatchItemComboViewer.this.initialText);
            } else if (!Character.isISOControl(keyEvent.character)) {
                MatchItemComboViewer.this.searchBuffer.addLast(Character.valueOf(keyEvent.character));
            } else if (keyEvent.keyCode == 8) {
                MatchItemComboViewer.this.searchBuffer.removeLast();
            } else if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                keyEvent.doit = true;
            }
        }
    }
}

