/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.scoped;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceFactory;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceManager;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServicePolicy;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class EMFFormsViewServiceManagerImpl
implements EMFFormsViewServiceManager {
    private final Map<Class<?>, EMFFormsViewServiceFactory<?>> localImmediateMap = new LinkedHashMap();
    private final Map<Class<?>, EMFFormsViewServiceFactory<?>> localLazyMap = new LinkedHashMap();
    private final Map<Class<?>, EMFFormsViewServiceFactory<?>> globalImmediateMap = new LinkedHashMap();
    private final Map<Class<?>, EMFFormsViewServiceFactory<?>> globalLazyMap = new LinkedHashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsScopedServiceProvider(EMFFormsViewServiceFactory<?> provider) {
        Map<Class<?>, EMFFormsViewServiceFactory<?>> serviceProviderMap = this.getServiceProviderMap(provider);
        double currentPrio = Double.NEGATIVE_INFINITY;
        if (serviceProviderMap.containsKey(provider.getType())) {
            currentPrio = serviceProviderMap.get(provider.getType()).getPriority();
        }
        if (currentPrio < provider.getPriority()) {
            serviceProviderMap.put(provider.getType(), provider);
        }
    }

    protected void removeEMFFormsScopedServiceProvider(EMFFormsViewServiceFactory<?> provider) {
        this.getServiceProviderMap(provider).remove(provider.getType());
    }

    private Map<Class<?>, EMFFormsViewServiceFactory<?>> getServiceProviderMap(EMFFormsViewServiceFactory<?> provider) {
        if (provider.getPolicy() == EMFFormsViewServicePolicy.IMMEDIATE && provider.getScope() == EMFFormsViewServiceScope.GLOBAL) {
            return this.globalImmediateMap;
        }
        if (provider.getPolicy() == EMFFormsViewServicePolicy.LAZY && provider.getScope() == EMFFormsViewServiceScope.GLOBAL) {
            return this.globalLazyMap;
        }
        if (provider.getPolicy() == EMFFormsViewServicePolicy.IMMEDIATE && provider.getScope() == EMFFormsViewServiceScope.LOCAL) {
            return this.localImmediateMap;
        }
        if (provider.getPolicy() == EMFFormsViewServicePolicy.LAZY && provider.getScope() == EMFFormsViewServiceScope.LOCAL) {
            return this.localLazyMap;
        }
        throw new IllegalStateException("This should never be reached as we check for all possible cases before.s Only when there is one more combination of policy and scope that we missed this can happen!");
    }

    private <T> Optional<T> getServiceOptional(Class<T> type, Map<Class<?>, EMFFormsViewServiceFactory<?>> classFactoryMap, EMFFormsViewContext emfFormsViewContext) {
        EMFFormsViewServiceFactory<?> serviceProvider = classFactoryMap.get(type);
        if (serviceProvider != null) {
            return Optional.of(serviceProvider.createService(emfFormsViewContext));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> createLocalImmediateService(Class<T> type, EMFFormsViewContext emfFormsViewContext) {
        return this.getServiceOptional(type, this.localImmediateMap, emfFormsViewContext);
    }

    @Override
    public <T> Optional<T> createLocalLazyService(Class<T> type, EMFFormsViewContext emfFormsViewContext) {
        return this.getServiceOptional(type, this.localLazyMap, emfFormsViewContext);
    }

    @Override
    public <T> Optional<T> createGlobalImmediateService(Class<T> type, EMFFormsViewContext emfFormsViewContext) {
        return this.getServiceOptional(type, this.globalImmediateMap, emfFormsViewContext);
    }

    @Override
    public <T> Optional<T> createGlobalLazyService(Class<T> type, EMFFormsViewContext emfFormsViewContext) {
        return this.getServiceOptional(type, this.globalLazyMap, emfFormsViewContext);
    }

    private Set<Class<?>> getAllTypes(Collection<EMFFormsViewServiceFactory<?>> factorySet) {
        TreeSet sortedFactories = new TreeSet(new Comparator<EMFFormsViewServiceFactory<?>>(){

            @Override
            public int compare(EMFFormsViewServiceFactory<?> factory0, EMFFormsViewServiceFactory<?> factory1) {
                int result = Double.compare(factory0.getPriority(), factory1.getPriority());
                if (result == 0) {
                    return 1;
                }
                return result;
            }
        });
        for (EMFFormsViewServiceFactory<?> factory : factorySet) {
            sortedFactories.add(factory);
        }
        LinkedHashSet result = new LinkedHashSet();
        for (EMFFormsViewServiceFactory eMFFormsViewServiceFactory : sortedFactories) {
            result.add(eMFFormsViewServiceFactory.getType());
        }
        return result;
    }

    @Override
    public Set<Class<?>> getAllGlobalImmediateServiceTypes() {
        return this.getAllTypes(this.globalImmediateMap.values());
    }

    @Override
    public Set<Class<?>> getAllLocalImmediateServiceTypes() {
        return this.getAllTypes(this.localImmediateMap.values());
    }
}

