/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.horizontal.fx;

import javafx.scene.Node;
import javafx.scene.control.Pagination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFXFactory;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFactory;
import org.eclipse.emf.ecp.view.spi.horizontal.model.VHorizontalLayout;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;

public class HorizontalLayoutPageRendererFX
extends RendererFX<VHorizontalLayout> {
    private GridDescriptionFX gridDescription;

    public GridDescriptionFX getGridDescription() {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFXFactory.INSTANCE.createSimpleGrid(1, 1, (RendererFX)this);
        }
        return this.gridDescription;
    }

    protected Node renderNode(GridCellFX cell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0) {
            return null;
        }
        final VHorizontalLayout vHorizontal = (VHorizontalLayout)this.getVElement();
        Pagination pagination = new Pagination(vHorizontal.getChildren().size(), 0);
        pagination.setPageFactory((Callback)new Callback<Integer, Node>(){

            public Node call(Integer param) {
                VBox box = new VBox();
                RendererFX compositeRenderer = RendererFactory.INSTANCE.getRenderer((VElement)vHorizontal.getChildren().get(param.intValue()), HorizontalLayoutPageRendererFX.this.getViewModelContext());
                GridDescriptionFX rendererGrid = compositeRenderer.getGridDescription();
                int rows = rendererGrid.getRows();
                int columns = rendererGrid.getColumns();
                int i = 0;
                while (i < rows) {
                    HBox hBox = new HBox();
                    int j = 0;
                    while (j < columns) {
                        Node node = null;
                        try {
                            node = compositeRenderer.render((GridCellFX)rendererGrid.getGrid().get(i * columns + j));
                        }
                        catch (NoRendererFoundException e) {
                            e.printStackTrace();
                        }
                        catch (NoPropertyDescriptorFoundExeption e) {
                            e.printStackTrace();
                        }
                        hBox.getChildren().add(node);
                        ++j;
                    }
                    box.getChildren().add((Object)hBox);
                    ++i;
                }
                return box;
            }
        });
        return pagination;
    }
}

