/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecp.controls.renderer.fx.AbstractDateRendererFX;

public class DateRendererFX
extends AbstractDateRendererFX {
    @Override
    protected UpdateValueStrategy getModelToTargetStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                Date date = (Date)value;
                Instant ins = Instant.ofEpochMilli(date.getTime());
                LocalDate result = LocalDateTime.ofInstant(ins, ZoneId.systemDefault()).toLocalDate();
                return result;
            }
        };
    }

    @Override
    protected UpdateValueStrategy getTargetToModelStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                LocalDate localDate = (LocalDate)value;
                Instant ins = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                Date result = Date.from(ins);
                return result;
            }
        };
    }
}

