/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.fx.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecp.controls.fx.util.ECPTextFieldToModelUpdateValueStrategy;

public class ECPXMLDateFieldToModelUpdateValueStrategy
extends ECPTextFieldToModelUpdateValueStrategy {
    public ECPXMLDateFieldToModelUpdateValueStrategy() {
        IConverter converter = this.getConverter();
        this.setConverter(converter);
    }

    private IConverter getConverter() {
        return new IConverter(){

            public Object getToType() {
                return XMLGregorianCalendar.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object value) {
                DateFormat dateInstance = DateFormat.getDateInstance(2, Locale.getDefault());
                try {
                    Date date = dateInstance.parse((String)value);
                    Calendar targetCal = Calendar.getInstance();
                    targetCal.setTime(date);
                    XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                    cal.setYear(targetCal.get(1));
                    cal.setMonth(targetCal.get(2) + 1);
                    cal.setDay(targetCal.get(5));
                    cal.setTimezone(Integer.MIN_VALUE);
                    return cal;
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                catch (DatatypeConfigurationException e) {
                    e.printStackTrace();
                }
                return value;
            }
        };
    }
}

