/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.fx.util;

import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryListCellFactory;

public final class DialogsUtil {
    private DialogsUtil() {
    }

    public static <T> T selectExistingModelElement(Collection<T> modelElements) {
        final Stage dialogStage = new Stage();
        dialogStage.initStyle(StageStyle.UTILITY);
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"vertical");
        ObservableList listItems = FXCollections.observableArrayList(modelElements);
        final ListView listView = new ListView(listItems);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        listView.setCellFactory((Callback)new AdapterFactoryListCellFactory((AdapterFactory)composedAdapterFactory));
        listView.setMaxHeight(Double.MAX_VALUE);
        listView.setMaxWidth(Double.MAX_VALUE);
        Button okButton = new Button("OK");
        okButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                dialogStage.close();
            }
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                listView.getSelectionModel().clearSelection();
                dialogStage.close();
            }
        });
        dialogStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                listView.getSelectionModel().clearSelection();
                dialogStage.close();
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{okButton, cancelButton});
        gridPane.setVgap(5.0);
        gridPane.add((Node)listView, 0, 0);
        gridPane.add((Node)buttonBox, 0, 1);
        GridPane.setHgrow((Node)listView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)listView, (Priority)Priority.ALWAYS);
        Scene dialogScene = new Scene((Parent)gridPane);
        dialogStage.setScene(dialogScene);
        dialogStage.showAndWait();
        Object selectedElement = listView.getSelectionModel().getSelectedItem();
        composedAdapterFactory.dispose();
        return (T)selectedElement;
    }
}

