/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugElement;
import org.eclipse.ease.debugging.ScriptDebugThread;
import org.eclipse.ease.debugging.ScriptDebugVariable;

public class ScriptDebugStackFrame
extends ScriptDebugElement
implements IStackFrame {
    private final ScriptDebugThread fThread;
    private final IScriptDebugFrame fDebugFrame;
    private final List<ScriptDebugVariable> fVariables = new ArrayList<ScriptDebugVariable>();
    private boolean fDirty = true;

    public ScriptDebugStackFrame(ScriptDebugThread thread, IScriptDebugFrame debugFrame) {
        super(thread.getDebugTarget());
        this.fThread = thread;
        this.fDebugFrame = debugFrame;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fDirty) {
            this.fVariables.clear();
            Map<String, Object> variables = this.getDebugFrame().getVariables();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (entry.getValue() == null) continue;
                ScriptDebugVariable variable = new ScriptDebugVariable(this, entry.getKey(), entry.getValue());
                this.fVariables.add(variable);
            }
            this.fDirty = false;
        }
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    public IVariable[] getVariables(Object value) {
        Map<String, Object> children = this.fDebugFrame.getVariables(value);
        if (children != null && !children.isEmpty()) {
            ArrayList<ScriptDebugVariable> variables = new ArrayList<ScriptDebugVariable>();
            for (Map.Entry<String, Object> entry : children.entrySet()) {
                variables.add(new ScriptDebugVariable(this, entry.getKey(), entry.getValue()));
            }
            return variables.toArray(new IVariable[variables.size()]);
        }
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.getDebugFrame().getLineNumber();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.getScript().toString();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public Script getScript() {
        return this.getDebugFrame().getScript();
    }

    public IScriptDebugFrame getDebugFrame() {
        return this.fDebugFrame;
    }

    public void setDirty() {
        this.fDirty = true;
    }
}

