/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.decorators;

import java.util.Collection;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class TestDecorator
implements ILightweightLabelDecorator {
    private static final String IMAGE_OK = "status_pass.png";
    private static final String IMAGE_ERROR = "status_error.png";
    private static final String IMAGE_FAILURE = "status_failure.png";
    private static final String IMAGE_RUNNING = "status_running.png";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return "test status".equals(property);
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof TestComposite) {
            TestStatus status = ((TestComposite)element).getStatus();
            this.addOverlay(status, decoration);
            if (status != TestStatus.PASS) {
                Collection testEntities = ((TestComposite)element).getChildren();
                int valid = 0;
                for (TestEntity entity : testEntities) {
                    if (entity.getStatus() != TestStatus.PASS) continue;
                    ++valid;
                }
                if (testEntities.size() > 0 && valid != testEntities.size()) {
                    decoration.addSuffix(" (" + valid + "/" + testEntities.size() + " valid)");
                }
            }
        }
    }

    public static ImageDescriptor getImage(String image) {
        return Activator.getImageDescriptor("/icons/ovr16/" + image);
    }

    private void addOverlay(TestStatus status, IDecoration decoration) {
        switch (status) {
            case PASS: {
                decoration.addOverlay(TestDecorator.getImage(IMAGE_OK), 2);
                break;
            }
            case ERROR: {
                decoration.addOverlay(TestDecorator.getImage(IMAGE_ERROR), 2);
                break;
            }
            case FAILURE: {
                decoration.addOverlay(TestDecorator.getImage(IMAGE_FAILURE), 2);
                break;
            }
            case RUNNING: {
                decoration.addOverlay(TestDecorator.getImage(IMAGE_RUNNING), 2);
                break;
            }
        }
    }
}

