/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.git.ui;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GitUiModule
extends AbstractScriptModule {
    @WrapToScript
    public void checkoutBranch(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String branchName) {
        try {
            Ref branchRef = ((Repository)repository).findRef(branchName);
            BranchOperationUI.checkout((Repository)((Repository)repository), (String)branchRef.getName()).start();
        }
        catch (IOException e) {
            Logger.error((String)"org.eclipse.ease.modules.team.git.ui", (String)("Failed to checkout branch " + branchName), (Throwable)e);
        }
    }

    @WrapToScript
    public void createBranch(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository) {
        BranchOperationUI.create((Repository)((Repository)repository)).start();
    }

    @WrapToScript
    public void deleteBranch(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository) {
        BranchOperationUI.delete((Repository)((Repository)repository)).start();
    }

    @WrapToScript
    public void renameBranch(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository) {
        BranchOperationUI.rename((Repository)((Repository)repository)).start();
    }

    @WrapToScript
    public static Repository getRepository(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") ISelection selection) {
        RepositoryNode repositoryNode = (RepositoryNode)((IStructuredSelection)selection).getFirstElement();
        return (Repository)repositoryNode.getObject();
    }

    @WrapToScript
    public void handleUncommittedFiles(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    UIRepositoryUtils.handleUncommittedFiles((Repository)((Repository)repository), (Shell)Display.getDefault().getActiveShell());
                }
                catch (GitAPIException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @WrapToScript
    public void rebaseOn(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String branchName) {
        Job job = new Job("Rebasing on " + branchName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Ref branchRef = ((Repository)repository).findRef(branchName);
                    RebaseOperation op = new RebaseOperation((Repository)repository, branchRef);
                    op.execute(monitor);
                    if (op.getResult().getStatus().isSuccessful()) {
                        return Status.OK_STATUS;
                    }
                }
                catch (IOException e) {
                    return GitUiModule.this.createErrorStatus(e);
                }
                catch (CoreException e) {
                    return GitUiModule.this.createErrorStatus((Exception)((Object)e));
                }
                return GitUiModule.this.createErrorStatus("Rebase failed");
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @WrapToScript
    public void mergeFrom(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String branchName) {
        Job job = new Job("Merging " + branchName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Ref branchRef = ((Repository)repository).findRef(branchName);
                    MergeOperation op = new MergeOperation((Repository)repository, branchRef.getName());
                    op.setSquash(false);
                    op.setFastForwardMode(MergeCommand.FastForwardMode.FF);
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (IOException e) {
                    return GitUiModule.this.createErrorStatus(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @WrapToScript
    public void resetCommits(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object repository, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer commits) {
        Job job = new Job("Rebasing " + commits + " commits"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResetOperation resetOperation = new ResetOperation((Repository)repository, "HEAD~" + commits.toString(), ResetCommand.ResetType.HARD);
                    resetOperation.execute(monitor);
                }
                catch (CoreException e) {
                    return GitUiModule.this.createErrorStatus((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus createErrorStatus(Exception e) {
        return new Status(4, "org.eclipse.ease.modules.team.git.ui", e.getMessage(), (Throwable)e);
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.ease.modules.team.git.ui", message);
    }
}

