/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.handler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.ui.dialogs.CreateReportDialog;
import org.eclipse.ease.modules.unittest.ui.views.UnitTestView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateReport
extends AbstractHandler
implements IHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof UnitTestView) {
            TestSuite suite = ((UnitTestView)part).getCurrentSuite();
            CreateReportDialog dialog = new CreateReportDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (dialog.open() == 0) {
                try {
                    String filename = dialog.getFileName();
                    String extension = "." + dialog.getReport().getDefaultExtension();
                    if (!filename.toLowerCase().endsWith(extension)) {
                        filename = String.valueOf(filename) + extension;
                    }
                    FileWriter writer = new FileWriter(new File(filename));
                    writer.write(dialog.getReport().createReport(dialog.getTitle(), dialog.getDescription(), suite));
                    writer.close();
                    if (dialog.isOpenReport()) {
                        if (Platform.getOS().startsWith("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + new File(filename).toURI().toString());
                        } else if (Platform.getOS().startsWith("linux")) {
                            String desktop = System.getenv("XDG_CURRENT_DESKTOP");
                            if (desktop == null) {
                                desktop = System.getenv("sun.desktop");
                            }
                            if ("KDE".equalsIgnoreCase(desktop)) {
                                Runtime.getRuntime().exec("kfmclient exec " + new File(filename).toURI().toString());
                            } else if ("GNOME".equalsIgnoreCase(desktop)) {
                                Runtime.getRuntime().exec("gnome-open " + new File(filename).toURI().toString());
                            }
                        } else {
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Could not open report", (String)("Support for your platform (" + Platform.getOS() + ") not implemented. Please raise a bug if needed."));
                        }
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Create Report failed", (String)"Could not open file for writing. Report could not be saved");
                    Logger.logError((String)("Could not create report file \"" + dialog.getFileName() + "\""), (Throwable)e);
                }
            }
        }
        return null;
    }
}

