/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.model;

import org.eclipse.ease.helpgenerator.IMemento;

public class Category {
    private final IMemento fDefinition;

    public Category(IMemento definition) {
        this.fDefinition = definition;
    }

    public String getName() {
        return this.fDefinition.getString("name");
    }

    public String getHelpLink() {
        return Category.createCategoryLink(this.fDefinition.getString("parent"));
    }

    public String getFileName() {
        return Category.createCategoryFileName(this.fDefinition.getString("id"));
    }

    public static String createCategoryLink(String categoryId) {
        int index;
        String pluginID = "org.eclipse.ease.help";
        if (categoryId != null && (index = categoryId.indexOf(".category.")) != -1) {
            pluginID = categoryId.substring(0, index);
        }
        return "../" + pluginID + "/help/" + Category.createCategoryFileName(categoryId) + "#modules_anchor";
    }

    public static String createCategoryFileName(String categoryId) {
        String category = Category.extractCategoryName(categoryId);
        return category != null ? "category_" + category + ".xml" : "reference.xml";
    }

    private static String extractCategoryName(String categoryId) {
        int index;
        if (categoryId != null && (index = categoryId.indexOf(".category.")) != -1) {
            return categoryId.substring(index + ".category.".length());
        }
        return null;
    }
}

