/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.widgets.connection.spline;

import org.eclipse.dirigible.ide.ui.widgets.connection.spline.Spline;

public class TwoPointSpline
implements Spline {
    private final int x1;
    private final int x2;
    private final int y1;
    private final int y2;

    public TwoPointSpline(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public int getX(float amount) {
        amount = this.fixAmount(amount);
        return this.x1 + (int)((float)(this.x2 - this.x1) * amount);
    }

    @Override
    public int getY(float amount) {
        if ((amount = this.fixAmount(amount)) < 0.5f) {
            return this.y1 + this.getOffset(amount);
        }
        return this.y2 - this.getOffset(1.0f - amount);
    }

    private float fixAmount(float amount) {
        float result = amount;
        if (result < 0.0f) {
            result = 0.0f;
        }
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    private int getOffset(float amount) {
        if (this.y2 == this.y1) {
            return 0;
        }
        float coef = (float)(this.y2 - this.y1) / 0.5f;
        return (int)(coef * amount * amount);
    }
}

