/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.command;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractClipboardHandler
extends AbstractHandler {
    public static final String CUT = "REPOSITORY_CUT";
    public static final String COPY = "REPOSITORY_COPY";
    public static final String PASTE = "REPOSITORY_PASTE";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute(event, (IStructuredSelection)selection);
        }
        return null;
    }

    public void execute(ExecutionEvent event, IStructuredSelection selection) {
        ResourceComparator comparator = new ResourceComparator();
        TreeSet<IEntity> resources = new TreeSet<IEntity>(comparator);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IEntity) {
                resources.add((IEntity)element);
            }
            ++n2;
        }
        this.execute(event, resources);
    }

    protected abstract void execute(ExecutionEvent var1, SortedSet<IEntity> var2);

    private class ResourceComparator
    implements Comparator<IEntity> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IEntity o1, IEntity o2) {
            String path1 = o1.getPath().toString();
            String path2 = o2.getPath().toString();
            return path2.compareTo(path1);
        }
    }
}

