/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.AbstractComparisonMethod;

public class DefaultComparisonMethod
extends AbstractComparisonMethod {
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
    private Role _twoWayReferenceRole;
    private IMatchPolicy _matchPolicy;
    private IDiffPolicy _diffPolicy;
    private IMergePolicy _mergePolicy;

    public DefaultComparisonMethod(IModelScopeDefinition leftScopeSpec_p, IModelScopeDefinition rightScopeSpec_p, IModelScopeDefinition ancestorScopeSpec_p) {
        this._roleToScopeDefinition.put(Role.TARGET, leftScopeSpec_p);
        this._roleToScopeDefinition.put(Role.REFERENCE, rightScopeSpec_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, ancestorScopeSpec_p);
        this._twoWayReferenceRole = null;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
    }

    protected IDiffPolicy createDiffPolicy() {
        return null;
    }

    protected IMatchPolicy createMatchPolicy() {
        return null;
    }

    protected IMergePolicy createMergePolicy() {
        return null;
    }

    public IModelScopeDefinition getModelScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public final IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public final IMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public final IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay() && Role.TARGET == role_p || Role.REFERENCE == role_p) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = false;
        IModelScopeDefinition scope1 = this.getModelScopeDefinition(role1_p);
        IModelScopeDefinition scope2 = this.getModelScopeDefinition(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeDefinition.put(role1_p, scope2);
            this._roleToScopeDefinition.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

