/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.svn.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.svn.EMFDiffMergeSVNConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.svn.Messages;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNHistoryURIConverter
extends ExtensibleURIConverterImpl {
    protected static final String SVN_SCHEME = "svn";
    protected final IRepositoryLocation _repoLocation;
    protected final SVNRevision _revision;

    public SVNHistoryURIConverter(IRepositoryLocation repositoryLocation_p, SVNRevision revision_p) {
        this._repoLocation = repositoryLocation_p;
        this._revision = revision_p;
    }

    public InputStream createInputStream(URI uri_p, Map<?, ?> options_p) throws IOException {
        String scheme = uri_p.scheme();
        if (scheme != null && scheme.startsWith(SVN_SCHEME)) {
            String basepath = this._repoLocation.getRepositoryRootUrl();
            List basePathSegmentsList = URI.createURI((String)basepath).segmentsList();
            ArrayList newPathList = new ArrayList(uri_p.segmentsList());
            newPathList.removeAll(basePathSegmentsList);
            Path newPath = new Path(URI.createHierarchicalURI((String[])newPathList.toArray(new String[0]), (String)uri_p.query(), (String)uri_p.fragment()).devicePath());
            IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)newPath);
            if (target.exists()) {
                GetLocalFileContentOperation op;
                if (this._revision.equals((Object)SVNRevision.BASE)) {
                    op = new GetLocalFileContentOperation((IResource)target, SVNRevision.BASE.getKind());
                } else {
                    IRepositoryResource res = SVNRemoteStorage.instance().asRepositoryResource((IResource)target);
                    res.setSelectedRevision(this._revision);
                    op = new GetFileContentOperation(res);
                }
                op.run((IProgressMonitor)new NullProgressMonitor());
                if (op.getExecutionState() != 0) {
                    EMFDiffMergeSVNConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeSVNConnectorPlugin.getDefault().getPluginId(), String.format(Messages.SVNHistoryURIConverter_CannotLoad, op.getStatus().getMessage())));
                }
                return op.getContent();
            }
            EMFDiffMergeSVNConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeSVNConnectorPlugin.getDefault().getPluginId(), String.format(Messages.SVNHistoryURIConverter_CannotLoad_Located, uri_p)));
        }
        return super.createInputStream(uri_p, options_p);
    }
}

