/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.LocalFileRevision;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractRevisionScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.core.ext.LocalHistoryURIConverter;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexOursURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.team.core.history.IFileRevision;

public class GitIndexRevisionScopeDefinitionFactory
extends AbstractRevisionScopeDefinitionFactory {
    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        String result = null;
        if (entrypoint_p instanceof EditableRevision) {
            if (revision_p instanceof IndexFileRevision) {
                result = this.isScopeEditable(entrypoint_p) ? String.format(Messages.GitIndexRevisionScopeDefinitionFactory_LabelIndexEditable, revision_p.getName()) : String.format(Messages.GitIndexRevisionScopeDefinitionFactory_LabelIndexReadOnly, revision_p.getName());
            } else if (revision_p instanceof LocalFileRevision) {
                result = String.format(Messages.GitIndexRevisionScopeDefinitionFactory_LabelLocal, this.getLocalFileRevisionPath((LocalFileRevision)revision_p));
            }
        }
        if (result == null) {
            result = super.getLabelForRevision(revision_p, entrypoint_p);
        }
        return result;
    }

    protected String getLocalFileRevisionPath(LocalFileRevision revision_p) {
        return revision_p.getFile().getFullPath().toString();
    }

    protected IFileRevision getRevision(ITypedElement typedElement_p) {
        IFileRevision result = typedElement_p instanceof EditableRevision ? ((EditableRevision)typedElement_p).getFileRevision() : super.getRevision(typedElement_p);
        return result;
    }

    protected URIConverter getURIConverterForRevision(IFileRevision revision_p) throws CoreException {
        if (revision_p instanceof IndexFileRevision) {
            try {
                if (GitHelper.INSTANCE.isConflicting(revision_p)) {
                    return new GitIndexOursURIConverter(GitHelper.INSTANCE.getRepository(revision_p), ((IndexFileRevision)revision_p).getGitPath());
                }
                return new GitIndexURIConverter(GitHelper.INSTANCE.getRepository(revision_p));
            }
            catch (IOException e) {
                EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
            catch (NoWorkTreeException e) {
                EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        if (revision_p instanceof LocalFileRevision) {
            String fullPath = this.getLocalFileRevisionPath((LocalFileRevision)revision_p);
            long timestamp = revision_p.getTimestamp();
            if (timestamp != -1L) {
                return new LocalHistoryURIConverter(timestamp, fullPath);
            }
        }
        return null;
    }

    protected URI getURIForRevision(IFileRevision revision_p) throws CoreException {
        URI result;
        block6: {
            result = null;
            if (revision_p instanceof IndexFileRevision) {
                try {
                    boolean conflicting = GitHelper.INSTANCE.isConflicting(revision_p);
                    if (conflicting) {
                        result = URI.createPlatformResourceURI((String)revision_p.getURI().toString(), (boolean)true);
                        break block6;
                    }
                    result = URI.createURI((String)(String.valueOf(GitHelper.INSTANCE.getSchemeIndex()) + GitHelper.INSTANCE.getSchemeSeparator() + revision_p.getURI().toString()));
                }
                catch (Exception e) {
                    EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
                }
            } else if (revision_p instanceof LocalFileRevision) {
                result = URI.createPlatformResourceURI((String)this.getLocalFileRevisionPath((LocalFileRevision)revision_p), (boolean)true);
            }
        }
        return result;
    }

    protected boolean isApplicableToRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        return entrypoint_p instanceof EditableRevision;
    }

    protected boolean isScopeEditable(Object entrypoint_p) {
        return entrypoint_p instanceof IEditableContent;
    }
}

