/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupWizard;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.specification.IOverridableFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ComparisonSetupManager {
    private static final String MODEL_COMPARISON_CONTEXT_EXTENSION_POINT = "org.eclipse.emf.diffmerge.ui.modelComparisonContext";
    private static final String EXTENSION_POINT_METHOD = "comparisonMethod";
    private static final String EXTENSION_POINT_PROPERTY_METHOD = "factory";
    private static final String EXTENSION_POINT_SCOPE = "scopeDefinition";
    private static final String EXTENSION_POINT_PROPERTY_SCOPE = "factory";
    private Map<Class<?>, IComparisonMethodFactory> _comparisonFactories = null;
    private Map<Class<?>, IModelScopeDefinitionFactory> _scopeFactories = null;

    public EMFDiffMergeEditorInput createDefaultEditorInput(Object entrypoint1_p, Object entrypoint2_p, Object entrypoint3_p) {
        EMFDiffMergeEditorInput result = null;
        try {
            ComparisonSetup setup = this.createComparisonSetup(entrypoint1_p, entrypoint2_p, entrypoint3_p);
            if (setup != null && setup.getComparisonMethod() != null) {
                result = new EMFDiffMergeEditorInput(setup.getComparisonMethod());
            }
        }
        catch (IllegalArgumentException e) {
            this.handleSetupError(null, e.getLocalizedMessage());
        }
        return result;
    }

    public EMFDiffMergeEditorInput createEditorInputWithUI(Shell shell_p, Object entrypoint1_p, Object entrypoint2_p, Object entrypoint3_p) {
        EMFDiffMergeEditorInput result = null;
        try {
            ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
            ComparisonSetup setup = manager.createComparisonSetup(entrypoint1_p, entrypoint2_p, entrypoint3_p);
            result = this.createEditorInputWithUI(shell_p, setup);
        }
        catch (IllegalArgumentException e) {
            this.handleSetupError(shell_p, e.getLocalizedMessage());
        }
        return result;
    }

    public EMFDiffMergeEditorInput createEditorInputWithUI(Shell shell_p, ComparisonSetup setup_p) {
        EMFDiffMergeEditorInput result = null;
        if (setup_p != null) {
            IComparisonMethod method = this.openSetupWizard(shell_p, setup_p);
            if (method != null) {
                result = new EMFDiffMergeEditorInput(method);
            }
        } else {
            this.handleSetupError(shell_p, null);
        }
        return result;
    }

    public ComparisonSetup createComparisonSetup(Object entrypoint1_p, Object entrypoint2_p, Object entrypoint3_p) {
        List factories3;
        ComparisonSetup result = null;
        List<IModelScopeDefinitionFactory> factories1 = this.getApplicableModelScopeFactories(entrypoint1_p);
        List<IModelScopeDefinitionFactory> factories2 = this.getApplicableModelScopeFactories(entrypoint2_p);
        List<Object> list = factories3 = entrypoint3_p == null ? Collections.emptyList() : this.getApplicableModelScopeFactories(entrypoint3_p);
        if (!factories1.isEmpty() && !factories2.isEmpty()) {
            try {
                IModelScopeDefinition scopeSpec1 = factories1.get(0).createScopeDefinition(entrypoint1_p, null, true);
                IModelScopeDefinition scopeSpec2 = factories2.get(0).createScopeDefinition(entrypoint2_p, null, true);
                IModelScopeDefinition scopeSpec3 = factories3.isEmpty() ? null : ((IModelScopeDefinitionFactory)factories3.get(0)).createScopeDefinition(entrypoint3_p, null, true);
                List<IComparisonMethodFactory> cFactories = this.getApplicableComparisonMethodFactories(scopeSpec1, scopeSpec2, scopeSpec3);
                if (!cFactories.isEmpty()) {
                    result = new ComparisonSetup(scopeSpec1, scopeSpec2, scopeSpec3, cFactories);
                }
            }
            catch (Exception e) {
                EMFDiffMergeUIPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeUIPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        } else {
            this.handleUnsupportedEntrypoints(factories1.isEmpty() ? entrypoint1_p : null, factories2.isEmpty() ? entrypoint2_p : null);
        }
        return result;
    }

    protected void discoverRegisteredComparisonContexts() {
        IConfigurationElement[] config;
        this._comparisonFactories = new HashMap();
        this._scopeFactories = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(MODEL_COMPARISON_CONTEXT_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            Object o2;
            IConfigurationElement e = iConfigurationElementArray[n2];
            String name = e.getName();
            if (EXTENSION_POINT_METHOD.equals(name)) {
                try {
                    o2 = e.createExecutableExtension("factory");
                    if (o2 instanceof IComparisonMethodFactory) {
                        this._comparisonFactories.put(o2.getClass(), (IComparisonMethodFactory)o2);
                    }
                }
                catch (CoreException o2) {}
            } else if (EXTENSION_POINT_SCOPE.equals(name)) {
                try {
                    o2 = e.createExecutableExtension("factory");
                    if (o2 instanceof IModelScopeDefinitionFactory) {
                        this._scopeFactories.put(o2.getClass(), (IModelScopeDefinitionFactory)o2);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public List<IComparisonMethodFactory> getApplicableComparisonMethodFactories(IModelScopeDefinition leftScopeSpec_p, IModelScopeDefinition rightScopeSpec_p, IModelScopeDefinition ancestorScopeSpec_p) {
        ArrayList<IComparisonMethodFactory> result = new ArrayList();
        for (IComparisonMethodFactory factory : this.getRegisteredComparisonMethodFactories()) {
            if (!factory.isApplicableTo(leftScopeSpec_p, rightScopeSpec_p, ancestorScopeSpec_p)) continue;
            result.add(factory);
        }
        result = this.reduceByOverride(result, this._comparisonFactories);
        return result;
    }

    public List<IModelScopeDefinitionFactory> getApplicableModelScopeFactories(Object entrypoint_p) {
        List<Object> result = new ArrayList();
        for (IModelScopeDefinitionFactory factory : this.getRegisteredModelScopeDefinitionFactories()) {
            if (!factory.isApplicableTo(entrypoint_p)) continue;
            result.add(factory);
        }
        result = this.reduceByOverride(result, this._scopeFactories);
        return Collections.unmodifiableList(result);
    }

    protected final Collection<IComparisonMethodFactory> getRegisteredComparisonMethodFactories() {
        if (this._comparisonFactories == null) {
            this.discoverRegisteredComparisonContexts();
        }
        return this._comparisonFactories.values();
    }

    protected final Collection<IModelScopeDefinitionFactory> getRegisteredModelScopeDefinitionFactories() {
        if (this._scopeFactories == null) {
            this.discoverRegisteredComparisonContexts();
        }
        return this._scopeFactories.values();
    }

    public void handleSetupError(Shell shell_p, String message_p) {
        String message;
        String string = message = message_p != null ? message_p : Messages.CompareModelsAction_ModelsOnly;
        if (shell_p != null) {
            MessageDialog.openError((Shell)shell_p, (String)EMFDiffMergeUIPlugin.LABEL, (String)message);
        } else {
            EMFDiffMergeUIPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeUIPlugin.getDefault().getPluginId(), message, null));
        }
    }

    protected void handleUnsupportedEntrypoints(Object unsupportedLeft_p, Object unsupportedRight_p) {
        boolean rightKO;
        StringBuilder msgBuilder = new StringBuilder();
        boolean leftKO = unsupportedLeft_p != null;
        boolean bl = rightKO = unsupportedRight_p != null;
        if (leftKO) {
            String leftMessage;
            if (unsupportedLeft_p instanceof ITypedElement) {
                String leftName = ((ITypedElement)unsupportedLeft_p).getName();
                leftMessage = String.format(Messages.ComparisonSetupManager_CannotLoadLeftKnown, leftName);
            } else {
                leftMessage = Messages.ComparisonSetupManager_CannotLoadLeftUnknown;
            }
            msgBuilder.append(leftMessage);
        }
        if (leftKO && rightKO) {
            msgBuilder.append('\n');
        }
        if (rightKO) {
            String rightMessage;
            if (unsupportedRight_p instanceof ITypedElement) {
                String rightName = ((ITypedElement)unsupportedRight_p).getName();
                rightMessage = String.format(Messages.ComparisonSetupManager_CannotLoadRightKnown, rightName);
            } else {
                rightMessage = Messages.ComparisonSetupManager_CannotLoadRightUnknown;
            }
            msgBuilder.append(rightMessage);
        }
        throw new IllegalArgumentException(msgBuilder.toString());
    }

    public boolean isValidEntrypoint(Object entrypoint_p) {
        for (IModelScopeDefinitionFactory factory : this.getRegisteredModelScopeDefinitionFactories()) {
            if (!factory.isApplicableTo(entrypoint_p)) continue;
            return true;
        }
        return false;
    }

    protected IComparisonMethod openSetupWizard(Shell shell_p, ComparisonSetup setup_p) {
        IComparisonMethod result = null;
        ComparisonSetupWizard wizard = new ComparisonSetupWizard(setup_p);
        WizardDialog dialog = new WizardDialog(shell_p, (IWizard)wizard);
        dialog.setHelpAvailable(false);
        int openResult = dialog.open();
        if (openResult == 0) {
            result = setup_p.getComparisonMethod();
        }
        return result;
    }

    protected <T extends IOverridableFactory> List<T> reduceByOverride(List<T> factories_p, Map<Class<?>, T> configurationFactories_p) {
        ArrayList<T> result = new ArrayList<T>(factories_p);
        for (IOverridableFactory factory : factories_p) {
            for (Class<?> factoryClass : factory.getOverridenClasses()) {
                result.remove(configurationFactories_p.get(factoryClass));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean updateEditorInputWithUI(Shell shell_p, EMFDiffMergeEditorInput input_p) {
        assert (input_p.getComparisonMethod() != null);
        boolean result = false;
        ComparisonSetup setup = new ComparisonSetup(input_p.getComparisonMethod());
        setup.setCanSwapScopeDefinitions(false);
        IComparisonMethod method = this.openSetupWizard(shell_p, setup);
        if (method != null) {
            input_p.setComparisonMethod(method);
            result = true;
        }
        return result;
    }
}

