/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.common.comparable;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.emf.diffmerge.structures.Structures;
import org.eclipse.emf.diffmerge.structures.common.comparable.IComparableStructure;

public class ComparableLinkedList<E extends Comparable<?>>
extends LinkedList<E>
implements IComparableStructure.IComparableList<E> {
    private static final long serialVersionUID = 1L;
    private final boolean _useEquals;

    public ComparableLinkedList() {
        this(true);
    }

    public ComparableLinkedList(boolean useEquals_p) {
        this._useEquals = useEquals_p;
    }

    public ComparableLinkedList(Collection<? extends E> collection_p, boolean useEquals_p) {
        super(collection_p);
        this._useEquals = useEquals_p;
    }

    protected boolean areEqual(Object o1_p, Object o2_p) {
        boolean result = this.useEquals() ? o1_p != null && o1_p.equals(o2_p) || o1_p == null && o2_p == null : o1_p == o2_p;
        return result;
    }

    @Override
    public int compareTo(IComparableStructure<?> o_p) {
        return STRUCTURE_COMPARATOR.compare(this, o_p);
    }

    @Override
    public Iterator<E> getCompareIterator() {
        return this.iterator();
    }

    @Override
    public int indexOf(Object object_p) {
        ListIterator it = this.listIterator();
        int i = 0;
        while (it.hasNext()) {
            if (this.areEqual(object_p, it.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object_p) {
        int i = this.size();
        ListIterator it = this.listIterator(i);
        while (it.hasPrevious()) {
            --i;
            if (!this.areEqual(object_p, it.previous())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(Object object_p) {
        boolean result;
        int i = this.indexOf(object_p);
        boolean bl = result = i >= 0;
        if (result) {
            this.remove(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return Structures.toIterableString(this);
    }

    protected boolean useEquals() {
        return this._useEquals;
    }
}

