/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.diffmerge.util.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FHashMap<K, V>
extends BasicEMap<K, V>
implements IEqualityBasedStructure {
    private static final long serialVersionUID = 1L;
    private final IEqualityTester _equalityTester;

    public FHashMap() {
        this(null);
    }

    public FHashMap(IEqualityTester tester_p) {
        this._equalityTester = tester_p != null ? tester_p : DEFAULT_TESTER;
    }

    public FHashMap(int initialCapacity_p, IEqualityTester tester_p) {
        super(initialCapacity_p);
        this._equalityTester = tester_p != null ? tester_p : DEFAULT_TESTER;
    }

    public FHashMap(Map<? extends K, ? extends V> map_p, IEqualityTester tester_p) {
        super(2 * map_p.size());
        this._equalityTester = tester_p != null ? tester_p : DEFAULT_TESTER;
        this.putAll(map_p);
    }

    protected BasicEMap.Entry<K, V> entryForKey(int index_p, int hash_p, Object key_p) {
        BasicEList eList = this.entryData[index_p];
        if (eList != null) {
            int j = 0;
            while (j < eList.size()) {
                BasicEMap.Entry entry = (BasicEMap.Entry)eList.basicGet(j);
                if (entry.getHash() == hash_p && this.getEqualityTester().areEqual(key_p, entry.getKey())) {
                    return entry;
                }
                ++j;
            }
        }
        return null;
    }

    protected int entryIndexForKey(int index_p, int hash_p, Object key_p) {
        BasicEList eList = this.entryData[index_p];
        if (eList != null) {
            int j = 0;
            while (j < eList.size()) {
                BasicEMap.Entry entry = (BasicEMap.Entry)eList.basicGet(j);
                if (entry.getHash() == hash_p && this.getEqualityTester().areEqual(key_p, entry.getKey())) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public IEqualityTester getEqualityTester() {
        return this._equalityTester;
    }

    protected int hashOf(Object key_p) {
        return key_p == null ? 0 : this.getEqualityTester().hashCodeFor(key_p);
    }

    public int indexOfKey(Object key_p) {
        this.size = this.delegateEList.size();
        int i = 0;
        while (i < this.size) {
            BasicEMap.Entry entry = (BasicEMap.Entry)this.delegateEList.get(i);
            if (this.getEqualityTester().areEqual(key_p, entry.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final boolean useEqualsForKey() {
        return false;
    }

    protected final boolean useEqualsForValue() {
        return false;
    }
}

