/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractRevisionScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.emf.diffmerge.connector.git.ext.GitCommitURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexTheirsURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;

public class GitRevisionScopeDefinitionFactory
extends AbstractRevisionScopeDefinitionFactory {
    protected static final int ABBREVIATE_COMMIT_LABEL_SIZE = 7;

    protected String getContentIdentifier(RevCommit revCommit_p) {
        StringBuilder s = new StringBuilder();
        if (revCommit_p != null) {
            s.append(revCommit_p.abbreviate(7).name());
            s.append("...");
            PersonIdent authorIdent = revCommit_p.getAuthorIdent();
            if (authorIdent != null) {
                s.append(" (");
                s.append(authorIdent.getName());
                s.append(')');
            }
        }
        return s.toString();
    }

    protected URIConverter getURIConverterForRevision(IFileRevision revision) throws CoreException {
        Repository repo;
        IPath path;
        Repository repo2;
        Object result = null;
        IResourceVariant variant = this.getVariant(revision);
        if (variant instanceof GitRemoteResource && (repo2 = GitHelper.INSTANCE.getRepository(path = ((GitRemoteResource)variant).getDisplayPath())) != null) {
            result = new GitCommitURIConverter(((GitRemoteResource)variant).getCommitId(), repo2);
        }
        if (result == null && (repo = GitHelper.INSTANCE.getRepository(revision)) != null) {
            if (revision instanceof IndexFileRevision) {
                result = new GitIndexTheirsURIConverter(repo);
            } else if (revision instanceof CommitFileRevision) {
                result = new GitCommitURIConverter(((CommitFileRevision)revision).getRevCommit(), repo);
            }
        }
        if (result == null) {
            result = super.getURIConverterForRevision(revision);
        }
        return result;
    }

    protected URI getURIForRevision(IFileRevision revision) throws CoreException {
        IResourceVariant variant = this.getVariant(revision);
        String SCHEME_SEP = ":/";
        URI result = variant instanceof GitRemoteResource ? URI.createURI((String)(String.valueOf(GitHelper.INSTANCE.getSchemeRemote()) + ":/" + ((GitRemoteResource)variant).getPath())) : (revision instanceof IndexFileRevision ? URI.createURI((String)(String.valueOf(GitHelper.INSTANCE.getSchemeIndex()) + ":/" + revision.getURI().toString())) : (revision instanceof CommitFileRevision ? URI.createURI((String)(String.valueOf(GitHelper.INSTANCE.getSchemeCommit()) + ":/" + revision.getURI().toString())) : super.getURIForRevision(revision)));
        return result;
    }

    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        IResourceVariant variant = this.getVariant(revision_p);
        String result = variant instanceof GitRemoteResource ? String.format(Messages.GitRevisionScopeDefinitionFactory_LabelRemote, revision_p.getName(), variant.getContentIdentifier()) : (revision_p instanceof IndexFileRevision ? String.format(Messages.GitRevisionScopeDefinitionFactory_LabelIndex, revision_p.getName()) : (revision_p instanceof CommitFileRevision ? String.format(Messages.GitRevisionScopeDefinitionFactory_LabelCommit, revision_p.getName(), this.getContentIdentifier(((CommitFileRevision)revision_p).getRevCommit())) : (revision_p instanceof WorkspaceFileRevision ? String.format(Messages.GitRevisionScopeDefinitionFactory_LabelWorkspace, revision_p.getName()) : super.getLabelForRevision(revision_p, entrypoint_p))));
        return result;
    }

    protected boolean isApplicableToRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        return revision_p instanceof GitFileRevision || this.getVariant(revision_p) instanceof GitRemoteResource;
    }
}

