/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.svn.ext;

import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractRevisionScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.svn.Messages;
import org.eclipse.emf.diffmerge.connector.svn.ext.SVNHistoryURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.variant.BaseFileVariant;
import org.eclipse.team.svn.core.synchronize.variant.RemoteFileVariant;

public class SVNRevisionScopeDefinitionFactory
extends AbstractRevisionScopeDefinitionFactory {
    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        String result = null;
        IResourceVariant variant = this.getVariant(revision_p);
        if (variant != null) {
            result = String.format(Messages.SVNRevisionScopeDefinitionFactory_LabelRevision, variant.getContentIdentifier());
        }
        return result;
    }

    protected URIConverter getURIConverterForRevision(IFileRevision revision_p) throws CoreException {
        ExtensibleURIConverterImpl result = null;
        IResourceVariant variant = this.getVariant(revision_p);
        if (variant instanceof BaseFileVariant) {
            ILocalResource res = ((BaseFileVariant)variant).getResource();
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(res.getResource());
            result = new SVNHistoryURIConverter(location, SVNRevision.fromString((String)variant.getContentIdentifier()));
        } else {
            result = new ExtensibleURIConverterImpl();
        }
        return result;
    }

    protected URI getURIForRevision(IFileRevision revision_p) throws CoreException {
        URI result = null;
        IResourceVariant variant = this.getVariant(revision_p);
        if (variant instanceof BaseFileVariant) {
            ILocalResource res = ((BaseFileVariant)variant).getResource();
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(res.getResource());
            result = URI.createURI((String)(String.valueOf(location.getRepositoryRootUrl()) + ((BaseFileVariant)variant).getResource().getResource().getFullPath()), (boolean)true);
        } else {
            IStorage storage = this.getStorage(revision_p);
            if (storage != null) {
                result = this.toFileURI(storage.getFullPath().toString());
            }
        }
        return result;
    }

    protected boolean isApplicableToRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        IResourceVariant variant = this.getVariant(revision_p);
        return variant instanceof BaseFileVariant || variant instanceof RemoteFileVariant;
    }
}

