/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.impl.AbstractPatternDataImpl;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.ITemplatePatternEngine;
import org.eclipse.emf.diffmerge.patterns.templates.gen.TemplatePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.InstanceCounterpart;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplateCounterpart;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsPackage;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.impl.InstanceIdEntryImpl;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.impl.TemplateIdEntryImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePatternDataImpl
extends AbstractPatternDataImpl
implements TemplatePatternData {
    protected static final String NAMING_RULE_EDEFAULT = null;
    protected String namingRule = NAMING_RULE_EDEFAULT;
    protected static final int MULTIPLICITY_EDEFAULT = 0;
    protected int multiplicity = 0;
    protected EMap<String, InstanceCounterpart> instanceIds;
    protected EMap<String, TemplateCounterpart> templateIds;
    protected EList<String> unfoldedIds;
    private transient Map<String, EObject> _instanceIdsToElements = null;
    private transient boolean _initialized = false;

    protected TemplatePatternDataImpl() {
    }

    protected EClass eStaticClass() {
        return TemplatepatternsPackage.Literals.TEMPLATE_PATTERN_DATA;
    }

    @Override
    public EMap<String, InstanceCounterpart> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new EcoreEMap(TemplatepatternsPackage.Literals.INSTANCE_ID_ENTRY, InstanceIdEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.instanceIds;
    }

    @Override
    public String getNamingRule() {
        return this.namingRule;
    }

    @Override
    public void setNamingRule(String newNamingRule) {
        String oldNamingRule = this.namingRule;
        this.namingRule = newNamingRule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldNamingRule, (Object)this.namingRule));
        }
    }

    @Override
    public int getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public void setMultiplicity(int newMultiplicity) {
        int oldMultiplicity = this.multiplicity;
        this.multiplicity = newMultiplicity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldMultiplicity, this.multiplicity));
        }
    }

    @Override
    public EMap<String, TemplateCounterpart> getTemplateIds() {
        if (this.templateIds == null) {
            this.templateIds = new EcoreEMap(TemplatepatternsPackage.Literals.TEMPLATE_ID_ENTRY, TemplateIdEntryImpl.class, (InternalEObject)this, 5);
        }
        return this.templateIds;
    }

    @Override
    public EList<String> getUnfoldedIds() {
        if (this.unfoldedIds == null) {
            this.unfoldedIds = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 6);
        }
        return this.unfoldedIds;
    }

    private EList<EObject> checkInstanceElements() {
        ModelsUtil.RList result = this.checkInstanceElementsInitialized();
        if (result == null) {
            result = new ModelsUtil.RList();
            HashMap<String, EObject> clone = new HashMap<String, EObject>(this._instanceIdsToElements);
            for (Map.Entry entry : clone.entrySet()) {
                EObject instanceElement = (EObject)entry.getValue();
                if (this.isInModel(instanceElement)) {
                    result.add((Object)instanceElement);
                    continue;
                }
                this.removeInstanceId((String)entry.getKey());
            }
        }
        return ECollections.unmodifiableEList(result);
    }

    private EList<EObject> checkInstanceElementsInitialized() {
        boolean needsInitialization;
        ModelsUtil.RList result = null;
        boolean bl = needsInitialization = !this._initialized || this._instanceIdsToElements.size() != this.getInstanceIds().size();
        if (needsInitialization) {
            result = new ModelsUtil.RList();
            this._instanceIdsToElements = new WeakHashMap<String, EObject>();
            for (String instanceId : new HashSet(this.getInstanceIds().keySet())) {
                if (instanceId != null) {
                    EObject instanceElement = this.resolveInstanceId(instanceId);
                    if (instanceElement != null && this.isInModel(instanceElement)) {
                        this._instanceIdsToElements.put(instanceId, instanceElement);
                        result.add((Object)instanceElement);
                        continue;
                    }
                    this.removeInstanceId(instanceId);
                    continue;
                }
                this.removeInstanceId(instanceId);
            }
            this._initialized = true;
        }
        return result;
    }

    @Override
    public void clear() {
        this.getInstanceIds().clear();
        this.getTemplateIds().clear();
        this.getUnfoldedIds().clear();
        if (this._initialized) {
            this._instanceIdsToElements.clear();
        }
    }

    @Override
    public void clearUnfolded() {
        for (String instanceId : new ArrayList<String>((Collection<String>)this.getUnfoldedIds())) {
            this.removeInstanceId(instanceId);
        }
    }

    public boolean covers(EObject element, boolean fromPattern) {
        boolean result = false;
        String elementId = this.getId(element);
        if (elementId != null) {
            result = fromPattern ? this.getTemplateIds().keySet().contains(elementId) : this.getInstanceIds().keySet().contains(elementId);
        }
        return result;
    }

    public EObject getCounterpart(EObject element, boolean fromPattern) {
        EObject result = null;
        String elementId = this.getId(element);
        if (elementId != null) {
            if (fromPattern) {
                String instanceId = this.getInstanceId(elementId, this.getMainMultipart());
                this.checkInstanceElementsInitialized();
                EObject instanceElement = this._instanceIdsToElements.get(instanceId);
                if (instanceElement != null) {
                    if (this.isInModel(instanceElement)) {
                        result = instanceElement;
                    } else {
                        this.removeInstanceId(instanceId);
                    }
                }
            } else {
                String templateId = this.getTemplateId(elementId);
                result = this.resolveTemplateId(templateId);
            }
        }
        return result;
    }

    public List<EObject> getCounterparts(EObject templateElement_p) {
        ModelsUtil.ROrderedSet result = new ModelsUtil.ROrderedSet();
        String templateId = this.getId(templateElement_p);
        if (templateId != null) {
            List<String> counterpartInstanceIds = this.getInstanceIds(templateId);
            this.checkInstanceElementsInitialized();
            for (String instanceId : counterpartInstanceIds) {
                EObject instanceElement = this._instanceIdsToElements.get(instanceId);
                if (instanceElement == null) continue;
                if (this.isInModel(instanceElement)) {
                    result.add(instanceElement);
                    continue;
                }
                this.removeInstanceId(instanceId);
            }
        }
        return result;
    }

    private String getId(EObject element_p) {
        return CorePatternsPlugin.getDefault().getIdProvider().getId(element_p, null);
    }

    @Override
    public EList<EObject> getInstanceElements() {
        EList<EObject> result = this.checkInstanceElements();
        return result;
    }

    private String getInstanceId(String templateId, String multipart) {
        String result = null;
        TemplateCounterpart templateCounterpart = (TemplateCounterpart)this.getTemplateIds().get((Object)templateId);
        if (templateCounterpart != null) {
            result = (String)templateCounterpart.getInstanceParts().get((Object)multipart);
        }
        return result;
    }

    private List<String> getInstanceIds(String templateId) {
        ArrayList result = new ArrayList();
        TemplateCounterpart templateCounterpart = (TemplateCounterpart)this.getTemplateIds().get((Object)templateId);
        if (templateCounterpart != null) {
            result.addAll(templateCounterpart.getInstanceParts().values());
        }
        return Collections.unmodifiableList(result);
    }

    private String getMainMultipart() {
        String result = null;
        ITemplatePatternEngine engine = TemplatePatternsPlugin.getDefault().getEngine();
        if (engine != null) {
            result = engine.getMainMultipart();
        }
        return result;
    }

    @Override
    public String getMultipartOf(EObject element) {
        String result = null;
        String instanceId = this.getId(element);
        InstanceCounterpart instanceCounterpart = (InstanceCounterpart)this.getInstanceIds().get((Object)instanceId);
        if (instanceCounterpart != null) {
            result = instanceCounterpart.getMultipart();
        }
        return result;
    }

    @Override
    public EList<String> getMultiparts() {
        HashSet<String> result = new HashSet<String>();
        for (TemplateCounterpart templateCounterpart : this.getTemplateIds().values()) {
            result.addAll(templateCounterpart.getInstanceParts().keySet());
        }
        if (this.getMultiplicity() > 1) {
            int i = 1;
            while (i <= this.getMultiplicity()) {
                result.add(String.valueOf(i));
                ++i;
            }
        }
        result.remove(this.getMainMultipart());
        return ECollections.unmodifiableEList((EList)new BasicEList(result));
    }

    public TemplatePattern getPattern() {
        TemplatePattern result = null;
        AbstractPatternInstance instance = this.getInstance();
        if (instance != null) {
            result = (TemplatePattern)instance.getPattern();
        }
        return result;
    }

    @Override
    public EList<TemplatePatternRole> getRolesOf(EObject instanceElement_p) {
        ModelsUtil.ROrderedSet result = new ModelsUtil.ROrderedSet();
        EObject templateElement = this.getCounterpart(instanceElement_p, false);
        if (templateElement != null && this.getPattern() != null) {
            for (TemplatePatternRole role : this.getPattern().getRoles()) {
                if (!role.getTemplateElements().contains((Object)templateElement)) continue;
                result.add((Object)role);
            }
        }
        return ECollections.unmodifiableEList((EList)result);
    }

    public Object getScopeElement() {
        return this;
    }

    private String getTemplateId(String instanceId) {
        String result = null;
        InstanceCounterpart found = (InstanceCounterpart)this.getInstanceIds().get((Object)instanceId);
        if (found != null) {
            result = found.getTemplateId();
        }
        return result;
    }

    public boolean isComplete() {
        return !this.getInstanceIds().isEmpty();
    }

    private boolean isInModel(EObject instanceElement) {
        return CorePatternsPlugin.getDefault().getDeleteOperationProvider().isInModel(instanceElement);
    }

    @Override
    public boolean isInMultipart(EObject element, String multipart) {
        String elementMultipart = this.getMultipartOf(element);
        return multipart == null && elementMultipart == null || multipart != null && multipart.equals(elementMultipart);
    }

    @Override
    public boolean isInOtherMultipart(EObject element, String multipart) {
        String elementMultipart = this.getMultipartOf(element);
        boolean result = elementMultipart == null ? false : (this.getMainMultipart().equals(multipart) ? !this.getMainMultipart().equals(elementMultipart) : !elementMultipart.equals(multipart) && !this.getMainMultipart().equals(elementMultipart));
        return result;
    }

    @Override
    public void map(EObject instanceElement, EObject templateElement, String multipart) {
        String instanceId = this.getId(instanceElement);
        String templateId = this.getId(templateElement);
        this.checkInstanceElementsInitialized();
        InstanceCounterpart instanceCounterpart = (InstanceCounterpart)this.getInstanceIds().get((Object)instanceId);
        if (instanceCounterpart == null) {
            instanceCounterpart = TemplatepatternsFactory.eINSTANCE.createInstanceCounterpart();
            this.getInstanceIds().put((Object)instanceId, (Object)instanceCounterpart);
        }
        instanceCounterpart.setTemplateId(templateId);
        instanceCounterpart.setMultipart(multipart);
        TemplateCounterpart templateCounterpart = (TemplateCounterpart)this.getTemplateIds().get((Object)templateId);
        if (templateCounterpart == null) {
            templateCounterpart = TemplatepatternsFactory.eINSTANCE.createTemplateCounterpart();
            this.getTemplateIds().put((Object)templateId, (Object)templateCounterpart);
        }
        templateCounterpart.getInstanceParts().put((Object)multipart, (Object)instanceId);
        this._instanceIdsToElements.put(instanceId, instanceElement);
    }

    @Override
    public void markAsUnfolded(EObject instanceElement) {
        String instanceId = this.getId(instanceElement);
        this.getUnfoldedIds().add((Object)instanceId);
    }

    private void removeInstanceId(String instanceId) {
        try {
            InstanceCounterpart instanceCounterpart = (InstanceCounterpart)this.getInstanceIds().removeKey((Object)instanceId);
            if (instanceCounterpart != null) {
                this.getTemplateIds().removeKey((Object)instanceCounterpart.getTemplateId());
            }
            this.getUnfoldedIds().remove((Object)instanceId);
            if (this._initialized) {
                this._instanceIdsToElements.remove(instanceId);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void rename(String newNamingRule, boolean keepUserNames) {
        ITemplatePatternEngine engine = TemplatePatternsPlugin.getDefault().getEngine();
        if (engine != null) {
            engine.renameElements((IPatternInstance)this.getInstance(), newNamingRule, keepUserNames);
        }
    }

    private EObject resolveInstanceId(String instanceId_p) {
        return CorePatternsPlugin.getDefault().getIdProvider().getByIdInContext(instanceId_p, (Object)this.getInstance());
    }

    private EObject resolveTemplateId(String templateId_p) {
        EObject result = null;
        IPattern pattern = this.getInstance().getPattern();
        if (pattern instanceof EObject) {
            result = CorePatternsPlugin.getDefault().getIdProvider().getByIdInResource(templateId_p, (EObject)pattern);
        }
        return result;
    }

    @Override
    public boolean wasUnfolded(EObject instanceElement) {
        boolean result = false;
        String instanceId = this.getId(instanceElement);
        if (instanceId != null) {
            result = this.getUnfoldedIds().contains((Object)instanceId);
        }
        return result;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getInstanceIds()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getTemplateIds()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getNamingRule();
            }
            case 3: {
                return this.getMultiplicity();
            }
            case 4: {
                if (coreType) {
                    return this.getInstanceIds();
                }
                return this.getInstanceIds().map();
            }
            case 5: {
                if (coreType) {
                    return this.getTemplateIds();
                }
                return this.getTemplateIds().map();
            }
            case 6: {
                return this.getUnfoldedIds();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setNamingRule((String)newValue);
                return;
            }
            case 3: {
                this.setMultiplicity((Integer)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getInstanceIds()).set(newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getTemplateIds()).set(newValue);
                return;
            }
            case 6: {
                this.getUnfoldedIds().clear();
                this.getUnfoldedIds().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setNamingRule(NAMING_RULE_EDEFAULT);
                return;
            }
            case 3: {
                this.setMultiplicity(0);
                return;
            }
            case 4: {
                this.getInstanceIds().clear();
                return;
            }
            case 5: {
                this.getTemplateIds().clear();
                return;
            }
            case 6: {
                this.getUnfoldedIds().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAMING_RULE_EDEFAULT == null ? this.namingRule != null : !NAMING_RULE_EDEFAULT.equals(this.namingRule);
            }
            case 3: {
                return this.multiplicity != 0;
            }
            case 4: {
                return this.instanceIds != null && !this.instanceIds.isEmpty();
            }
            case 5: {
                return this.templateIds != null && !this.templateIds.isEmpty();
            }
            case 6: {
                return this.unfoldedIds != null && !this.unfoldedIds.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (namingRule: ");
        result.append(this.namingRule);
        result.append(", multiplicity: ");
        result.append(this.multiplicity);
        result.append(", unfoldedIds: ");
        result.append(this.unfoldedIds);
        result.append(')');
        return result.toString();
    }
}

