/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public final class ModelImplUtil {
    private ModelImplUtil() {
    }

    public static boolean copyXmlId(EObject source_p, EObject target_p) {
        return ModelImplUtil.setXmlId(target_p, ModelImplUtil.getXmlId(source_p));
    }

    public static String getEcoreId(EObject element_p) {
        String result = null;
        if (element_p != null) {
            result = EcoreUtil.getID((EObject)element_p);
        }
        return result;
    }

    public static String getXmlId(EObject element_p) {
        String result = null;
        if (element_p != null && element_p.eResource() instanceof XMLResource) {
            result = ((XMLResource)element_p.eResource()).getID(element_p);
        }
        return result;
    }

    public static EObject resolveIfLoaded(EObject proxy_p, EObject objectContext_p) {
        Resource resourceContext = objectContext_p != null ? objectContext_p.eResource() : null;
        ResourceSet rsContext = resourceContext != null ? resourceContext.getResourceSet() : null;
        return ModelImplUtil.resolveIfLoaded(proxy_p, rsContext);
    }

    private static EObject resolveIfLoaded(EObject proxy_p, ResourceSet resourceSet_p) {
        URI proxyURI = ((InternalEObject)proxy_p).eProxyURI();
        if (proxyURI != null) {
            try {
                EObject resolvedObject = null;
                if (resourceSet_p != null) {
                    resolvedObject = resourceSet_p.getEObject(proxyURI, false);
                } else {
                    Resource resource;
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(proxyURI.trimFragment().toString());
                    if (ePackage != null && (resource = ePackage.eResource()) != null) {
                        resolvedObject = resource.getEObject(proxyURI.fragment().toString());
                    }
                }
                if (resolvedObject != null && resolvedObject != proxy_p) {
                    return ModelImplUtil.resolveIfLoaded(resolvedObject, resourceSet_p);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return proxy_p;
    }

    public static boolean setAttributeId(EObject element_p, String id_p) {
        assert (element_p != null && id_p != null);
        boolean result = false;
        if (element_p.eClass().getEIDAttribute() != null && (element_p.eResource() == null || element_p.eResource().getEObject(id_p) == null)) {
            EcoreUtil.setID((EObject)element_p, (String)id_p);
            result = true;
        }
        return result;
    }

    public static boolean setXmlId(EObject element_p, String id_p) {
        XMLResource resource;
        assert (element_p != null);
        boolean result = false;
        if (id_p != null && element_p.eResource() instanceof XMLResource && (resource = (XMLResource)element_p.eResource()).getEObject(id_p) == null) {
            resource.setID(element_p, id_p);
            result = true;
        }
        return result;
    }
}

