/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.gmf;

import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.impl.policies.DefaultDiffPolicy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFDiffPolicy
extends DefaultDiffPolicy {
    public boolean considerEqual(Object value1_p, Object value2_p, EAttribute attribute_p) {
        boolean result = super.considerEqual(value1_p, value2_p, attribute_p);
        if (!result) {
            if (NotationPackage.eINSTANCE.getRelativeBendpoints_Points().equals(attribute_p)) {
                result = this.equalPoints((List)value1_p, (List)value2_p);
            } else if (value1_p instanceof RelativeBendpoint && value2_p instanceof RelativeBendpoint) {
                result = this.equalRelativeBendpoint((RelativeBendpoint)value1_p, (RelativeBendpoint)value2_p);
            } else if (value1_p instanceof Color && value2_p instanceof Color) {
                result = this.equalColor((Color)value1_p, (Color)value2_p);
            }
        }
        return result;
    }

    public boolean coverMatch(IMatch match_p) {
        EObject element;
        EReference containment;
        boolean result = super.coverMatch(match_p);
        if (result && match_p.isPartial() && (containment = (element = match_p.get(match_p.getUncoveredRole().opposite())).eContainmentFeature()) != null) {
            result = !containment.isTransient();
        }
        return result;
    }

    private boolean equalColor(Color color1_p, Color color2_p) {
        return color1_p.getBlue() == color2_p.getBlue() && color1_p.getRed() == color2_p.getRed() && color1_p.getGreen() == color2_p.getGreen();
    }

    private boolean equalRelativeBendpoint(RelativeBendpoint point1_p, RelativeBendpoint point2_p) {
        return point1_p.getSourceX() == point2_p.getSourceX() && point1_p.getSourceY() == point2_p.getSourceY() && point1_p.getTargetX() == point2_p.getTargetX() && point1_p.getTargetY() == point2_p.getTargetY();
    }

    private boolean equalPoints(List<?> list1_p, List<?> list2_p) {
        if (list1_p.size() != list2_p.size()) {
            return false;
        }
        int i = 0;
        while (i < list1_p.size()) {
            Object val2;
            Object val1 = list1_p.get(i);
            if (!this.equalRelativeBendpoint((RelativeBendpoint)val1, (RelativeBendpoint)(val2 = list2_p.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

