/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EElementRelativePresence;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.EValuePresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.ComparisonSelectionImpl;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.log.CompareLogEvent;
import org.eclipse.emf.diffmerge.ui.log.MergeLogEvent;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ModelComparisonDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonViewer
extends Viewer
implements IPropertyChangeNotifier,
IFlushable {
    protected static final String FILTERING_STATE = "FILTERING_STATE";
    protected static final String DIFFERENCE_NUMBERS_STATE = "DIFFERENCE_NUMBERS_STATE";
    protected IActionBars _actionBars;
    private ModelComparisonDiffNode _input;
    protected Role _leftRole;
    protected SashForm _control;
    protected EnhancedComparisonTreeViewer _synthesisModelTreeViewer;
    protected EnhancedComparisonSideViewer _leftModelTreeViewer;
    protected EnhancedComparisonSideViewer _rightModelTreeViewer;
    protected FeaturesViewer _featuresViewer;
    protected ValuesViewer _leftValuesViewer;
    protected ValuesViewer _rightValuesViewer;
    protected ToolBar _featuresToolbar;
    protected ToolBar _leftValuesToolbar;
    protected ToolBar _rightValuesToolbar;
    protected ToolItem _nextItem;
    protected ToolItem _previousItem;
    protected ToolItem _toLeftItem;
    protected ToolItem _toRightItem;
    protected ToolItem _deleteLeftItem;
    protected ToolItem _deleteRightItem;
    protected ToolItem _ignoreLeftItem;
    protected ToolItem _ignoreRightItem;
    private ComparisonSelection _lastUserSelection;
    protected ViewerFilter _unchangedElementsFilter;
    protected ViewerFilter _moveOriginsFilter;
    protected ViewerSorter _synthesisSorter;
    protected boolean _isLeftEditable;
    protected boolean _isRightEditable;
    private boolean _isLeftModified;
    private boolean _isRightModified;
    protected boolean _isLeftRightSynced;
    protected boolean _showMergeImpact;
    protected boolean _supportUndoRedo;
    protected boolean _logEvents;
    protected boolean _defaultCoverChildren;
    protected boolean _defaultIncrementalMode;
    protected boolean _defaultShowImpact;
    private final Set<IPropertyChangeListener> _changeListeners;
    protected Command _lastCommandBeforeSave;
    protected UndoAction _undoAction;
    protected RedoAction _redoAction;

    public ComparisonViewer(Composite parent_p) {
        this(parent_p, null);
    }

    public ComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        this._actionBars = actionBars_p;
        this._input = null;
        this._leftRole = Role.TARGET;
        this._lastUserSelection = null;
        this._isLeftEditable = true;
        this._isRightEditable = true;
        this._isLeftModified = false;
        this._isRightModified = false;
        this._isLeftRightSynced = true;
        this._showMergeImpact = true;
        this._supportUndoRedo = true;
        this._logEvents = false;
        this._defaultShowImpact = this._showMergeImpact;
        this._defaultCoverChildren = true;
        this._defaultIncrementalMode = false;
        this._changeListeners = new HashSet<IPropertyChangeListener>(1);
        this._lastCommandBeforeSave = null;
        this._undoAction = null;
        this._redoAction = null;
        this.createControls(parent_p);
    }

    protected void addDifferencesToMerge(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        for (IDifference difference : match_p.getAllDifferences()) {
            if (this.getInput().shouldBeIgnored(difference) || incrementalMode_p && (!(difference instanceof IPresenceDifference) || ((IPresenceDifference)difference).getPresenceRole() == destination_p)) continue;
            toMerge_p.add(difference);
        }
    }

    protected void addDifferencesToMergeRec(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        this.addDifferencesToMerge(toMerge_p, match_p, destination_p, incrementalMode_p);
        for (IMatch child : this.getInput().getChildrenForMerge(match_p)) {
            this.addDifferencesToMergeRec(toMerge_p, child, destination_p, incrementalMode_p);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.add(listener_p);
    }

    protected boolean canAddToTheLeft(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_RIGHT, DifferenceKind.FROM_RIGHT_ADD, DifferenceKind.FROM_LEFT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected boolean canAddToTheRight(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_LEFT, DifferenceKind.FROM_LEFT_ADD, DifferenceKind.FROM_RIGHT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected void changeCounting(final ModelComparisonDiffNode.UserDifferenceKind kind_p, final boolean newValue_p) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ComparisonViewer.this.getInput().setCount(kind_p, newValue_p);
                ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.DIFFERENCE_NUMBERS_STATE, null);
                ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.FILTERING_STATE, ComparisonViewer.this.getInput().isFiltering());
            }
        });
    }

    protected void createControls(Composite parent_p) {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (ComparisonViewer.DIFFERENCE_NUMBERS_STATE.equals(event_p.getProperty())) {
                    ComparisonViewer.this.getInput().updateDifferenceNumbers();
                    ComparisonViewer.this.refresh();
                }
            }
        });
        this._control = new SashForm(parent_p, 512);
        SashForm upperPart = new SashForm((Composite)this._control, 256);
        this._synthesisModelTreeViewer = new EnhancedComparisonTreeViewer((Composite)upperPart);
        this._synthesisSorter = new ViewerSorter();
        this._unchangedElementsFilter = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                EMatch match = (EMatch)element_p;
                return ComparisonViewer.this.getInput().getDifferenceNumber((IMatch)match) > 0;
            }
        };
        this._moveOriginsFilter = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                TreePath path = parentElement_p instanceof TreePath ? ((TreePath)parentElement_p).createChildPath(element_p) : new TreePath(new Object[]{element_p});
                return !ComparisonViewer.this.getInput().isMoveOrigin(path);
            }
        };
        this._synthesisModelTreeViewer.getComparisonTreeViewer().addFilter(this._unchangedElementsFilter);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Boolean filtered;
                if (ComparisonViewer.FILTERING_STATE.equals(event_p.getProperty()) && (filtered = (Boolean)event_p.getNewValue()) != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(ComparisonViewer.this._synthesisModelTreeViewer.getDefaultHeaderText());
                    if (filtered.booleanValue()) {
                        builder.append(Messages.ComparisonViewer_Filtered);
                    }
                    ComparisonViewer.this._synthesisModelTreeViewer.getHeader().setText(builder.toString());
                }
            }
        });
        this._leftModelTreeViewer = new EnhancedComparisonSideViewer((Composite)upperPart, this._leftRole);
        this._rightModelTreeViewer = new EnhancedComparisonSideViewer((Composite)upperPart, this._leftRole.opposite());
        SashForm lowerPart = new SashForm((Composite)this._control, 256);
        Composite featuresWrapper = UIUtil.createComposite((Composite)lowerPart);
        Composite featuresHeader = new Composite(featuresWrapper, 0);
        this._featuresViewer = new FeaturesViewer(featuresWrapper);
        featuresHeader.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        featuresHeader.setLayout((Layout)layout);
        Label label = new Label(featuresHeader, 0);
        label.setFont(UIUtil.getBold(label.getFont()));
        label.setText(Messages.ComparisonViewer_Details);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._featuresToolbar = UIUtil.createToolBar(featuresHeader);
        this._leftValuesViewer = this.createValuesSection((Composite)lowerPart, true);
        this._rightValuesViewer = this.createValuesSection((Composite)lowerPart, false);
        this.setupSashes(upperPart, lowerPart);
        this.setupSynchronizationListeners();
        this.setupToolbars();
        this.hookControl(this.getControl());
    }

    protected ValuesViewer createValuesSection(Composite parent_p, boolean left_p) {
        Composite sectionWrapper = UIUtil.createComposite(parent_p);
        Composite header = new Composite(sectionWrapper, 0);
        header.setLayoutData((Object)new GridData(4, 4, true, false));
        ValuesViewer result = new ValuesViewer(sectionWrapper, this.getRoleForSide(left_p));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        if (left_p) {
            Label space = new Label(header, 0);
            space.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        ToolBar toolbar = UIUtil.createToolBar(header);
        if (left_p) {
            this._leftValuesToolbar = toolbar;
        } else {
            this._rightValuesToolbar = toolbar;
        }
        return result;
    }

    protected void executeOnModel(final Runnable runnable_p) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (ComparisonViewer.this._supportUndoRedo) {
                    MiscUtil.executeOnDomain(ComparisonViewer.this.getEditingDomain(), null, runnable_p);
                } else {
                    MiscUtil.executeAndForget(ComparisonViewer.this.getEditingDomain(), runnable_p);
                }
            }
        });
    }

    protected void firePropertyChangeEvent(String propertyName_p, Object newValue_p) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName_p, null, newValue_p);
        for (IPropertyChangeListener listener : this._changeListeners) {
            listener.propertyChange(event);
        }
    }

    public void flush(IProgressMonitor monitor_p) {
        EComparison comparison = this.getComparison();
        if (comparison != null) {
            try {
                IFeaturedModelScope rightScope;
                IFeaturedModelScope leftScope;
                if (this._isLeftModified && (leftScope = comparison.getScope(this.getRoleForSide(true))) instanceof IPersistentModelScope) {
                    ((IPersistentModelScope)leftScope).save();
                }
                if (this._isRightModified && (rightScope = comparison.getScope(this.getRoleForSide(false))) instanceof IPersistentModelScope) {
                    ((IPersistentModelScope)rightScope).save();
                }
                this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(false));
                if (this.getEditingDomain() != null) {
                    this._lastCommandBeforeSave = this.getEditingDomain().getCommandStack().getUndoCommand();
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)(String.valueOf(Messages.ComparisonViewer_SaveFailed) + e));
            }
        }
    }

    protected void ignore(boolean onLeft_p) {
        List<IDifference> toIgnore;
        EList<EMatch> treePath;
        final ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        boolean coverChildren = this._defaultCoverChildren;
        boolean sideExclusive = false;
        Object selectedMatches = selection.getSelectedMatches();
        if (selectedMatches.isEmpty() && !(treePath = selection.getSelectedTreePath()).isEmpty()) {
            selectedMatches = Collections.singletonList((EMatch)treePath.get(treePath.size() - 1));
        }
        boolean basedOnMatches = !selectedMatches.isEmpty();
        boolean requiresChoices = false;
        if (basedOnMatches) {
            for (EMatch selectedMatch : selectedMatches) {
                if (!this.getInput().hasChildrenForMerge((IMatch)selectedMatch)) continue;
                requiresChoices = true;
                break;
            }
        }
        if (requiresChoices) {
            IgnoreChoicesDialog.IgnoreChoiceData choice = new IgnoreChoicesDialog.IgnoreChoiceData(coverChildren, false);
            IgnoreChoicesDialog choicesDialog = new IgnoreChoicesDialog(this.getShell(), Messages.ComparisonViewer_IgnoreCommandName, choice);
            int answer = choicesDialog.open();
            if (answer != 0) {
                return;
            }
            coverChildren = choice.getCoverChildren();
            this._defaultCoverChildren = choice.getCoverChildren();
            sideExclusive = choice.getSideExclusive();
        }
        List<IDifference> list = toIgnore = basedOnMatches ? this.getDifferencesToMerge((List<EMatch>)selectedMatches, this.getRoleForSide(onLeft_p), coverChildren, sideExclusive) : this.getInput().getNonIgnoredDifferences((Iterable<? extends IDifference>)selection.asDifferencesToMerge());
        if (!toIgnore.isEmpty()) {
            this.executeOnModel(new Runnable(){

                public void run() {
                    for (IDifference diff : toIgnore) {
                        IValuePresence symmetrical;
                        if (!(diff instanceof EElementRelativePresence)) continue;
                        EElementRelativePresence presence = (EElementRelativePresence)diff;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)presence);
                        if (!(diff instanceof EValuePresence) || !((symmetrical = ((EValuePresence)diff).getSymmetrical()) instanceof EMergeableDifference)) continue;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)((EMergeableDifference)symmetrical));
                    }
                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                }
            });
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            this.firePropertyChangeEvent(DIFFERENCE_NUMBERS_STATE, null);
        }
    }

    protected EComparison getComparison() {
        UIComparison uiComparison = this.getUIComparison();
        return uiComparison == null ? null : uiComparison.getActualComparison();
    }

    public Control getControl() {
        return this._control;
    }

    protected List<IDifference> getDifferencesToMerge(final List<EMatch> selectedMatches_p, final Role destination_p, final boolean coverChildren_p, final boolean incrementalMode_p) {
        final ArrayList result = new ArrayList();
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    for (EMatch selectedMatch : selectedMatches_p) {
                        if (coverChildren_p) {
                            ComparisonViewer.this.addDifferencesToMergeRec(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                            continue;
                        }
                        ComparisonViewer.this.addDifferencesToMerge(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(result);
    }

    public Role getDrivingRole() {
        return this.getInput() == null ? null : this.getInput().getDrivingRole();
    }

    protected EditingDomain getEditingDomain() {
        return this.getInput() == null ? null : this.getInput().getEditingDomain();
    }

    public ModelComparisonDiffNode getInput() {
        return this._input;
    }

    protected Logger getLogger() {
        return EMFDiffMergeUIPlugin.getDefault().getDiffMergeLogger();
    }

    protected String getModelName(boolean onLeft_p) {
        IFeaturedModelScope scope = this.getComparison().getScope(this.getRoleForSide(onLeft_p));
        return DiffMergeLabelProvider.getInstance().getText(scope);
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getResourceManager();
    }

    protected Role getRoleForSide(boolean left_p) {
        return left_p ? this._leftRole : this._leftRole.opposite();
    }

    public ComparisonSelection getSelection() {
        return this._lastUserSelection;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected UIComparison getUIComparison() {
        return this.getInput() == null ? null : this.getInput().getUIComparison();
    }

    protected void handleDispose() {
        this._control = null;
        this._changeListeners.clear();
        this._input = null;
        this._lastCommandBeforeSave = null;
        this._lastUserSelection = null;
        this._leftModelTreeViewer = null;
        this._rightModelTreeViewer = null;
        this._leftValuesToolbar = null;
        this._rightValuesToolbar = null;
        this._leftValuesViewer = null;
        this._rightValuesViewer = null;
        this._synthesisModelTreeViewer = null;
        this._featuresViewer = null;
        this._featuresToolbar = null;
        this._synthesisSorter = null;
        this._toLeftItem = null;
        this._toRightItem = null;
        this._ignoreLeftItem = null;
        this._ignoreRightItem = null;
        this._deleteLeftItem = null;
        this._deleteRightItem = null;
        this._nextItem = null;
        this._previousItem = null;
        this._unchangedElementsFilter = null;
        this._moveOriginsFilter = null;
        if (this._actionBars != null) {
            this._actionBars.clearGlobalActionHandlers();
        }
        this._actionBars = null;
        this._undoAction = null;
        this._redoAction = null;
    }

    protected void hookControl(Control control_p) {
        control_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ComparisonViewer.this.handleDispose();
            }
        });
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        this._featuresViewer.setInput(null);
        this._featuresViewer.setDrivingRole(this.getDrivingRole());
        this._leftValuesViewer.setInput(null);
        this._leftValuesViewer.setDrivingRole(this.getDrivingRole());
        this._rightValuesViewer.setInput(null);
        this._rightValuesViewer.setDrivingRole(this.getDrivingRole());
        this._synthesisModelTreeViewer.setInput(input_p);
        this._leftModelTreeViewer.setInput(input_p);
        this._rightModelTreeViewer.setInput(input_p);
        this._undoAction.setEditingDomain(this.getInput().getEditingDomain());
        this._redoAction.setEditingDomain(this.getInput().getEditingDomain());
        this._undoAction.update();
        this._redoAction.update();
        if (this._actionBars != null) {
            this._actionBars.updateActionBars();
        }
        if (this._logEvents) {
            this.getLogger().log((Object)new CompareLogEvent(this.getEditingDomain(), (IComparison)this.getComparison()));
        }
    }

    protected void merge(boolean toLeft_p) {
        boolean basedOnMatches;
        boolean requiresChoices;
        EList<EMatch> treePath;
        final ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        boolean showMergeImpact = this._showMergeImpact;
        boolean coverChildren = this._defaultCoverChildren;
        boolean incrementalMode = false;
        Object selectedMatches = selection.getSelectedMatches();
        if (selectedMatches.isEmpty() && !(treePath = selection.getSelectedTreePath()).isEmpty()) {
            selectedMatches = Collections.singletonList((EMatch)treePath.get(treePath.size() - 1));
        }
        if ((requiresChoices = (basedOnMatches = !selectedMatches.isEmpty())) && selectedMatches.size() == 1) {
            EMatch selectedMatch = (EMatch)selectedMatches.get(0);
            if (!this.getInput().hasChildrenForMerge((IMatch)selectedMatch)) {
                DifferenceKind kind = this.getInput().getDifferenceKind((IMatch)selectedMatch);
                boolean bl = requiresChoices = !kind.isAddition() && !kind.isDeletion();
            }
        }
        if (requiresChoices) {
            boolean askAboutChildren = false;
            for (EMatch selectedMatch : selectedMatches) {
                if (this.getInput().getDifferenceKind((IMatch)selectedMatch) == DifferenceKind.COUNTED) {
                    coverChildren = true;
                    break;
                }
                if (!this.getInput().hasChildrenForMerge((IMatch)selectedMatch)) continue;
                askAboutChildren = true;
                break;
            }
            MergeChoicesDialog.MergeChoiceData choice = new MergeChoicesDialog.MergeChoiceData(coverChildren, this._defaultIncrementalMode, this._defaultShowImpact);
            MergeChoicesDialog choicesDialog = new MergeChoicesDialog(this.getShell(), Messages.ComparisonViewer_MergeHeader, choice, askAboutChildren);
            int answer = choicesDialog.open();
            if (answer != 0) {
                return;
            }
            showMergeImpact = choice.getShowImpact();
            coverChildren = choice.getCoverChildren();
            incrementalMode = choice.getIncrementalMode();
            if (askAboutChildren) {
                this._defaultCoverChildren = choice.getCoverChildren();
            }
            this._defaultIncrementalMode = choice.getIncrementalMode();
            this._defaultShowImpact = choice.getShowImpact();
        }
        final Role destination = this.getRoleForSide(toLeft_p);
        final List<IDifference> toMerge = basedOnMatches ? this.getDifferencesToMerge((List<EMatch>)selectedMatches, destination, coverChildren, incrementalMode) : this.getInput().getNonIgnoredDifferences((Iterable<? extends IDifference>)selection.asDifferencesToMerge());
        final ArrayList merged = new ArrayList();
        boolean done = false;
        if (!toMerge.isEmpty()) {
            final MergeImpactViewer.ImpactInput mergeInput = new MergeImpactViewer.ImpactInput(toMerge, destination, toLeft_p, this.getComparison().isThreeWay());
            boolean proceed = true;
            IProgressService progress = PlatformUI.getWorkbench().getProgressService();
            if (showMergeImpact) {
                try {
                    progress.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                            mergeInput.compute(monitor_p);
                        }
                    });
                    MergeImpactMessageDialog dialog = new MergeImpactMessageDialog(this.getShell(), mergeInput);
                    proceed = dialog.openAndConfirm();
                }
                catch (Exception dialog) {
                    // empty catch block
                }
            }
            if (proceed) {
                try {
                    progress.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(final IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                            Runnable mergeRunnable = new Runnable(){

                                public void run() {
                                    merged.addAll(ComparisonViewer.this.getComparison().merge(toMerge, destination, true, monitor_p));
                                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                                }
                            };
                            if (ComparisonViewer.this._supportUndoRedo) {
                                MiscUtil.executeOnDomain(ComparisonViewer.this.getEditingDomain(), null, mergeRunnable);
                            } else {
                                MiscUtil.executeAndForget(ComparisonViewer.this.getEditingDomain(), mergeRunnable);
                            }
                        }
                    });
                    done = true;
                }
                catch (Exception e) {
                    throw new OperationCanceledException(e.getLocalizedMessage());
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ComparisonViewer_MergeHeader, (String)Messages.ComparisonViewer_NoDiffsToMerge);
        }
        if (!merged.isEmpty() && done) {
            if (toLeft_p) {
                this._isLeftModified = true;
            } else {
                this._isRightModified = true;
            }
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            this.firePropertyChangeEvent(DIFFERENCE_NUMBERS_STATE, null);
            if (this._logEvents) {
                this.getLogger().log((Object)new MergeLogEvent(this.getEditingDomain(), (IComparison)this.getComparison(), merged, toLeft_p));
            }
        }
    }

    protected void navigate(boolean next_p) {
        TreePath newPath;
        ITreeSelection selection = this._synthesisModelTreeViewer.getSelection();
        TreePath current = selection == null || selection.isEmpty() ? TreePath.EMPTY : selection.getPaths()[0];
        ComparisonTreeViewer treeViewer = this._synthesisModelTreeViewer.getComparisonTreeViewer();
        TreePath treePath = newPath = next_p ? treeViewer.getNextUserDifference(current) : treeViewer.getPreviousUserDifference(current);
        if (newPath != null) {
            this.setSelection((ISelection)new ComparisonSelectionImpl(newPath, this.getDrivingRole()), true);
        }
    }

    protected boolean representAsOwnership(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
            EReference ref = presence.getFeature();
            result = !presence.isOrder() && ref != null && ref.isContainment();
        }
        return result;
    }

    public void refresh() {
        this._leftModelTreeViewer.refresh();
        this._rightModelTreeViewer.refresh();
        this._leftValuesViewer.refresh();
        this._rightValuesViewer.refresh();
        this._featuresViewer.refresh();
        this._synthesisModelTreeViewer.refresh();
        this.refreshTools();
    }

    protected void refreshTools() {
        ComparisonSelection selection = this.getSelection();
        boolean onLeft = false;
        boolean onRight = false;
        boolean allowDeletion = false;
        boolean allowFreezing = false;
        if (selection != null) {
            EList<EMatch> matches;
            allowFreezing = true;
            EValuePresence presence = selection.asValuePresence();
            if (presence != null && !presence.isMerged()) {
                DifferenceKind kind = this.getInput().getDifferenceKind((IDifference)presence);
                onLeft = this.canAddToTheRight(kind);
                onRight = this.canAddToTheLeft(kind);
                allowDeletion = this.getInput().isMany((IPresenceDifference)presence) && !this.getInput().isOwnershipOpposite((IDifference)presence);
            } else if (selection.asFeature() == null && !(matches = selection.asMatches()).isEmpty()) {
                if (matches.size() > 1) {
                    allowDeletion = true;
                    Iterator it = matches.iterator();
                    while (it.hasNext() && (!onLeft || !onRight || allowDeletion)) {
                        EMatch current = (EMatch)it.next();
                        DifferenceKind kind = this.getInput().getDifferenceKind((IMatch)current);
                        if (kind.isAddition()) {
                            onLeft = onLeft || kind.isLeft(true);
                            onRight = onRight || kind.isRight(true);
                            continue;
                        }
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    }
                    allowDeletion = allowDeletion && onLeft != onRight;
                } else {
                    IMatch match = (IMatch)matches.get(0);
                    if (this.getInput().representAsModification(match) || this.getInput().representAsMove(match) || this.getInput().getDifferenceKind(match) == DifferenceKind.COUNTED) {
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    } else {
                        DifferenceKind kind = this.getInput().getDifferenceKind(match);
                        onLeft = this.canAddToTheRight(kind);
                        onRight = this.canAddToTheLeft(kind);
                        allowDeletion = true;
                    }
                }
            }
        }
        this._toRightItem.setEnabled(this._isRightEditable && onLeft);
        this._deleteLeftItem.setEnabled(this._isLeftEditable && onLeft && allowDeletion);
        this._toLeftItem.setEnabled(this._isLeftEditable && onRight);
        this._deleteRightItem.setEnabled(this._isRightEditable && onRight && allowDeletion);
        this._ignoreLeftItem.setEnabled(onLeft && allowFreezing);
        this._ignoreRightItem.setEnabled(onRight && allowFreezing);
        this._undoAction.update();
        this._redoAction.update();
        if (this._actionBars != null) {
            this._actionBars.updateActionBars();
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.remove(listener_p);
    }

    public void setInput(Object input_p) {
        if (input_p instanceof ModelComparisonDiffNode) {
            this._input = (ModelComparisonDiffNode)((Object)input_p);
            ModelComparisonDiffNode oldInput = this.getInput();
            this.inputChanged((Object)this._input, (Object)oldInput);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        StructuredSelection emptySelection;
        StructuredSelection synthesisSelection = emptySelection = new StructuredSelection();
        StructuredSelection leftModelSelection = emptySelection;
        StructuredSelection rightModelSelection = emptySelection;
        StructuredSelection featureSelection = emptySelection;
        StructuredSelection leftValueSelection = emptySelection;
        StructuredSelection rightValueSelection = emptySelection;
        if (selection_p instanceof ComparisonSelection) {
            ValuesViewer.ValuesInput valuesInput;
            EStructuralFeature feature;
            EMatch match;
            ComparisonSelection selection = (ComparisonSelection)selection_p;
            boolean representAsOwnership = this.representAsOwnership((IDifference)selection.asValuePresence());
            EList<EMatch> matches = selection.asMatches();
            if (!matches.isEmpty()) {
                synthesisSelection = representAsOwnership && matches.size() == 1 ? new StructuredSelection(selection.asValuePresence().getValue()) : new StructuredSelection(matches);
                leftModelSelection = synthesisSelection;
                rightModelSelection = synthesisSelection;
            }
            EMatch eMatch = match = matches.size() == 1 ? (EMatch)matches.get(0) : null;
            if (match != null) {
                if (this.representAsOwnership((IDifference)selection.asValuePresence())) {
                    match = (EMatch)selection.asValuePresence().getValue();
                }
                if (this._featuresViewer.getInput() == null || this._featuresViewer.getInput().getMatch() != match) {
                    this._featuresViewer.setInput(new FeaturesViewer.FeaturesInput(this.getInput(), (IMatch)match));
                }
            } else if (!matches.isEmpty()) {
                this._featuresViewer.setInput(null);
            }
            Object object = feature = !representAsOwnership ? selection.asFeature() : EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature();
            if (feature == null && matches.size() == 1) {
                feature = (EStructuralFeature)this._featuresViewer.getElementAt(0);
            }
            ValuesViewer.ValuesInput valuesInput2 = valuesInput = feature == null ? null : new ValuesViewer.ValuesInput(this.getInput(), new MatchAndFeatureImpl(match, feature));
            if (valuesInput == null || !valuesInput.equals(this._leftValuesViewer.getInput())) {
                this._leftValuesViewer.setInput(valuesInput);
            }
            if (valuesInput == null || !valuesInput.equals(this._rightValuesViewer.getInput())) {
                this._rightValuesViewer.setInput(valuesInput);
            }
            if (feature != null) {
                IValuePresence presence;
                featureSelection = new StructuredSelection((Object)feature);
                EList<EValuePresence> presences = selection.asValuePresences();
                rightValueSelection = leftValueSelection = new StructuredSelection(presences);
                if (presences.size() == 1 && (presence = (IValuePresence)presences.get(0)) instanceof IReferenceValuePresence) {
                    IReferenceValuePresence rvp = (IReferenceValuePresence)presence;
                    IMatch value = this.representAsOwnership((IDifference)rvp) ? rvp.getElementMatch() : rvp.getValue();
                    StructuredSelection rvpSelection = new StructuredSelection((Object)value);
                    if (rvp.getPresenceRole() == this.getRoleForSide(true)) {
                        leftModelSelection = rvpSelection;
                    } else {
                        rightModelSelection = rvpSelection;
                    }
                }
            }
        }
        this._synthesisModelTreeViewer.setSelection((ISelection)synthesisSelection, reveal_p);
        if (this._isLeftRightSynced) {
            this._leftModelTreeViewer.setSelection((ISelection)leftModelSelection, reveal_p);
            this._rightModelTreeViewer.setSelection((ISelection)rightModelSelection, reveal_p);
        }
        this._featuresViewer.setSelection((ISelection)featureSelection, reveal_p);
        this._leftValuesViewer.setSelection((ISelection)leftValueSelection, reveal_p);
        this._rightValuesViewer.setSelection((ISelection)rightValueSelection, reveal_p);
        this._lastUserSelection = selection_p instanceof ComparisonSelection ? (ComparisonSelection)selection_p : new ComparisonSelectionImpl(null, null);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
    }

    protected void setupSashes(final SashForm upperPart_p, final SashForm lowerPart_p) {
        this._control.setWeights(new int[]{5, 2});
        int[] horizontalWeights = new int[]{3, 2, 2};
        upperPart_p.setWeights(horizontalWeights);
        lowerPart_p.setWeights(horizontalWeights);
        this._leftModelTreeViewer.getControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = upperPart_p.getWeights();
                lowerPart_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
        this._leftValuesViewer.getControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = lowerPart_p.getWeights();
                upperPart_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
    }

    protected void setupFeatureMenus() {
        new ToolItem(this._featuresToolbar, 2);
        Menu featureMenu = UIUtil.createMenuTool(this._featuresToolbar);
        MenuItem onlyDiffs = new MenuItem(featureMenu, 16);
        onlyDiffs.setText(Messages.ComparisonViewer_ShowValueDiffs);
        onlyDiffs.setSelection(true);
        onlyDiffs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._featuresViewer.setShowAllFeatures(false);
                ComparisonViewer.this._leftValuesViewer.setShowAllValues(false);
                ComparisonViewer.this._rightValuesViewer.setShowAllValues(false);
            }
        });
        MenuItem allValues = new MenuItem(featureMenu, 16);
        allValues.setText(Messages.ComparisonViewer_ShowAllValues);
        allValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._featuresViewer.setShowAllFeatures(false);
                ComparisonViewer.this._leftValuesViewer.setShowAllValues(true);
                ComparisonViewer.this._rightValuesViewer.setShowAllValues(true);
            }
        });
        MenuItem allFeatures = new MenuItem(featureMenu, 16);
        allFeatures.setText(Messages.ComparisonViewer_ShowAllFeatures);
        allFeatures.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._featuresViewer.setShowAllFeatures(true);
                ComparisonViewer.this._leftValuesViewer.setShowAllValues(true);
                ComparisonViewer.this._rightValuesViewer.setShowAllValues(true);
            }
        });
    }

    protected void setupLockTools() {
        String lockTooltip = Messages.ComparisonViewer_LockTooltip;
        Image lockImage = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.LOCK);
        ToolBar leftModelToolbar = this._leftModelTreeViewer.getToolbar();
        final ToolItem leftLockItem = new ToolItem(leftModelToolbar, 32);
        leftLockItem.setImage(lockImage);
        leftLockItem.setToolTipText(lockTooltip);
        leftLockItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this._isLeftEditable = !leftLockItem.getSelection();
                ComparisonViewer.this.refreshTools();
            }
        });
        leftLockItem.setSelection(!this._isLeftEditable);
        ToolBar rightModelToolbar = this._rightModelTreeViewer.getToolbar();
        final ToolItem rightLockItem = new ToolItem(rightModelToolbar, 32);
        rightLockItem.setImage(lockImage);
        rightLockItem.setToolTipText(lockTooltip);
        rightLockItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this._isRightEditable = !rightLockItem.getSelection();
                ComparisonViewer.this.refreshTools();
            }
        });
        rightLockItem.setSelection(!this._isRightEditable);
    }

    protected void setupMergeTools() {
        this._toRightItem = new ToolItem(this._leftValuesToolbar, 8);
        this._toRightItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION));
        this._toRightItem.setToolTipText(Messages.ComparisonViewer_MergeRightTooltip);
        this._ignoreLeftItem = new ToolItem(this._leftValuesToolbar, 8);
        this._ignoreLeftItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DONE));
        this._ignoreLeftItem.setToolTipText(Messages.ComparisonViewer_IgnoreLeftTooltip);
        this._deleteLeftItem = new ToolItem(this._leftValuesToolbar, 8);
        this._deleteLeftItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DELETE));
        this._deleteLeftItem.setToolTipText(Messages.ComparisonViewer_DeleteLeftTooltip);
        this._toLeftItem = new ToolItem(this._rightValuesToolbar, 8);
        this._toLeftItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION));
        this._toLeftItem.setToolTipText(Messages.ComparisonViewer_MergeLeftTooltip);
        this._ignoreRightItem = new ToolItem(this._rightValuesToolbar, 8);
        this._ignoreRightItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DONE));
        this._ignoreRightItem.setToolTipText(Messages.ComparisonViewer_IgnoreRightTooltip);
        this._deleteRightItem = new ToolItem(this._rightValuesToolbar, 8);
        this._deleteRightItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DELETE));
        this._deleteRightItem.setToolTipText(Messages.ComparisonViewer_DeleteRightTooltip);
        SelectionAdapter mergeToLeft = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(true);
            }
        };
        SelectionAdapter mergeToRight = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(false);
            }
        };
        this._toLeftItem.addSelectionListener((SelectionListener)mergeToLeft);
        this._deleteLeftItem.addSelectionListener((SelectionListener)mergeToLeft);
        this._toRightItem.addSelectionListener((SelectionListener)mergeToRight);
        this._deleteRightItem.addSelectionListener((SelectionListener)mergeToRight);
        this._ignoreLeftItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.ignore(true);
            }
        });
        this._ignoreRightItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.ignore(false);
            }
        });
    }

    protected void setupNavigationTools() {
        this._nextItem = new ToolItem(this._featuresToolbar, 8);
        this._nextItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.NEXT_DIFF_NAV));
        this._nextItem.setToolTipText(Messages.ComparisonViewer_NextTooltip);
        this._nextItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(true);
            }
        });
        this._previousItem = new ToolItem(this._featuresToolbar, 8);
        this._previousItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.PREV_DIFF_NAV));
        this._previousItem.setToolTipText(Messages.ComparisonViewer_PreviousTooltip);
        this._previousItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(false);
            }
        });
    }

    protected void setupSynchronizationListeners() {
        this._synthesisModelTreeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ITreeSelection selection = ComparisonViewer.this._synthesisModelTreeViewer.getSelection();
                if (!selection.isEmpty()) {
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getDrivingRole()), true);
                }
            }
        });
        this._leftModelTreeViewer.getTree().addSelectionListener((SelectionListener)new ComparisonSideSelectionListener(true));
        this._rightModelTreeViewer.getTree().addSelectionListener((SelectionListener)new ComparisonSideSelectionListener(false));
        this._leftValuesViewer.getTable().addSelectionListener((SelectionListener)new ValuesSelectionListener(true));
        this._rightValuesViewer.getTable().addSelectionListener((SelectionListener)new ValuesSelectionListener(false));
        this._featuresViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)ComparisonViewer.this._featuresViewer.getSelection();
                if (selection.size() == 1) {
                    IMatch match;
                    IMatch iMatch = match = ComparisonViewer.this._featuresViewer.getInput() == null ? null : ComparisonViewer.this._featuresViewer.getInput().getMatch();
                    if (match instanceof EMatch) {
                        EStructuralFeature feature = (EStructuralFeature)selection.getFirstElement();
                        MatchAndFeatureImpl newInputDetails = new MatchAndFeatureImpl((EMatch)match, feature);
                        ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(newInputDetails, ComparisonViewer.this.getDrivingRole()), true);
                    }
                }
            }
        });
    }

    protected void setupSynthesisMenus() {
        ToolBar synthesisToolBar = this._synthesisModelTreeViewer.getToolbar();
        Menu synthesisMenu = UIUtil.createMenuTool(synthesisToolBar);
        final MenuItem showUnchanged = new MenuItem(synthesisMenu, 32);
        showUnchanged.setText(Messages.ComparisonViewer_ShowUncountedMenuItem);
        showUnchanged.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (showUnchanged.getSelection()) {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().removeFilter(ComparisonViewer.this._unchangedElementsFilter);
                } else {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().addFilter(ComparisonViewer.this._unchangedElementsFilter);
                }
            }
        });
        final MenuItem showMovedOnce = new MenuItem(synthesisMenu, 32);
        showMovedOnce.setText(Messages.ComparisonViewer_ShowMovesMenuItem);
        showMovedOnce.setSelection(false);
        this._synthesisModelTreeViewer.getComparisonTreeViewer().addFilter(this._moveOriginsFilter);
        showMovedOnce.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (showMovedOnce.getSelection()) {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().removeFilter(ComparisonViewer.this._moveOriginsFilter);
                } else {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().addFilter(ComparisonViewer.this._moveOriginsFilter);
                }
            }
        });
        new MenuItem(synthesisMenu, 2);
        final MenuItem showAdditions = new MenuItem(synthesisMenu, 32);
        showAdditions.setText(Messages.ComparisonViewer_CountAddLeftMenuItem);
        showAdditions.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.OUT_ADD_STAT));
        showAdditions.setSelection(true);
        showAdditions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(ModelComparisonDiffNode.UserDifferenceKind.PRESENCE_LEFT, showAdditions.getSelection());
            }
        });
        final MenuItem showDeletions = new MenuItem(synthesisMenu, 32);
        showDeletions.setText(Messages.ComparisonViewer_CountAddRightMenuItem);
        showDeletions.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.INC_ADD_STAT));
        showDeletions.setSelection(true);
        showDeletions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(ModelComparisonDiffNode.UserDifferenceKind.PRESENCE_RIGHT, showDeletions.getSelection());
            }
        });
        final MenuItem showMoves = new MenuItem(synthesisMenu, 32);
        showMoves.setText(Messages.ComparisonViewer_CountMovesMenuItem);
        showMoves.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.MODIFIED_STAT));
        showMoves.setSelection(true);
        showMoves.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(ModelComparisonDiffNode.UserDifferenceKind.MOVE, showMoves.getSelection());
            }
        });
        final MenuItem showProperDiffs = new MenuItem(synthesisMenu, 32);
        showProperDiffs.setText(Messages.ComparisonViewer_CountProperMenuItem);
        showProperDiffs.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.MODIFIED_STAT));
        showProperDiffs.setSelection(true);
        showProperDiffs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(ModelComparisonDiffNode.UserDifferenceKind.PROPER, showProperDiffs.getSelection());
            }
        });
        new MenuItem(synthesisMenu, 2);
        final MenuItem useCustomIconsItem = new MenuItem(synthesisMenu, 32);
        useCustomIconsItem.setText(Messages.ComparisonViewer_IconsMenuItem);
        useCustomIconsItem.setSelection(true);
        useCustomIconsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (ComparisonViewer.this.getInput() != null) {
                    ComparisonViewer.this.getInput().setUseCustomIcons(useCustomIconsItem.getSelection());
                    ComparisonViewer.this._synthesisModelTreeViewer.refresh();
                    ComparisonViewer.this._featuresViewer.refresh();
                    ComparisonViewer.this._leftValuesViewer.refresh();
                    ComparisonViewer.this._rightValuesViewer.refresh();
                }
            }
        });
        final MenuItem showImpactItem = new MenuItem(synthesisMenu, 32);
        showImpactItem.setText(Messages.ComparisonViewer_ImpactMenuItem);
        showImpactItem.setSelection(this._showMergeImpact);
        showImpactItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._defaultShowImpact = ComparisonViewer.this._showMergeImpact = showImpactItem.getSelection();
            }
        });
        final MenuItem supportUndoRedoItem = new MenuItem(synthesisMenu, 32);
        supportUndoRedoItem.setText(Messages.ComparisonViewer_SupportUndoRedoMenuItem);
        supportUndoRedoItem.setSelection(this._supportUndoRedo);
        supportUndoRedoItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._supportUndoRedo = supportUndoRedoItem.getSelection();
            }
        });
        final MenuItem logEventsItem = new MenuItem(synthesisMenu, 32);
        logEventsItem.setText(Messages.ComparisonViewer_LogEventsMenuItem);
        logEventsItem.setSelection(this._logEvents);
        logEventsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this._logEvents = logEventsItem.getSelection();
                if (ComparisonViewer.this._logEvents) {
                    ComparisonViewer.this.getLogger().log((Object)new CompareLogEvent(ComparisonViewer.this.getEditingDomain(), (IComparison)ComparisonViewer.this.getComparison()));
                }
            }
        });
    }

    protected void setupToolbars() {
        this.setupUndoRedoTools();
        this.setupSynthesisTools();
        this.setupNavigationTools();
        this.setupLockTools();
        this.setupMergeTools();
        this.setupSynthesisMenus();
        this.setupFeatureMenus();
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ComparisonViewer.this.refreshTools();
            }
        });
        this.refreshTools();
    }

    protected void setupSynthesisTools() {
        ToolBar synthesisToolbar = this._synthesisModelTreeViewer.getToolbar();
        new ToolItem(synthesisToolbar, 2);
        ToolItem expandTool = new ToolItem(synthesisToolbar, 8);
        expandTool.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EXPANDALL));
        expandTool.setToolTipText(Messages.ComparisonViewer_ExpandTooltip);
        expandTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        (this).ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().expandAll();
                    }
                });
            }
        });
        ToolItem collapseTool = new ToolItem(synthesisToolbar, 8);
        collapseTool.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.COLLAPSEALL));
        collapseTool.setToolTipText(Messages.ComparisonViewer_CollapseTooltip);
        collapseTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        (this).ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().collapseAll();
                    }
                });
            }
        });
        final ToolItem sortItem = new ToolItem(synthesisToolbar, 32);
        sortItem.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SORT));
        sortItem.setToolTipText(Messages.ComparisonViewer_SortTooltip);
        sortItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (sortItem.getSelection()) {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().setSorter(ComparisonViewer.this._synthesisSorter);
                } else {
                    ComparisonViewer.this._synthesisModelTreeViewer.getComparisonTreeViewer().setSorter(null);
                }
            }
        });
        final ToolItem syncTool = new ToolItem(synthesisToolbar, 32);
        syncTool.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SYNCED));
        syncTool.setToolTipText(Messages.ComparisonViewer_LinkViewsTooltip);
        syncTool.setSelection(this._isLeftRightSynced);
        syncTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this._isLeftRightSynced = syncTool.getSelection();
                if (ComparisonViewer.this._isLeftRightSynced) {
                    BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            ITreeSelection selection = (this).ComparisonViewer.this._synthesisModelTreeViewer.getSelection();
                            (this).ComparisonViewer.this._leftModelTreeViewer.setSelection((ISelection)selection, true);
                            (this).ComparisonViewer.this._rightModelTreeViewer.setSelection((ISelection)selection, true);
                        }
                    });
                }
            }
        });
        new ToolItem(synthesisToolbar, 2);
    }

    protected void setupUndoRedoTools() {
        this._undoAction = new UndoAction(null){

            public void run() {
                ComparisonViewer.this.undoRedo(true);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._undoAction.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.UNDO));
        this._redoAction = new RedoAction(){

            public void run() {
                ComparisonViewer.this.undoRedo(false);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._redoAction.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.REDO));
        if (this._actionBars != null) {
            this._actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this._undoAction);
            this._actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this._redoAction);
        }
    }

    protected void undoRedo(final boolean undo_p) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CommandStack stack = ComparisonViewer.this.getEditingDomain().getCommandStack();
                ComparisonSelection lastActionSelection = ComparisonViewer.this.getUIComparison().getLastActionSelection();
                if (undo_p && stack.canUndo()) {
                    stack.undo();
                } else if (!undo_p && stack.canRedo()) {
                    stack.redo();
                }
                boolean dirty = stack.getUndoCommand() != ComparisonViewer.this._lastCommandBeforeSave;
                ComparisonViewer.this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(dirty));
                ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.DIFFERENCE_NUMBERS_STATE, null);
                if (lastActionSelection != null) {
                    ComparisonViewer.this.setSelection((ISelection)lastActionSelection, true);
                }
            }
        });
    }

    protected class ComparisonSideSelectionListener
    extends SelectionAdapter {
        private final boolean _sideIsLeft;

        public ComparisonSideSelectionListener(boolean sideIsLeft_p) {
            this._sideIsLeft = sideIsLeft_p;
        }

        public void widgetSelected(SelectionEvent event_p) {
            EnhancedComparisonSideViewer modelViewer;
            ITreeSelection selection;
            if (ComparisonViewer.this._isLeftRightSynced && !(selection = (modelViewer = this._sideIsLeft ? ComparisonViewer.this._leftModelTreeViewer : ComparisonViewer.this._rightModelTreeViewer).getSelection()).isEmpty()) {
                ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getRoleForSide(this._sideIsLeft)), true);
            }
        }
    }

    protected class MergeImpactMessageDialog
    extends MessageDialog {
        private final MergeImpactViewer.ImpactInput _dialogInput;

        public MergeImpactMessageDialog(Shell parentShell_p, MergeImpactViewer.ImpactInput input_p) {
            super(parentShell_p, Messages.ComparisonViewer_MergeHeader, null, String.format(Messages.ComparisonViewer_ImpactDescription, input_p.isOnTheLeft() ? Messages.ComparisonViewer_Left : Messages.ComparisonViewer_Right), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this._dialogInput = input_p;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createCustomArea(Composite parent_p) {
            MergeImpactViewer viewer = new MergeImpactViewer(parent_p, ComparisonViewer.this.getResourceManager());
            viewer.setInput(this._dialogInput);
            return viewer.getControl();
        }

        public boolean openAndConfirm() {
            return this.open() == 0;
        }
    }

    protected class ValuesSelectionListener
    extends SelectionAdapter {
        private final boolean _sideIsLeft;

        public ValuesSelectionListener(boolean sideIsLeft_p) {
            this._sideIsLeft = sideIsLeft_p;
        }

        public void widgetSelected(SelectionEvent event_p) {
            ValuesViewer valuesViewer = this._sideIsLeft ? ComparisonViewer.this._leftValuesViewer : ComparisonViewer.this._rightValuesViewer;
            IStructuredSelection selection = valuesViewer.getSelection();
            if (!selection.isEmpty()) {
                ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getRoleForSide(this._sideIsLeft)), true);
            }
        }
    }
}

