/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.AbstractScopeSpecificationFactory;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.emf.diffmerge.ui.specification.ext.FileScopeSpecification;

public class FileScopeSpecificationFactory
extends AbstractScopeSpecificationFactory {
    public IScopeSpecification createScopeSpecification(Object entrypoint_p, String label_p, boolean editable_p) {
        IScopeSpecification result = null;
        String label = label_p;
        URI uri = null;
        if (entrypoint_p instanceof URI) {
            uri = (URI)entrypoint_p;
        } else if (entrypoint_p instanceof IFile) {
            IFile file = (IFile)entrypoint_p;
            if (label == null) {
                label = this.getLabelForFile(file);
            }
            uri = this.toPlatformUri(file);
        } else if (entrypoint_p instanceof String) {
            uri = this.toFileUri(entrypoint_p.toString());
        }
        if (uri != null) {
            result = this.createScopeSpecificationFromUri(uri, label, editable_p);
        }
        return result;
    }

    protected IScopeSpecification createScopeSpecificationFromUri(URI uri_p, String label_p, boolean editable_p) {
        return new FileScopeSpecification(uri_p, label_p, editable_p);
    }

    protected String getFileExtension(Object entrypoint_p) {
        String location;
        int dotPosition;
        String result = null;
        if (entrypoint_p instanceof IFile) {
            result = ((IFile)entrypoint_p).getFileExtension();
        } else if (entrypoint_p instanceof URI) {
            result = ((URI)entrypoint_p).fileExtension();
        } else if (entrypoint_p instanceof String && (dotPosition = (location = (String)entrypoint_p).lastIndexOf(File.separator)) > -1 && dotPosition < location.length()) {
            result = location.substring(dotPosition + 1);
        }
        if (result != null) {
            result = result.toLowerCase();
        }
        return result;
    }

    public String getLabel() {
        return Messages.FileScopeSpecificationFactory_Label;
    }

    protected String getLabelForFile(IFile file_p) {
        String result = null;
        if (file_p != null && (result = file_p.getFullPath().toPortableString()).startsWith("/") && result.length() > 1) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean isApplicableTo(Object entrypoint_p) {
        return true;
    }

    protected URI toFileUri(String file_p) {
        URI result = null;
        if (file_p != null) {
            result = URI.createFileURI((String)file_p);
        }
        return result;
    }

    protected URI toPlatformUri(IFile file_p) {
        URI result = null;
        if (file_p != null) {
            result = URI.createPlatformResourceURI((String)file_p.getFullPath().toPortableString(), (boolean)true);
        }
        return result;
    }
}

