/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.generic.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultDiffPolicy;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConfigurableDiffPolicy
extends DefaultDiffPolicy
implements IConfigurablePolicy {
    private boolean _ignoreOrders = false;
    protected final Set<IConfigurablePolicy.IConfigurationChangedListener> _listeners = new LinkedHashSet<IConfigurablePolicy.IConfigurationChangedListener>();

    public ConfigurableDiffPolicy() {
    }

    public ConfigurableDiffPolicy(ConfigurableDiffPolicy policy_p) {
        this();
        this.update(policy_p);
    }

    public void addConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.add(listener_p);
    }

    @Override
    protected boolean considerOrderedFeature(EStructuralFeature feature_p) {
        boolean result = this._ignoreOrders ? false : this.doConsiderOrdered(feature_p);
        return result;
    }

    protected boolean doConsiderOrdered(EStructuralFeature feature_p) {
        return super.considerOrderedFeature(feature_p);
    }

    protected void fireConfigurationChanged(Object property_p) {
        for (IConfigurablePolicy.IConfigurationChangedListener listener : this._listeners) {
            listener.configurationChanged((IConfigurablePolicy)this, property_p);
        }
    }

    public boolean isIgnoreOrders() {
        return this._ignoreOrders;
    }

    public void removeConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.remove(listener_p);
    }

    public void setIgnoreOrders(boolean ignore_p) {
        this._ignoreOrders = ignore_p;
        this.fireConfigurationChanged(null);
    }

    public boolean update(IConfigurablePolicy policy_p) {
        boolean result = false;
        if (policy_p instanceof ConfigurableDiffPolicy) {
            ConfigurableDiffPolicy policy = (ConfigurableDiffPolicy)policy_p;
            this.setIgnoreOrders(policy.isIgnoreOrders());
            result = true;
        }
        return result;
    }

    public ConfigurableDiffPolicy copy() {
        return new ConfigurableDiffPolicy(this);
    }
}

