/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ComboBoxCellEditor
extends CellEditor {
    private Composite fEditor;
    private CCombo combo;
    private String fSelection;
    private Control focusControl = null;
    protected LabelValuePair[] fItems;
    protected Object fValue;

    public void createItems(LabelValuePair[] items) {
        this.fItems = items;
    }

    public LabelValuePair[] getLabelValuePairs() {
        return this.fItems;
    }

    public ComboBoxCellEditor(Composite parent, LabelValuePair[] items) {
        super(parent);
        this.fItems = items;
    }

    protected Control createControl(Composite parent) {
        Font f = parent.getFont();
        this.fEditor = new Composite(parent, 0);
        this.fEditor.setFont(f);
        this.fEditor.setLayout((Layout)new ComboCellLayout());
        this.combo = new CCombo(this.fEditor, 8);
        this.combo.setFont(f);
        this.combo.setBackground(parent.getBackground());
        this.setValueValid(true);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                if (ComboBoxCellEditor.this.getCombo().getSelectionIndex() >= 0) {
                    ComboBoxCellEditor.this.fireApplyEditorValue();
                }
                ComboBoxCellEditor.this.deactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                if (ComboBoxCellEditor.this.getCombo().getSelectionIndex() >= 0) {
                    ComboBoxCellEditor.this.setSelection(ComboBoxCellEditor.this.getCombo().getItem(ComboBoxCellEditor.this.getCombo().getSelectionIndex()));
                    int i = 0;
                    while (i < ComboBoxCellEditor.this.fItems.length) {
                        if (ComboBoxCellEditor.this.fItems[i].fLabel.equals(ComboBoxCellEditor.this.getSelection())) {
                            ComboBoxCellEditor.this.doSetValue(ComboBoxCellEditor.this.fItems[i].fValue);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.fireApplyEditorValue();
                ComboBoxCellEditor.this.forwardFocusLost();
            }

            public void focusGained(FocusEvent event) {
                ComboBoxCellEditor.this.refreshComboItems();
                ComboBoxCellEditor.this.fillCombo();
            }
        });
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ComboBoxCellEditor.this.fireCancelEditor();
                    ComboBoxCellEditor.this.keyReleaseOccured(e);
                } else if (e.character == '\r') {
                    if (ComboBoxCellEditor.this.getCombo().getSelectionIndex() >= 0) {
                        ComboBoxCellEditor.this.setSelection(ComboBoxCellEditor.this.getCombo().getItem(ComboBoxCellEditor.this.getCombo().getSelectionIndex()));
                        int i = 0;
                        while (i < ComboBoxCellEditor.this.fItems.length) {
                            if (ComboBoxCellEditor.this.fItems[i].fLabel.equals(ComboBoxCellEditor.this.getSelection())) {
                                ComboBoxCellEditor.this.doSetValue(ComboBoxCellEditor.this.fItems[i].fValue);
                                break;
                            }
                            ++i;
                        }
                        ComboBoxCellEditor.this.fireApplyEditorValue();
                    }
                    ComboBoxCellEditor.this.keyReleaseOccured(e);
                }
            }
        });
        return this.fEditor;
    }

    protected void fireCancelEditor() {
        super.fireCancelEditor();
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        super.keyReleaseOccured(keyEvent);
    }

    protected void refreshComboItems() {
    }

    protected Object doGetValue() {
        return this.fValue;
    }

    protected void doSetFocus() {
        this.combo.setFocus();
    }

    protected void doSetValue(Object value) {
        this.fValue = value;
    }

    protected void fillCombo() {
        if (this.fItems != null) {
            this.fSelection = null;
            String[] labels = new String[this.fItems.length];
            int i = 0;
            while (i < labels.length) {
                LabelValuePair item = this.fItems[i];
                labels[i] = item.fLabel;
                if (this.fSelection == null && this.fValue != null && this.fValue.equals(item.fValue)) {
                    this.fSelection = item.fLabel;
                }
                ++i;
            }
            this.combo.setItems(labels);
            if (this.fSelection != null) {
                this.combo.setText(this.fSelection);
            }
        }
    }

    public void forwardFocusLost() {
        this.focusLost();
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public String getSelection() {
        return this.fSelection;
    }

    public void setSelection(String selection) {
        this.fSelection = selection;
    }

    public void deactivate() {
        super.deactivate();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            this.focusControl.setFocus();
        }
    }

    public void activate() {
        if (Display.getCurrent() != null) {
            this.focusControl = Display.getCurrent().getFocusControl();
        }
        super.activate();
    }

    private class ComboCellLayout
    extends Layout {
        private ComboCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            ComboBoxCellEditor.this.getCombo().setBounds(0, 0, bounds.width, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point size = ComboBoxCellEditor.this.getCombo().computeSize(-1, -1, force);
            int width = 0;
            if (ComboBoxCellEditor.this.fItems != null) {
                GC gc = new GC((Drawable)ComboBoxCellEditor.this.getCombo());
                int i = 0;
                while (i < ComboBoxCellEditor.this.fItems.length) {
                    width = Math.max(width, gc.textExtent((String)ComboBoxCellEditor.this.fItems[i].fLabel).x);
                    ++i;
                }
                width += gc.textExtent((String)"M").x;
                gc.dispose();
            }
            size.x = width;
            return size;
        }
    }
}

