/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.internal.ui.wizards.WizardCategoryProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.wizard.IWizard;

public class ConnectionProfileManagerUI {
    private static ConnectionProfileManagerUI sInstance = new ConnectionProfileManagerUI();
    private Map mNewWizards = null;
    private Map mWizardCategories = null;

    public static ConnectionProfileManagerUI getInstance() {
        return sInstance;
    }

    private ConnectionProfileManagerUI() {
        ConnectionProfileManager.getInstance();
    }

    public Map getWizardCategories() {
        if (this.mWizardCategories == null) {
            this.processExtensions();
        }
        return this.mWizardCategories;
    }

    public Map getNewWizards() {
        if (this.mNewWizards == null) {
            this.processExtensions();
        }
        return this.mNewWizards;
    }

    public IWizardCategoryProvider getWizardCategory(String id) {
        return (IWizardCategoryProvider)this.getWizardCategories().get(id);
    }

    public IWizard getNewWizard(String id) {
        ProfileWizardProvider profileWizard = (ProfileWizardProvider)this.getNewWizards().get(id);
        if (profileWizard == null) {
            return null;
        }
        return ((ProfileWizardProvider)this.getNewWizards().get(id)).getWizard();
    }

    private void processNewWizard(IConfigurationElement element) {
        ProfileWizardProvider c = new ProfileWizardProvider(element);
        Assert.isTrue((!this.mNewWizards.containsKey(c.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{element.toString()}));
        this.mNewWizards.put(c.getId(), c);
    }

    private void processWizardCategory(IConfigurationElement element) {
        WizardCategoryProvider c = new WizardCategoryProvider(element);
        Assert.isTrue((!this.mWizardCategories.containsKey(c.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{element.toString()}));
        this.mWizardCategories.put(c.getId(), c);
    }

    private void processExtensions() {
        this.mNewWizards = new HashMap();
        this.mWizardCategories = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exp = registry.getExtensionPoint("org.eclipse.datatools.connectivity.connectionProfile");
        IExtension[] exts = exp.getExtensions();
        for (IExtension ext : Arrays.asList(exts)) {
            IConfigurationElement[] elems = ext.getConfigurationElements();
            for (IConfigurationElement elem : Arrays.asList(elems)) {
                String elemName = elem.getName();
                if ("newWizard".equals(elemName)) {
                    this.processNewWizard(elem);
                    continue;
                }
                if (!"wizardCategory".equals(elemName)) continue;
                this.processWizardCategory(elem);
            }
        }
    }
}

