/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.diffmerge.DiffMergeMode;
import org.eclipse.egit.ui.internal.diffmerge.DiffMergeSettings;
import org.eclipse.egit.ui.internal.diffmerge.DiffToolMode;
import org.eclipse.egit.ui.internal.diffmerge.MergeMode;
import org.eclipse.egit.ui.internal.diffmerge.MergeToolMode;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DiffPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DiffMergePreferencesManager prefsManager;

    public void init(IWorkbench workbench) {
        this.prefsManager = new DiffMergePreferencesManager(this.getPreferenceStore());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        Composite container = this.getFieldEditorParent();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDiffToolSection(container);
        this.createMergeToolSection(container);
    }

    private GridLayout createGridWithLeftMergins() {
        GridLayout leftMargin = new GridLayout();
        leftMargin.marginLeft = 5;
        return leftMargin;
    }

    private void createDiffToolSection(Composite container) {
        HashMap<Button, DiffMergeMode> diffControls = new HashMap<Button, DiffMergeMode>();
        Group diffGroup = new Group(container, 0);
        diffGroup.setLayout((Layout)new GridLayout());
        diffGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        diffGroup.setBackground(container.getBackground());
        diffGroup.setText(UIText.DiffPreferencePage_DiffToolSection);
        String externalDiffToolPreference = DiffMergeSettings.getExternalDiffToolPreference();
        if (StringUtils.isEmptyOrNull((String)externalDiffToolPreference)) {
            Text warningText = new Text((Composite)diffGroup, 8);
            warningText.setText(UIText.DiffPreferencePage_WarningMessage);
            warningText.setEditable(false);
        }
        Label diffToolToUseLabel = new Label((Composite)diffGroup, 8);
        diffToolToUseLabel.setText(UIText.DiffPreferencePage_DiffToolToUse);
        Button useInternal = new Button((Composite)diffGroup, 16);
        useInternal.setText(UIText.DiffPreferencePage_UseBuiltInEditor);
        diffControls.put(useInternal, DiffToolMode.INTERNAL);
        if (this.prefsManager.isActiveMode(DiffToolMode.INTERNAL) || this.prefsManager.isActiveMode(DiffToolMode.EXTERNAL_FOR_TYPE)) {
            useInternal.setSelection(true);
        }
        Composite attributesCont = new Composite((Composite)diffGroup, 0);
        attributesCont.setLayout((Layout)this.createGridWithLeftMergins());
        Button useExternalForType = new Button(attributesCont, 32);
        useExternalForType.setText(UIText.DiffPreferencePage_UseExternalForType);
        if (this.prefsManager.isActiveMode(DiffToolMode.GIT_CONFIG) || this.prefsManager.isActiveMode(DiffToolMode.EXTERNAL)) {
            useExternalForType.setEnabled(false);
        }
        diffControls.put(useExternalForType, DiffToolMode.EXTERNAL_FOR_TYPE);
        useInternal.addListener(13, event -> {
            this.prefsManager.setActiveMode(DiffToolMode.INTERNAL);
            useExternalForType.setEnabled(true);
        });
        if (this.prefsManager.isActiveMode(DiffToolMode.EXTERNAL_FOR_TYPE)) {
            useExternalForType.setSelection(true);
        }
        useExternalForType.addListener(13, event -> {
            if (useExternalForType.getSelection()) {
                this.prefsManager.setActiveMode(DiffToolMode.EXTERNAL_FOR_TYPE);
            } else {
                this.prefsManager.setActiveMode(DiffToolMode.INTERNAL);
            }
        });
        this.prefsManager.addControlWithCustomReset((Control)useExternalForType, () -> useExternalForType.setEnabled(true));
        Button useGitConfig = new Button((Composite)diffGroup, 16);
        useGitConfig.setText(UIText.DiffPreferencePage_UseGitConfig);
        if (this.prefsManager.isActiveMode(DiffToolMode.GIT_CONFIG)) {
            useGitConfig.setSelection(true);
        }
        diffControls.put(useGitConfig, DiffToolMode.GIT_CONFIG);
        useGitConfig.addListener(13, event -> {
            if (useGitConfig.getSelection()) {
                this.prefsManager.setActiveMode(DiffToolMode.GIT_CONFIG);
                useExternalForType.setEnabled(false);
            }
        });
        final Button useExternal = new Button((Composite)diffGroup, 16);
        useExternal.setText(UIText.DiffPreferencePage_UseExternal);
        if (this.prefsManager.isActiveMode(DiffToolMode.EXTERNAL)) {
            useExternal.setSelection(true);
        }
        useExternal.addListener(13, event -> {
            if (useExternal.getSelection()) {
                this.prefsManager.setActiveMode(DiffToolMode.EXTERNAL);
                useExternalForType.setEnabled(false);
            }
        });
        diffControls.put(useExternal, DiffToolMode.EXTERNAL);
        Composite diffToolCustomCont = new Composite((Composite)diffGroup, 0);
        diffToolCustomCont.setLayout((Layout)this.createGridWithLeftMergins());
        final Combo customDiffCombo = new Combo(diffToolCustomCont, 8);
        Set<String> diffToolsList = DiffMergeSettings.getAvailableDiffTools();
        for (String tool : diffToolsList) {
            customDiffCombo.add(tool);
        }
        IPreferenceStore store = this.getPreferenceStore();
        String defaultCustomDiffTool = store.getString("diff_tool_custom");
        if (diffToolsList.contains(defaultCustomDiffTool)) {
            customDiffCombo.setText(defaultCustomDiffTool);
        } else {
            customDiffCombo.setText(diffToolsList.stream().findFirst().orElse(""));
        }
        customDiffCombo.setEnabled(this.prefsManager.isActiveMode(DiffToolMode.EXTERNAL));
        customDiffCombo.addListener(13, event -> this.prefsManager.setCustomTool("diff_tool_custom", customDiffCombo.getText()));
        useExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                customDiffCombo.setEnabled(useExternal.getSelection());
            }
        });
        this.prefsManager.addControlWithCustomReset((Control)customDiffCombo, () -> {
            customDiffCombo.setEnabled(false);
            customDiffCombo.setText(store.getString("diff_tool_custom"));
        });
        this.prefsManager.bindButtons(diffControls);
        this.updateMargins(diffGroup);
    }

    private void createMergeToolSection(Composite container) {
        HashMap<Button, DiffMergeMode> mergeControls = new HashMap<Button, DiffMergeMode>();
        Group mergeGroup = new Group(container, 0);
        mergeGroup.setLayout((Layout)new GridLayout());
        mergeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        mergeGroup.setBackground(container.getBackground());
        mergeGroup.setText(UIText.DiffPreferencePage_MergeToolSection);
        Composite toolContentSection = new Composite((Composite)mergeGroup, 0);
        toolContentSection.setLayout((Layout)new GridLayout());
        Label mergeContentLabel = new Label(toolContentSection, 8);
        mergeContentLabel.setText(UIText.DiffPreferencePage_MergeToolContent);
        Button promptForTool = new Button(toolContentSection, 16);
        promptForTool.setText(UIText.DiffPreferencePage_MergePromptMode);
        if (this.prefsManager.isActiveMode(MergeMode.PROMPT)) {
            promptForTool.setSelection(true);
        }
        promptForTool.addListener(13, event -> this.prefsManager.setActiveMode(MergeMode.PROMPT));
        mergeControls.put(promptForTool, MergeMode.PROMPT);
        Button oursPreMerged = new Button(toolContentSection, 16);
        oursPreMerged.setText(UIText.DiffPreferencePage_MergeModePremergedOursMode);
        if (this.prefsManager.isActiveMode(MergeMode.OURS)) {
            oursPreMerged.setSelection(true);
        }
        oursPreMerged.addListener(13, event -> this.prefsManager.setActiveMode(MergeMode.OURS));
        mergeControls.put(oursPreMerged, MergeMode.OURS);
        Button workspacePreMerged = new Button(toolContentSection, 16);
        workspacePreMerged.setText(UIText.DiffPreferencePage_MergeWorkspaceMode);
        if (this.prefsManager.isActiveMode(MergeMode.WORKSPACE)) {
            workspacePreMerged.setSelection(true);
        }
        workspacePreMerged.addListener(13, event -> this.prefsManager.setActiveMode(MergeMode.WORKSPACE));
        mergeControls.put(workspacePreMerged, MergeMode.WORKSPACE);
        Button lastHead = new Button(toolContentSection, 16);
        lastHead.setText(UIText.DiffPreferencePage_MergeLastHeadMode);
        if (this.prefsManager.isActiveMode(MergeMode.LAST_HEAD)) {
            lastHead.setSelection(true);
        }
        lastHead.addListener(13, event -> this.prefsManager.setActiveMode(MergeMode.LAST_HEAD));
        mergeControls.put(lastHead, MergeMode.LAST_HEAD);
        Composite toolToUseSection = new Composite((Composite)mergeGroup, 0);
        toolToUseSection.setLayout((Layout)new GridLayout());
        Label mergeToolToUseLabel = new Label(toolToUseSection, 8);
        mergeToolToUseLabel.setText(UIText.DiffPreferencePage_MergeToolToUse);
        Button mergeUseEclipseCompare = new Button(toolToUseSection, 16);
        mergeUseEclipseCompare.setText(UIText.DiffPreferencePage_UseBuiltInEditor);
        if (this.prefsManager.isActiveMode(MergeToolMode.INTERNAL)) {
            mergeUseEclipseCompare.setSelection(true);
        }
        mergeUseEclipseCompare.addListener(13, event -> this.prefsManager.setActiveMode(MergeToolMode.INTERNAL));
        mergeControls.put(mergeUseEclipseCompare, MergeToolMode.INTERNAL);
        Composite attributesCont = new Composite(toolToUseSection, 0);
        attributesCont.setLayout((Layout)this.createGridWithLeftMergins());
        final Button useExternalForType = new Button(attributesCont, 32);
        useExternalForType.setText(UIText.DiffPreferencePage_UseExternalForType);
        if (this.prefsManager.isActiveMode(MergeToolMode.GIT_CONFIG) || this.prefsManager.isActiveMode(MergeToolMode.EXTERNAL)) {
            useExternalForType.setEnabled(false);
        }
        mergeControls.put(useExternalForType, MergeToolMode.EXTERNAL_FOR_TYPE);
        mergeUseEclipseCompare.addListener(13, event -> {
            this.prefsManager.setActiveMode(MergeToolMode.INTERNAL);
            useExternalForType.setEnabled(true);
        });
        if (this.prefsManager.isActiveMode(MergeToolMode.EXTERNAL_FOR_TYPE)) {
            useExternalForType.setSelection(true);
        }
        useExternalForType.addListener(13, event -> {
            if (useExternalForType.getSelection()) {
                this.prefsManager.setActiveMode(MergeToolMode.EXTERNAL_FOR_TYPE);
            } else {
                this.prefsManager.setActiveMode(MergeToolMode.INTERNAL);
            }
        });
        this.prefsManager.addControlWithCustomReset((Control)useExternalForType, () -> useExternalForType.setEnabled(true));
        Button useGitConfig = new Button(toolToUseSection, 16);
        useGitConfig.setText(UIText.DiffPreferencePage_UseGitConfig);
        if (this.prefsManager.isActiveMode(MergeToolMode.GIT_CONFIG)) {
            useGitConfig.setSelection(true);
        }
        mergeControls.put(useGitConfig, MergeToolMode.GIT_CONFIG);
        useGitConfig.addListener(13, event -> {
            if (useGitConfig.getSelection()) {
                this.prefsManager.setActiveMode(MergeToolMode.GIT_CONFIG);
                useExternalForType.setEnabled(false);
            }
        });
        final Button mergeUseExternalTool = new Button(toolToUseSection, 16);
        mergeUseExternalTool.setText(UIText.DiffPreferencePage_UseExternal);
        if (this.prefsManager.isActiveMode(MergeToolMode.EXTERNAL)) {
            mergeUseExternalTool.setSelection(true);
        }
        mergeUseExternalTool.addListener(13, event -> this.prefsManager.setActiveMode(MergeToolMode.EXTERNAL));
        mergeControls.put(mergeUseExternalTool, MergeToolMode.EXTERNAL);
        Composite mergeToolCustomCont = new Composite(toolToUseSection, 0);
        mergeToolCustomCont.setLayout((Layout)new GridLayout());
        final Combo customMergeCombo = new Combo(mergeToolCustomCont, 8);
        Set<String> mergeTools = DiffMergeSettings.getAvailableMergeTools();
        for (String tool : mergeTools) {
            customMergeCombo.add(tool);
        }
        IPreferenceStore store = this.getPreferenceStore();
        String defaultCustomMergeTool = store.getString("merge_tool_custom");
        if (mergeTools.contains(defaultCustomMergeTool)) {
            customMergeCombo.setText(defaultCustomMergeTool);
        } else {
            customMergeCombo.setText(mergeTools.stream().findFirst().orElse(""));
        }
        if (this.prefsManager.isActiveMode(MergeToolMode.INTERNAL)) {
            customMergeCombo.setEnabled(false);
        } else {
            customMergeCombo.setEnabled(true);
        }
        mergeUseExternalTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                customMergeCombo.setEnabled(mergeUseExternalTool.getSelection());
                useExternalForType.setEnabled(false);
            }
        });
        customMergeCombo.addListener(13, event -> this.prefsManager.setCustomTool("merge_tool_custom", customMergeCombo.getText()));
        this.prefsManager.addControlWithCustomReset((Control)customMergeCombo, () -> {
            customMergeCombo.setEnabled(false);
            customMergeCombo.setText(store.getString("merge_tool_custom"));
        });
        this.addField((FieldEditor)new BooleanFieldEditor("merge_tool_auto_add", UIText.DiffPreferencePage_MergeAddExternalMergedFile, toolToUseSection));
        this.prefsManager.bindButtons(mergeControls);
        this.updateMargins(mergeGroup);
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    public boolean performOk() {
        this.prefsManager.saveChanges();
        return super.performOk();
    }

    protected void performDefaults() {
        this.prefsManager.resetChanges();
        this.prefsManager.resetSelections();
        super.performDefaults();
    }

    public void dispose() {
        this.prefsManager.emptyControlsStore();
        super.dispose();
    }

    static class DiffMergePreferencesManager {
        private IPreferenceStore store;
        private Map<Button, DiffMergeMode> buttons;
        private Map<Control, Runnable> customResetControls;
        private Map<String, Integer> modeSelections;
        private Map<String, String> toolSelections;

        public DiffMergePreferencesManager(IPreferenceStore store) {
            this.store = store;
            this.buttons = new LinkedHashMap<Button, DiffMergeMode>();
            this.customResetControls = new LinkedHashMap<Control, Runnable>();
            this.modeSelections = new LinkedHashMap<String, Integer>();
            this.toolSelections = new LinkedHashMap<String, String>();
        }

        private void bindButtons(Map<Button, DiffMergeMode> bindings) {
            this.buttons.putAll(bindings);
        }

        private void emptyControlsStore() {
            this.buttons.clear();
            this.customResetControls.clear();
        }

        private void removeButtonsSelections() {
            for (Button button : this.buttons.keySet()) {
                button.setSelection(false);
            }
        }

        private void resetSelections() {
            this.removeButtonsSelections();
            this.setControlsSelections(DiffToolMode.class);
            this.setControlsSelections(MergeToolMode.class);
            this.setControlsSelections(MergeMode.class);
            this.resetControlsWithCustomReset();
        }

        private void saveChanges() {
            for (Map.Entry<String, Integer> entry : this.modeSelections.entrySet()) {
                this.store.setValue(entry.getKey(), entry.getValue().intValue());
            }
            for (Map.Entry<String, Object> entry : this.toolSelections.entrySet()) {
                this.store.setValue(entry.getKey(), (String)entry.getValue());
            }
        }

        private void resetChanges() {
            this.store.setToDefault("diff_tool_mode");
            this.store.setToDefault("merge_tool_mode");
            this.store.setToDefault("merge_mode");
            this.store.setToDefault("diff_tool_custom");
            this.store.setToDefault("merge_tool_custom");
        }

        private void setButtonsSelectionsForMode(int modeId) {
            for (Map.Entry<Button, DiffMergeMode> entry : this.buttons.entrySet()) {
                if (entry.getValue().getValue() != modeId) continue;
                entry.getKey().setSelection(true);
            }
        }

        public void setControlsSelections(Class<? extends DiffMergeMode> mode) {
            int modeId = 0;
            if (mode == DiffToolMode.class) {
                modeId = this.store.getInt("diff_tool_mode");
            } else if (mode == MergeToolMode.class) {
                modeId = this.store.getInt("merge_tool_mode");
            } else if (mode == MergeMode.class) {
                modeId = this.store.getInt("merge_mode");
            }
            this.setButtonsSelectionsForMode(modeId);
        }

        private void setCustomTool(String toolId, String selection) {
            this.toolSelections.put(toolId, selection);
        }

        private void setActiveMode(DiffMergeMode mode) {
            String modeKey = null;
            if (mode instanceof DiffToolMode) {
                modeKey = "diff_tool_mode";
            } else if (mode instanceof MergeToolMode) {
                modeKey = "merge_tool_mode";
            } else if (mode instanceof MergeMode) {
                modeKey = "merge_mode";
            }
            if (modeKey != null) {
                this.modeSelections.put(modeKey, mode.getValue());
            }
        }

        private boolean isActiveMode(DiffMergeMode mode) {
            if (mode instanceof DiffToolMode) {
                return mode.getValue() == this.store.getInt("diff_tool_mode");
            }
            if (mode instanceof MergeMode) {
                return mode.getValue() == this.store.getInt("merge_mode");
            }
            if (mode instanceof MergeToolMode) {
                return mode.getValue() == this.store.getInt("merge_tool_mode");
            }
            return false;
        }

        private void addControlWithCustomReset(Control c, Runnable reset) {
            this.customResetControls.put(c, reset);
        }

        private void resetControlsWithCustomReset() {
            for (Runnable r : this.customResetControls.values()) {
                r.run();
            }
        }
    }
}

