/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.tools;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;

public class Converter {
    private static final ImmutableList<String> FILE_SCOPE = Lists.immutable.of((Object)".java", (Object)".xml", (Object)"gradle");
    private static final ImmutableMap<String, String> CONVERSION_MAP = Maps.immutable.with((Object)"com\\.gs", (Object)"org\\.eclipse", (Object)"com\\.goldmansachs", (Object)"org\\.eclipse\\.collections", (Object)"gs-collections", (Object)"eclipse-collections");

    public static void main(String ... args) {
        String path;
        if (args.length != 1) {
            System.out.println("Usage: gsc-ec-converter <PATH_TO_PROJECT>");
            System.exit(1);
        }
        if (Files.exists(Paths.get(path = args[0], new String[0]), new LinkOption[0])) {
            System.out.println("Running Eclipse Collections Converter against " + path + ".");
            Converter.convert(path);
            System.out.println("Done!");
        } else {
            System.out.println("Invalid path: " + path);
            System.exit(1);
        }
    }

    private static void convert(String path) {
        try {
            Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> FILE_SCOPE.anySatisfy((Predicate & Serializable)suffix -> file.getFileName().toString().endsWith((String)suffix))).forEach(file -> {
                try {
                    boolean[] fileChanged = new boolean[]{false};
                    List replacedLines = Files.lines(file, Charset.defaultCharset()).map(line -> {
                        String newLine = Converter.replaceMatching(line);
                        blArray[0] = fileChanged[0] || !newLine.equals(line);
                        return newLine;
                    }).collect(Collectors.toList());
                    if (fileChanged[0]) {
                        Files.write(file, replacedLines, new OpenOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("A problem occurred in file: " + file, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String replaceMatching(String original) {
        String[] temp = new String[]{original};
        CONVERSION_MAP.forEachKeyValue((Procedure2 & Serializable)(key, value) -> {
            Pattern pattern = Pattern.compile(key);
            Matcher matcher = pattern.matcher(temp[0]);
            stringArray[0] = matcher.replaceAll((String)value);
        });
        return temp[0];
    }
}

