/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectDoubleIterable;

public final class LazyDoubleIterate {
    private static final LazyDoubleIterable EMPTY_ITERABLE = DoubleLists.immutable.of().asLazy();

    private LazyDoubleIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyDoubleIterable adapt(DoubleIterable iterable) {
        return new LazyDoubleIterableAdapter(iterable);
    }

    public static LazyDoubleIterable select(DoubleIterable iterable, DoublePredicate predicate) {
        return new SelectDoubleIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(DoubleIterable iterable, DoubleToObjectFunction<? extends V> function) {
        return new CollectDoubleToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(DoubleIterable iterable, DoublePredicate predicate, DoubleToObjectFunction<? extends V> function) {
        return LazyDoubleIterate.select(iterable, predicate).collect((DoubleToObjectFunction)function);
    }

    public static LazyDoubleIterable empty() {
        return EMPTY_ITERABLE;
    }
}

