/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable;

import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.factory.stack.MutableStackFactory;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

@Immutable
public final class MutableStackFactoryImpl
implements MutableStackFactory {
    @Override
    public <T> MutableStack<T> empty() {
        return ArrayStack.newStack();
    }

    @Override
    public <T> MutableStack<T> of() {
        return this.empty();
    }

    @Override
    public <T> MutableStack<T> with() {
        return this.empty();
    }

    @Override
    public <T> MutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    @Override
    public <T> MutableStack<T> with(T ... elements) {
        return ArrayStack.newStackWith(elements);
    }

    @Override
    public <T> MutableStack<T> ofAll(Iterable<? extends T> elements) {
        return this.withAll(elements);
    }

    @Override
    public <T> MutableStack<T> withAll(Iterable<? extends T> elements) {
        return ArrayStack.newStack(elements);
    }

    @Override
    public <T> MutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    @Override
    public <T> MutableStack<T> withReversed(T ... elements) {
        return ArrayStack.newStackFromTopToBottom(elements);
    }

    @Override
    public <T> MutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    @Override
    public <T> MutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ArrayStack.newStackFromTopToBottom(items);
    }
}

