/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable;

import java.util.List;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.list.immutable.ImmutableArrayList;
import org.eclipse.collections.impl.list.immutable.ImmutableDecapletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableDoubletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableEmptyList;
import org.eclipse.collections.impl.list.immutable.ImmutableNonupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableOctupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableQuadrupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableQuintupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableSeptupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableSextupletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableSingletonList;
import org.eclipse.collections.impl.list.immutable.ImmutableTripletonList;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public final class ImmutableListFactoryImpl
implements ImmutableListFactory {
    @Override
    public <T> ImmutableList<T> empty() {
        return ImmutableEmptyList.INSTANCE;
    }

    @Override
    public <T> ImmutableList<T> of() {
        return this.empty();
    }

    @Override
    public <T> ImmutableList<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableList<T> of(T one) {
        return this.with(one);
    }

    @Override
    public <T> ImmutableList<T> with(T one) {
        return new ImmutableSingletonList<T>(one);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two) {
        return this.with(one, two);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two) {
        return new ImmutableDoubletonList<T>(one, two);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three) {
        return new ImmutableTripletonList<T>(one, two, three);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four) {
        return new ImmutableQuadrupletonList<T>(one, two, three, four);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five) {
        return this.with(one, two, three, four, five);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five) {
        return new ImmutableQuintupletonList<T>(one, two, three, four, five);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five, T six) {
        return this.with(one, two, three, four, five, six);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five, T six) {
        return new ImmutableSextupletonList<T>(one, two, three, four, five, six);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five, T six, T seven) {
        return this.with(one, two, three, four, five, six, seven);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five, T six, T seven) {
        return new ImmutableSeptupletonList<T>(one, two, three, four, five, six, seven);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five, T six, T seven, T eight) {
        return this.with(one, two, three, four, five, six, seven, eight);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five, T six, T seven, T eight) {
        return new ImmutableOctupletonList<T>(one, two, three, four, five, six, seven, eight);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five, T six, T seven, T eight, T nine) {
        return this.with(one, two, three, four, five, six, seven, eight, nine);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five, T six, T seven, T eight, T nine) {
        return new ImmutableNonupletonList<T>(one, two, three, four, five, six, seven, eight, nine);
    }

    @Override
    public <T> ImmutableList<T> of(T one, T two, T three, T four, T five, T six, T seven, T eight, T nine, T ten) {
        return this.with(one, two, three, four, five, six, seven, eight, nine, ten);
    }

    @Override
    public <T> ImmutableList<T> with(T one, T two, T three, T four, T five, T six, T seven, T eight, T nine, T ten) {
        return new ImmutableDecapletonList<T>(one, two, three, four, five, six, seven, eight, nine, ten);
    }

    @Override
    public <T> ImmutableList<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> ImmutableList<T> with(T ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        switch (items.length) {
            case 1: {
                return this.of(items[0]);
            }
            case 2: {
                return this.of(items[0], items[1]);
            }
            case 3: {
                return this.of(items[0], items[1], items[2]);
            }
            case 4: {
                return this.of(items[0], items[1], items[2], items[3]);
            }
            case 5: {
                return this.of(items[0], items[1], items[2], items[3], items[4]);
            }
            case 6: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5]);
            }
            case 7: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5], items[6]);
            }
            case 8: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5], items[6], items[7]);
            }
            case 9: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5], items[6], items[7], items[8]);
            }
            case 10: {
                return this.of(items[0], items[1], items[2], items[3], items[4], items[5], items[6], items[7], items[8], items[9]);
            }
        }
        return ImmutableArrayList.newListWith(items);
    }

    private <T> ImmutableList<T> withList(List<T> items) {
        switch (items.size()) {
            case 0: {
                return this.empty();
            }
            case 1: {
                return this.of(items.get(0));
            }
            case 2: {
                return this.of(items.get(0), items.get(1));
            }
            case 3: {
                return this.of(items.get(0), items.get(1), items.get(2));
            }
            case 4: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3));
            }
            case 5: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4));
            }
            case 6: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4), items.get(5));
            }
            case 7: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4), items.get(5), items.get(6));
            }
            case 8: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4), items.get(5), items.get(6), items.get(7));
            }
            case 9: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4), items.get(5), items.get(6), items.get(7), items.get(8));
            }
            case 10: {
                return this.of(items.get(0), items.get(1), items.get(2), items.get(3), items.get(4), items.get(5), items.get(6), items.get(7), items.get(8), items.get(9));
            }
        }
        return ImmutableArrayList.newListWith(items.toArray());
    }

    @Override
    public <T> ImmutableList<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableList<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableList) {
            return (ImmutableList)items;
        }
        if (items instanceof List && items instanceof RandomAccess) {
            return this.withList((List)items);
        }
        if (Iterate.isEmpty(items)) {
            return this.empty();
        }
        return this.of(Iterate.toArray(items));
    }
}

