/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.statistics.model;

import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.eclipse.chemclipse.numeric.statistics.model.IUnivariateStatistics;

public class UnivariateStatistics
implements IUnivariateStatistics {
    private final int sampleSize;
    private final double[] abundances;
    private final Mean mean;
    private final Variance variance;
    private final StandardDeviation sd;
    private final Percentile percentile;

    public UnivariateStatistics(int sampleSize, double[] abundances, Mean mean, Variance variance, StandardDeviation sd, Percentile percentile) {
        this.sampleSize = sampleSize;
        this.abundances = abundances;
        this.mean = mean;
        this.variance = variance;
        this.sd = sd;
        this.percentile = percentile;
    }

    public UnivariateStatistics(double[] abundances) {
        this(abundances.length, abundances, new Mean(), new Variance(), new StandardDeviation(), new Percentile());
        this.mean.setData(abundances);
        this.variance.setData(abundances);
        this.sd.setData(abundances);
        this.percentile.setData(abundances);
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public double getMean() {
        return this.mean.evaluate();
    }

    @Override
    public double getVariance() {
        return this.variance.evaluate();
    }

    @Override
    public double getStandardDeviation() {
        return this.sd.evaluate();
    }

    @Override
    public double[] getValues() {
        return this.abundances;
    }

    @Override
    public double getMedian() {
        this.percentile.setQuantile(50.0);
        return this.percentile.evaluate();
    }

    @Override
    public double getRelativeStandardDeviation() {
        double std = this.sd.evaluate();
        double m = this.mean.evaluate();
        return std / m;
    }
}

