/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.notifier.IChromatogramSelectionUpdateNotifier;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.swt.ui.components.AbstractLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ChromatogramRange;
import org.eclipse.chemclipse.swt.ui.series.IChromatogramRange;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Range;

public abstract class AbstractChromatogramLineSeriesUI
extends AbstractLineSeriesUI
implements IChromatogramSelectionUpdateNotifier {
    private double yMaxIntensityAdjusted = 0.0;
    private IChromatogramSelection chromatogramSelection = null;
    private IChromatogramRange previousChromatogramRange = new ChromatogramRange();
    private List<IChromatogramSelection> chromatogramSelections;
    private int xStart;
    private int yStart;

    public AbstractChromatogramLineSeriesUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public void updateSelection(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        this.yMaxIntensityAdjusted = this.chromatogramSelection.getStopAbundance();
        this.setYMaxIntensityAdjusted(this.yMaxIntensityAdjusted);
        if (!this.isMaster() || this.isMaster() && forceReload) {
            double maxSignal = this.chromatogramSelection.getChromatogram().getMaxSignal();
            this.setMaxSignal(maxSignal);
            if (!this.isMaster()) {
                if (PreferenceSupplier.autoAdjustViewIntensityDisplay()) {
                    this.enableCompress(true);
                    this.setAutoAdjustIntensity(true);
                } else {
                    this.enableCompress(false);
                    this.setAutoAdjustIntensity(false);
                }
            }
            this.setSeries(forceReload);
            if (!this.isMaster() && !PreferenceSupplier.autoAdjustViewIntensityDisplay()) {
                Range range = this.getYAxisLeft().getRange();
                range.upper = this.yMaxIntensityAdjusted;
                this.getYAxisLeft().setRange(range);
                this.setSecondaryRanges();
            }
        }
    }

    public void updateSelection(List<IChromatogramSelection> chromatogramSelections, boolean forceReload) {
        if (chromatogramSelections != null && chromatogramSelections.size() >= 1) {
            this.chromatogramSelections = chromatogramSelections;
            this.updateSelection(chromatogramSelections.get(0), forceReload);
        }
    }

    public IChromatogramSelection getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public List<IChromatogramSelection> getChromatogramSelections() {
        return this.chromatogramSelections;
    }

    public void mouseScrolled(MouseEvent e) {
        super.mouseScrolled(e);
        this.adjustChromatogramSelection();
    }

    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        int keyCode = e.keyCode;
        if (keyCode == 0x1000003 || keyCode == 0x1000002 || keyCode == 0x1000001 || keyCode == 0x1000004) {
            this.adjustChromatogramSelection();
        }
    }

    @Override
    public void redrawXAxisBottomScale() {
        Range range = this.getXAxisTop().getRange();
        double min = range.lower / 60000.0;
        double max = range.upper / 60000.0;
        ChartUtil.setRange(this.getXAxisBottom(), min, max);
    }

    public void mouseDown(MouseEvent e) {
        super.mouseDown(e);
        this.xStart = e.x;
        this.yStart = e.y;
    }

    public void mouseUp(MouseEvent e) {
        super.mouseUp(e);
        if (this.isMaster() && e.button == 1 && (this.xStart != e.x || this.yStart != e.y)) {
            this.adjustChromatogramSelection();
        }
    }

    public void adjustRange() {
        if (this.isMaster()) {
            if (this.chromatogramSelection != null) {
                this.previousChromatogramRange.reset();
                this.chromatogramSelection.reset();
                this.chromatogramSelection.update(true);
            }
        } else {
            super.adjustRange();
        }
    }

    public void adjustXRange() {
        if (this.isMaster()) {
            if (this.chromatogramSelection != null) {
                IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
                int startRetentionTime = chromatogram.getStartRetentionTime();
                int stopRetentionTime = chromatogram.getStopRetentionTime();
                this.previousChromatogramRange.setStartRetentionTime(startRetentionTime);
                this.previousChromatogramRange.setStopRetentionTime(stopRetentionTime);
                this.chromatogramSelection.setRanges(startRetentionTime, stopRetentionTime, this.chromatogramSelection.getStartAbundance(), this.chromatogramSelection.getStopAbundance());
                this.chromatogramSelection.update(true);
            }
        } else {
            super.adjustXRange();
        }
    }

    public void adjustYRange() {
        if (this.isMaster()) {
            if (this.chromatogramSelection != null) {
                IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
                float minSignal = chromatogram.getMinSignal();
                float maxSignal = chromatogram.getMaxSignal();
                this.previousChromatogramRange.setStartAbundance(minSignal);
                this.previousChromatogramRange.setStopAbundance(maxSignal);
                this.chromatogramSelection.setRanges(this.chromatogramSelection.getStartRetentionTime(), this.chromatogramSelection.getStopRetentionTime(), minSignal, maxSignal);
                this.chromatogramSelection.update(true);
            }
        } else {
            super.adjustYRange();
        }
    }

    public void adjustPreviousRange() {
        if (this.isMaster()) {
            if (this.chromatogramSelection != null && this.previousChromatogramRange.isValid()) {
                int startRetentionTime = this.previousChromatogramRange.getStartRetentionTime();
                int stopRetentionTime = this.previousChromatogramRange.getStopRetentionTime();
                float startAbundance = this.previousChromatogramRange.getStartAbundance();
                float stopAbundance = this.previousChromatogramRange.getStopAbundance();
                this.chromatogramSelection.setRanges(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                this.chromatogramSelection.update(true);
            }
        } else {
            super.adjustYRange();
        }
    }

    protected void adjustChromatogramSelection() {
        if (this.isMaster() && this.chromatogramSelection != null) {
            this.previousChromatogramRange.setStartRetentionTime(this.chromatogramSelection.getStartRetentionTime());
            this.previousChromatogramRange.setStopRetentionTime(this.chromatogramSelection.getStopRetentionTime());
            this.previousChromatogramRange.setStartAbundance(this.chromatogramSelection.getStartAbundance());
            this.previousChromatogramRange.setStopAbundance(this.chromatogramSelection.getStopAbundance());
            int startRetentionTime = (int)this.getXAxisTop().getRange().lower;
            int stopRetentionTime = (int)this.getXAxisTop().getRange().upper;
            float startAbundance = (float)this.getYAxisLeft().getRange().lower;
            float stopAbundance = PreferenceSupplier.autoAdjustEditorIntensityDisplay() ? (float)this.getMultipleSeries().getYMax() : (float)this.getYAxisLeft().getRange().upper;
            this.chromatogramSelection.setRanges(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
        }
    }

    protected int getSelectedRetentionTimeAsMilliseconds(int x) {
        int retentionTimeInMilliseconds;
        int startRetentionTime = (int)this.getXAxisTop().getRange().lower;
        int stopRetentionTime = (int)this.getXAxisTop().getRange().upper;
        int width = this.getPlotArea().getClientArea().width;
        if (x <= 0) {
            retentionTimeInMilliseconds = startRetentionTime;
        } else if (x > width) {
            retentionTimeInMilliseconds = stopRetentionTime;
        } else {
            int delta = stopRetentionTime - startRetentionTime;
            double percentage = 100.0 / (double)width * (double)x / 100.0;
            retentionTimeInMilliseconds = (int)((double)startRetentionTime + (double)delta * percentage);
        }
        return retentionTimeInMilliseconds;
    }

    protected double getSelectedAbundance(int y) {
        double abundanceValue;
        float startAbundance = (float)this.getYAxisLeft().getRange().lower;
        float stopAbundance = (float)this.getYAxisLeft().getRange().upper;
        int height = this.getPlotArea().getClientArea().height;
        if (y <= 0) {
            abundanceValue = stopAbundance;
        } else if (y > height) {
            abundanceValue = startAbundance;
        } else {
            float delta = stopAbundance - startAbundance;
            double percentage = (100.0 - 100.0 / (double)height * (double)y) / 100.0;
            abundanceValue = (double)startAbundance + (double)delta * percentage;
        }
        return abundanceValue;
    }

    protected void handleArrowMoveWindowSelection(int keyCode) {
        if (keyCode == 0x1000004 || keyCode == 0x1000003) {
            if (keyCode == 0x1000004) {
                MoveDirection moveDirection = PreferenceSupplier.useAlternateWindowMoveDirection() ? MoveDirection.LEFT : MoveDirection.RIGHT;
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)this.chromatogramSelection, (MoveDirection)moveDirection, (int)20);
            } else {
                MoveDirection moveDirection = PreferenceSupplier.useAlternateWindowMoveDirection() ? MoveDirection.RIGHT : MoveDirection.LEFT;
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)this.chromatogramSelection, (MoveDirection)moveDirection, (int)20);
            }
            this.chromatogramSelection.update(true);
        } else if (keyCode == 0x1000001 || keyCode == 0x1000002) {
            float stopAbundance = this.chromatogramSelection.getStopAbundance();
            float newStopAbundance = PreferenceSupplier.useAlternateWindowMoveDirection() ? (keyCode == 0x1000001 ? stopAbundance - stopAbundance / 20.0f : stopAbundance + stopAbundance / 20.0f) : (keyCode == 0x1000001 ? stopAbundance + stopAbundance / 20.0f : stopAbundance - stopAbundance / 20.0f);
            this.chromatogramSelection.setRanges(this.chromatogramSelection.getStartRetentionTime(), this.chromatogramSelection.getStopRetentionTime(), this.chromatogramSelection.getStartAbundance(), newStopAbundance);
            this.chromatogramSelection.update(true);
        }
    }

    protected void handleControlScanSelection(int keyCode) {
        int scanNumber = this.chromatogramSelection.getSelectedScan().getScanNumber();
        scanNumber = keyCode == 0x1000004 ? ++scanNumber : --scanNumber;
        IScan selectedScan = this.chromatogramSelection.getChromatogram().getScan(scanNumber);
        if (selectedScan != null) {
            int scanRetentionTime = selectedScan.getRetentionTime();
            int startRetentionTime = this.chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = this.chromatogramSelection.getStopRetentionTime();
            if (scanRetentionTime <= startRetentionTime) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)this.chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
            } else if (scanRetentionTime >= stopRetentionTime) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)this.chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
            }
            this.chromatogramSelection.setSelectedScan(selectedScan, false);
            this.chromatogramSelection.update(true);
        }
    }

    protected void handleMouseWheelSelection(MouseEvent e) {
        int direction = e.count < 0 ? 128 : 1024;
        int startRetentionTime = this.chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = this.chromatogramSelection.getStopRetentionTime();
        int retentionTimeMoveWindow = (stopRetentionTime - startRetentionTime) / 20;
        int startRetentionTimeNew = direction == 1024 ? startRetentionTime + retentionTimeMoveWindow : startRetentionTime - retentionTimeMoveWindow;
        int stopRetentionTimeNew = direction == 1024 ? stopRetentionTime - retentionTimeMoveWindow : stopRetentionTime + retentionTimeMoveWindow;
        startRetentionTimeNew = ChromatogramSelectionSupport.getValidatedStartRetentionTime((IChromatogramSelection)this.chromatogramSelection, (int)startRetentionTimeNew);
        stopRetentionTimeNew = ChromatogramSelectionSupport.getValidatedStopRetentionTime((IChromatogramSelection)this.chromatogramSelection, (int)stopRetentionTimeNew);
        this.chromatogramSelection.setRanges(startRetentionTimeNew, stopRetentionTimeNew, this.chromatogramSelection.getStartAbundance(), this.chromatogramSelection.getStopAbundance());
        this.chromatogramSelection.update(true);
    }

    protected void handleScanSelection(int x) {
        int retentionTime = this.getRetentionTime(x);
        int scan = this.chromatogramSelection.getChromatogram().getScanNumber(retentionTime);
        IScan selectedScan = this.chromatogramSelection.getChromatogram().getScan(scan);
        this.chromatogramSelection.setSelectedScan(selectedScan, false);
        this.chromatogramSelection.update(true);
    }

    protected int getRetentionTime(int x) {
        Rectangle rect = this.getPlotArea().getClientArea();
        double lower = this.getAxisSet().getXAxis((int)0).getRange().lower;
        double upper = this.getAxisSet().getXAxis((int)0).getRange().upper;
        double delta = upper - lower + 1.0;
        double part = delta / (double)rect.width * (double)x;
        int retentionTime = (int)(lower + part);
        return retentionTime;
    }

    private void setSecondaryRanges() {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        assert (this.getXAxisBottom() != null) : "The minutes instance must be not null.";
        assert (this.getYAxisRight() != null) : "The relativeAbundance instance must be not null.";
        double min = (double)this.chromatogramSelection.getStartRetentionTime() / 60000.0;
        double max = (double)this.chromatogramSelection.getStopRetentionTime() / 60000.0;
        Range range = new Range(min, max);
        this.getXAxisBottom().setRange(range);
        min = ChartUtil.getRelativeAbundance(this.getMaxSignal(), this.chromatogramSelection.getStartAbundance());
        max = ChartUtil.getRelativeAbundance(this.getMaxSignal(), this.chromatogramSelection.getStopAbundance());
        range = new Range(min, max);
        this.getYAxisRight().setRange(range);
    }

    private void setSeries(boolean forceReload) {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        this.getAxisSet().adjustRange();
        if (this.isMaster() && forceReload) {
            if (PreferenceSupplier.autoAdjustEditorIntensityDisplay()) {
                this.enableCompress(true);
                this.setAutoAdjustIntensity(true);
            } else {
                this.enableCompress(false);
                Range range = this.getYAxisLeft().getRange();
                range.upper = this.yMaxIntensityAdjusted;
                this.getYAxisLeft().setRange(range);
                this.setAutoAdjustIntensity(false);
            }
        }
        this.setSecondaryRanges();
        this.redraw();
    }
}

