/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider;

import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIonTransition;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class IonTransitionLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element, "ionTransition.gif");
        }
        if (columnIndex == 6 && element instanceof IMarkedIonTransition) {
            IMarkedIonTransition markedIonTransition = (IMarkedIonTransition)element;
            if (markedIonTransition.isSelected()) {
                return this.getImage(element, "selected.gif");
            }
            return this.getImage(element, "deselected.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IMarkedIonTransition) {
            IMarkedIonTransition markedIonTransition = (IMarkedIonTransition)element;
            IIonTransition ionTransition = markedIonTransition.getIonTransition();
            switch (columnIndex) {
                case 0: {
                    text = ionTransition.getCompoundName().equals("") ? "not specified" : ionTransition.getCompoundName();
                    break;
                }
                case 1: {
                    text = Integer.valueOf(ionTransition.getQ1Ion()).toString();
                    break;
                }
                case 2: {
                    text = Double.valueOf(ionTransition.getQ1Resolution()).toString();
                    break;
                }
                case 3: {
                    text = Double.valueOf(ionTransition.getQ3Ion()).toString();
                    break;
                }
                case 4: {
                    text = Double.valueOf(ionTransition.getQ3Resolution()).toString();
                    break;
                }
                case 5: {
                    text = Double.valueOf(ionTransition.getCollisionEnergy()).toString();
                    break;
                }
                case 6: {
                    text = "";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element, String key) {
        Image image = ApplicationImageFactory.getInstance().getImage(key, "16x16");
        return image;
    }
}

