/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.AbstractProfileMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ProfileMassSpectrumUI
extends AbstractProfileMassSpectrumUI {
    public ProfileMassSpectrumUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        IChromatogramSelectionMSD chromatogramSelection = this.getChromatogramSelection();
        IVendorMassSpectrum massSpectrum = chromatogramSelection.getSelectedScan();
        if (massSpectrum != null) {
            ISeries series = SeriesConverterMSD.convertNominalMassSpectrum((IScanMSD)massSpectrum, Sign.POSITIVE);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.RED);
        }
    }
}

