/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.Scan;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;

public abstract class AbstractPeakModel
implements IPeakModel {
    private static final long serialVersionUID = -5447031278614316999L;
    private IScan peakMaximum;
    private LinearEquation backgroundEquation;
    private IPeakIntensityValues peakIntensityValues;
    private LinearEquation increasingInflectionPointEquation;
    private LinearEquation decreasingInflectionPointEquation;
    private double gradientAngle;
    private float startBackgroundAbundance;
    private float stopBackgroundAbundance;
    private Map<String, Object> temporarilyInfo;

    public AbstractPeakModel(IScan peakMaximum, IPeakIntensityValues peakIntensityValues, float startBackgroundAbundance, float stopBackgroundAbundance) throws IllegalArgumentException, PeakException {
        this.peakMaximum = peakMaximum;
        this.peakIntensityValues = peakIntensityValues;
        this.startBackgroundAbundance = startBackgroundAbundance;
        this.stopBackgroundAbundance = stopBackgroundAbundance;
        this.calculatePeakModel();
        this.temporarilyInfo = new HashMap<String, Object>();
    }

    @Override
    public float getBackgroundAbundance() {
        Map.Entry<Integer, Float> entry = this.peakIntensityValues.getHighestIntensityValue();
        if (entry != null) {
            return (float)this.backgroundEquation.calculateY((double)entry.getKey().intValue());
        }
        return 0.0f;
    }

    @Override
    public float getBackgroundAbundance(int retentionTime) {
        if (retentionTime >= this.getStartRetentionTime() && retentionTime <= this.getStopRetentionTime()) {
            return (float)this.backgroundEquation.calculateY((double)retentionTime);
        }
        return 0.0f;
    }

    @Override
    public float getPeakAbundanceByInflectionPoints() {
        float abundance = 0.0f;
        try {
            IPoint intersection = Equations.calculateIntersection((LinearEquation)this.increasingInflectionPointEquation, (LinearEquation)this.decreasingInflectionPointEquation);
            abundance = (float)intersection.getY();
        }
        catch (SolverException solverException) {}
        return abundance;
    }

    @Override
    public float getPeakAbundance() {
        return this.peakMaximum.getTotalSignal();
    }

    @Override
    public float getPeakAbundance(int retentionTime) {
        Map.Entry<Integer, Float> entry;
        if (retentionTime >= this.getStartRetentionTime() && retentionTime <= this.getStopRetentionTime() && (entry = this.peakIntensityValues.getIntensityValue(retentionTime)) != null) {
            return (float)((double)(this.peakMaximum.getTotalSignal() * entry.getValue().floatValue()) / 100.0);
        }
        return 0.0f;
    }

    @Override
    public int getStartRetentionTime() {
        return this.peakIntensityValues.getStartRetentionTime();
    }

    @Override
    public int getStopRetentionTime() {
        return this.peakIntensityValues.getStopRetentionTime();
    }

    @Override
    public int getRetentionTimeAtPeakMaximum() {
        return this.peakIntensityValues.getHighestIntensityValue().getKey();
    }

    @Override
    public int getRetentionTimeAtPeakMaximumByInflectionPoints() {
        int x = 0;
        try {
            IPoint intersection = Equations.calculateIntersection((LinearEquation)this.increasingInflectionPointEquation, (LinearEquation)this.decreasingInflectionPointEquation);
            x = (int)intersection.getX();
        }
        catch (SolverException solverException) {}
        return x;
    }

    @Override
    public void replaceRetentionTimes(List<Integer> retentionTimes) throws IllegalArgumentException, PeakException {
        this.peakIntensityValues.replaceRetentionTimes(retentionTimes);
        this.calculatePeakModel();
    }

    @Override
    public int getNumberOfScans() {
        return this.peakIntensityValues.size();
    }

    @Override
    public int getWidthBaselineTotal() {
        return this.getStopRetentionTime() - this.getStartRetentionTime() + 1;
    }

    @Override
    public int getWidthBaselineByInflectionPoints() {
        LinearEquation base = new LinearEquation(0.0, 0.0);
        int width = 0;
        try {
            IPoint p1 = Equations.calculateIntersection((LinearEquation)this.increasingInflectionPointEquation, (LinearEquation)base);
            IPoint p2 = Equations.calculateIntersection((LinearEquation)this.decreasingInflectionPointEquation, (LinearEquation)base);
            width = (int)(p2.getX() - p1.getX() + 1.0);
        }
        catch (SolverException solverException) {}
        return width;
    }

    @Override
    public int getWidthByInflectionPoints() {
        return this.getWidthByInflectionPoints(0.5f);
    }

    @Override
    public int getWidthByInflectionPoints(float height) {
        int width = 0;
        LinearEquation percentageHeightBaseline = this.getPercentageHeightBaselineEquation(height);
        if (percentageHeightBaseline == null) {
            return 0;
        }
        try {
            IPoint p1 = Equations.calculateIntersection((LinearEquation)this.increasingInflectionPointEquation, (LinearEquation)percentageHeightBaseline);
            IPoint p2 = Equations.calculateIntersection((LinearEquation)this.decreasingInflectionPointEquation, (LinearEquation)percentageHeightBaseline);
            width = (int)(p2.getX() - p1.getX() + 1.0);
        }
        catch (SolverException solverException) {}
        return width;
    }

    @Override
    public float getIncreasingInflectionPointAbundance(int retentionTime) {
        return (float)this.increasingInflectionPointEquation.calculateY((double)retentionTime);
    }

    @Override
    public float getDecreasingInflectionPointAbundance(int retentionTime) {
        return (float)this.decreasingInflectionPointEquation.calculateY((double)retentionTime);
    }

    @Override
    public double getGradientAngle() {
        return this.gradientAngle;
    }

    @Override
    public float getLeading() {
        float leading = 0.0f;
        float tailing = this.getTailing();
        if (tailing != 0.0f) {
            leading = 1.0f / tailing;
        }
        return leading;
    }

    @Override
    public float getTailing() {
        float tailing = 0.0f;
        LinearEquation percentageHeightBaseline = this.getPercentageHeightBaselineEquation(0.1f);
        if (percentageHeightBaseline == null) {
            return 0.0f;
        }
        try {
            IPoint p1 = Equations.calculateIntersection((LinearEquation)this.increasingInflectionPointEquation, (LinearEquation)percentageHeightBaseline);
            IPoint p2 = Equations.calculateIntersection((LinearEquation)this.decreasingInflectionPointEquation, (LinearEquation)percentageHeightBaseline);
            int retentionTimeMax = this.getRetentionTimeAtPeakMaximumByInflectionPoints();
            float leftWidth = retentionTimeMax - (int)p1.getX();
            float rightWidth = (int)p2.getX() - retentionTimeMax;
            tailing = rightWidth / leftWidth;
        }
        catch (SolverException solverException) {}
        return tailing;
    }

    @Override
    public List<Integer> getRetentionTimes() {
        return this.peakIntensityValues.getRetentionTimes();
    }

    @Override
    public LinearEquation getIncreasingInflectionPointEquation() {
        return this.increasingInflectionPointEquation;
    }

    @Override
    public LinearEquation getDecreasingInflectionPointEquation() {
        return this.decreasingInflectionPointEquation;
    }

    @Override
    public LinearEquation getPercentageHeightBaselineEquation(float height) {
        if (height < 0.0f || height > 1.0f) {
            return null;
        }
        float abundance = this.getPeakAbundanceByInflectionPoints();
        float percentageHeight = abundance * height;
        LinearEquation percentageHeightBaseline = new LinearEquation(0.0, (double)percentageHeight);
        return percentageHeightBaseline;
    }

    @Override
    public IScan getPeakMaximum() {
        return this.peakMaximum;
    }

    @Override
    public IScan getPeakScan(int retentionTime) {
        Map.Entry<Integer, Float> entry;
        if (retentionTime >= this.getStartRetentionTime() && retentionTime <= this.getStopRetentionTime() && (entry = this.peakIntensityValues.getIntensityValue(retentionTime)) != null) {
            float intensity = entry.getValue().floatValue();
            Scan scan = new Scan(intensity);
            return scan;
        }
        return null;
    }

    @Override
    public float getIntensity(int retentionTime) {
        float intensity = 0.0f;
        Map.Entry<Integer, Float> entry = this.peakIntensityValues.getIntensityValue(retentionTime);
        if (entry != null) {
            intensity = entry.getValue().floatValue();
        }
        return intensity;
    }

    private void checkModelConditions(IScan peakMaximum, IPeakIntensityValues peakIntensityValues) throws IllegalArgumentException, PeakException {
        if (peakMaximum == null) {
            throw new IllegalArgumentException("The peak maximum must not be null.");
        }
        if (peakIntensityValues == null || peakIntensityValues.size() < 3) {
            throw new IllegalArgumentException("The intensity values must not be null or must contain at least 3 key value pairs.");
        }
        Map.Entry<Integer, Float> entry = peakIntensityValues.getHighestIntensityValue();
        if (entry == null) {
            throw new PeakException("There must be at least one intensity value stored with a relative intensity of IPeakIntensityValues.MAX_INTENSITY.");
        }
        peakMaximum.setRetentionTime(peakIntensityValues.getHighestIntensityValue().getKey());
        this.peakMaximum = peakMaximum;
        this.peakIntensityValues = peakIntensityValues;
    }

    private LinearEquation calculateBackgroundEquation(float startBackgroundAbundance, float stopBackgroundAbundance) {
        if (startBackgroundAbundance < 0.0f) {
            startBackgroundAbundance = 0.0f;
        }
        if (stopBackgroundAbundance < 0.0f) {
            stopBackgroundAbundance = 0.0f;
        }
        int startRetentionTime = this.peakIntensityValues.getStartRetentionTime();
        int stopRetentionTime = this.peakIntensityValues.getStopRetentionTime();
        Point p1 = new Point((double)startRetentionTime, (double)startBackgroundAbundance);
        Point p2 = new Point((double)stopRetentionTime, (double)stopBackgroundAbundance);
        return Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
    }

    private double calculateGradientAngle() {
        double a = 0.0;
        int b = this.getWidthBaselineTotal();
        float start = this.getBackgroundAbundance(this.peakIntensityValues.getStartRetentionTime());
        float stop = this.getBackgroundAbundance(this.peakIntensityValues.getStopRetentionTime());
        if (stop == start || b == 0) {
            return 0.0;
        }
        a = stop - start;
        return Math.toDegrees(Math.atan(a / (double)b));
    }

    @Override
    public Object getTemporarilyInfo(String key) {
        return this.temporarilyInfo.get(key);
    }

    @Override
    public void setTemporarilyInfo(String key, Object value) {
        this.temporarilyInfo.put(key, value);
    }

    private void calculatePeakModel() throws IllegalArgumentException, PeakException {
        this.checkModelConditions(this.peakMaximum, this.peakIntensityValues);
        this.backgroundEquation = this.calculateBackgroundEquation(this.startBackgroundAbundance, this.stopBackgroundAbundance);
        this.gradientAngle = this.calculateGradientAngle();
        this.increasingInflectionPointEquation = this.peakIntensityValues.calculateIncreasingInflectionPointEquation(this.peakMaximum.getTotalSignal());
        this.decreasingInflectionPointEquation = this.peakIntensityValues.calculateDecreasingInflectionPointEquation(this.peakMaximum.getTotalSignal());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractPeakModel other = (AbstractPeakModel)otherObject;
        return this.getPeakMaximum().equals(other.getPeakMaximum()) && this.gradientAngle == other.getGradientAngle() && this.increasingInflectionPointEquation.equals((Object)other.getIncreasingInflectionPointEquation()) && this.decreasingInflectionPointEquation.equals((Object)other.getDecreasingInflectionPointEquation());
    }

    public int hashCode() {
        return 7 * this.peakMaximum.hashCode() + 11 * Double.valueOf(this.gradientAngle).hashCode() + 13 * this.increasingInflectionPointEquation.hashCode() + 15 * this.decreasingInflectionPointEquation.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("peakMaximum=" + this.peakMaximum);
        builder.append(",");
        builder.append("gradientAngle=" + this.gradientAngle);
        builder.append(",");
        builder.append("increasingInflectionPointEquation=" + this.increasingInflectionPointEquation);
        builder.append(",");
        builder.append("decreasingInflectionPointEquation=" + this.decreasingInflectionPointEquation);
        builder.append("]");
        return builder.toString();
    }
}

