/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.BaselineModel;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramResult;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.implementation.TripleQuadMethod;
import org.eclipse.chemclipse.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.updates.IChromatogramUpdateListener;
import org.eclipse.chemclipse.model.versioning.IVersionManagement;
import org.eclipse.chemclipse.model.versioning.VersionManagement;
import org.eclipse.chemclipse.support.history.EditHistory;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.support.preferences.SupportPreferences;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public abstract class AbstractChromatogram
implements IChromatogram {
    private static final Logger logger = Logger.getLogger(AbstractChromatogram.class);
    private String converterId = "";
    private File file = null;
    private int scanDelay = 4500;
    private int scanInterval = 1000;
    private boolean unloaded = false;
    private List<IChromatogramUpdateListener> updateSupport;
    private IVersionManagement versionManagement;
    private IEditHistory editHistory;
    private IBaselineModel baselineModel = null;
    private List<IScan> scans;
    private Map<String, IChromatogramResult> chromatogramResults;
    private String operator = "";
    private Date date = new Date();
    private String miscInfo = "";
    private String miscInfoSeparated = "";
    private String shortInfo = "";
    private String detailedInfo = "";
    private String sampleGroup = "";
    private String barcode = "";
    private String barcodeType = "";
    private double sampleWeight = 0.0;
    private String weightUnit = "";
    private String dataName = "";
    private List<IChromatogram> referencedChromatograms;
    private String chromatogramIntegratorDescription = "";
    private List<IIntegrationEntry> chromatogramIntegrationEntries;
    private String backgroundIntegratorDescription = "";
    private List<IIntegrationEntry> backgroundIntegrationEntries;
    private IMethod method;

    public AbstractChromatogram() {
        this.updateSupport = new ArrayList<IChromatogramUpdateListener>(5);
        this.versionManagement = new VersionManagement();
        this.editHistory = new EditHistory();
        this.baselineModel = new BaselineModel(this);
        this.scans = new ArrayList<IScan>();
        this.chromatogramResults = new HashMap<String, IChromatogramResult>();
        this.referencedChromatograms = new ArrayList<IChromatogram>();
        this.chromatogramIntegrationEntries = new ArrayList<IIntegrationEntry>();
        this.backgroundIntegrationEntries = new ArrayList<IIntegrationEntry>();
        this.method = new TripleQuadMethod();
    }

    @Override
    public void recalculateTheNoiseFactor() {
    }

    @Override
    public float getSignalToNoiseRatio(float abundance) {
        return 0.0f;
    }

    @Override
    public String getConverterId() {
        return this.converterId;
    }

    @Override
    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    @Override
    public int getScanDelay() {
        return this.scanDelay;
    }

    @Override
    public void setScanDelay(int milliseconds) {
        if (this.scanDelay >= 0 && this.scanDelay <= 216000000) {
            this.scanDelay = milliseconds;
        }
    }

    @Override
    public int getScanInterval() {
        return this.scanInterval;
    }

    @Override
    public void setScanInterval(int milliseconds) {
        if (milliseconds >= 1 && milliseconds <= 3600000) {
            this.scanInterval = milliseconds;
        }
    }

    @Override
    public void setScanInterval(float scansPerSecond) {
        if (scansPerSecond >= 0.1f && scansPerSecond <= 20.0f) {
            int milliseconds = Math.round(1000.0f / scansPerSecond);
            this.setScanInterval(milliseconds);
        }
    }

    @Override
    public String getIdentifier() {
        return this.versionManagement.getChromatogramIdentifier();
    }

    @Override
    public File getStorageDirectory() {
        return this.versionManagement.getStorageDirectory();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "Chromatogram";
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public Date getDate() {
        return new Date(this.date.getTime());
    }

    @Override
    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    @Override
    public String getMiscInfo() {
        return this.miscInfo;
    }

    @Override
    public void setMiscInfo(String miscInfo) {
        if (miscInfo != null) {
            String[] values = miscInfo.split(PreferenceSupplier.getMiscSeparator());
            if (values.length >= 2) {
                this.miscInfo = values[0];
                StringBuilder builder = new StringBuilder();
                int i = 1;
                while (i < values.length) {
                    builder.append(values[i].trim());
                    builder.append(PreferenceSupplier.getMiscSeparatedDelimiter());
                    ++i;
                }
                this.miscInfoSeparated = builder.toString().trim();
            } else {
                this.miscInfo = miscInfo;
            }
        } else {
            this.miscInfo = "";
            this.miscInfoSeparated = "";
        }
    }

    @Override
    public String getMiscInfoSeparated() {
        return this.miscInfoSeparated;
    }

    @Override
    public void setMiscInfoSeparated(String miscInfoSeparated) {
        this.miscInfoSeparated = miscInfoSeparated;
    }

    @Override
    public float getMinSignal() {
        float minSignal = Float.MAX_VALUE;
        float actSignal = 0.0f;
        if (this.getNumberOfScans() < 1) {
            return 0.0f;
        }
        for (IScan scan : this.scans) {
            actSignal = scan.getTotalSignal();
            float f = minSignal = minSignal > actSignal ? actSignal : minSignal;
        }
        return minSignal;
    }

    @Override
    public float getMaxSignal() {
        return this.getMaxSignal(this.containsScanCycles());
    }

    @Override
    public float getMaxSignal(boolean condenseCycleNumberScans) {
        float maxSignal = 0.0f;
        if (this.getNumberOfScans() >= 1) {
            try {
                TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(this);
                ITotalScanSignals signals = totalIonSignalExtractor.getTotalScanSignals(this, true, condenseCycleNumberScans);
                maxSignal = signals.getMaxSignal();
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return maxSignal;
    }

    @Override
    public int getStartRetentionTime() {
        int lastScan = this.getNumberOfScans();
        if (lastScan == 0) {
            return 0;
        }
        return this.getScan(1).getRetentionTime();
    }

    @Override
    public int getStopRetentionTime() {
        int lastScan = this.getNumberOfScans();
        if (lastScan == 0) {
            return 0;
        }
        return this.getScan(lastScan).getRetentionTime();
    }

    @Override
    public int getNumberOfScans() {
        return this.scans.size();
    }

    @Override
    public int getScanNumber(float retentionTime) {
        int milliseconds = (int)(retentionTime * 1000.0f * 60.0f);
        return this.getScanNumber(milliseconds);
    }

    @Override
    public int getScanNumber(int retentionTime) {
        if (retentionTime < this.getStartRetentionTime() || retentionTime > this.getStopRetentionTime()) {
            return 0;
        }
        int scanInterval = this.getScanInterval();
        if (scanInterval == 0) {
            return 0;
        }
        if (retentionTime == this.getStopRetentionTime()) {
            return this.getNumberOfScans();
        }
        int scan = 1;
        while (scan <= this.getNumberOfScans()) {
            if (this.getScan(scan).getRetentionTime() > retentionTime) {
                return --scan;
            }
            ++scan;
        }
        return 0;
    }

    @Override
    public float getTotalSignal() {
        float totalSignal = 0.0f;
        if (this.getNumberOfScans() < 1) {
            return 0.0f;
        }
        for (IScan scan : this.scans) {
            totalSignal += scan.getTotalSignal();
        }
        return totalSignal;
    }

    @Override
    public void recalculateScanNumbers() {
        int scanNumber = 1;
        for (IScan scan : this.scans) {
            scan.setScanNumber(scanNumber);
            ++scanNumber;
        }
    }

    @Override
    public void recalculateRetentionTimes() {
        int actual = this.getScanDelay();
        for (IScan scan : this.scans) {
            scan.setRetentionTime(actual);
            actual += this.getScanInterval();
        }
        this.fireUpdateChange(true);
    }

    @Override
    public void addScan(IScan scan) {
        scan.setParentChromatogram(this);
        int lastScan = this.scans.size();
        scan.setScanNumber(++lastScan);
        this.scans.add(scan);
    }

    @Override
    public IScan getScan(int scan) {
        int position = scan;
        if (position > 0 && position <= this.scans.size()) {
            return this.scans.get(--position);
        }
        return null;
    }

    @Override
    public List<IScan> getScans() {
        return this.scans;
    }

    @Override
    public void removeScan(int scan) {
        int position = scan;
        if (position > 0 && position <= this.scans.size()) {
            this.scans.remove(--position);
        }
    }

    @Override
    public void removeScans(int from, int to) {
        int end;
        int start;
        if (from > to) {
            start = to;
            end = from;
        } else {
            start = from;
            end = to;
        }
        int i = start;
        while (i <= end) {
            this.removeScan(start);
            ++i;
        }
    }

    @Override
    public boolean isUndoable() {
        return SupportPreferences.isUndoable();
    }

    @Override
    public boolean canUndo() {
        boolean result = false;
        if (this.isUndoable() && this.versionManagement.getRevision() > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean canRedo() {
        boolean result = false;
        if (this.isUndoable() && this.versionManagement.getNextScanRevision().exists()) {
            result = true;
        }
        return result;
    }

    @Override
    public void hibernate() {
        if (!this.isUndoable()) {
            return;
        }
        File file = this.versionManagement.getActualScanRevision();
        this.writeSerializedChromatogram(file);
    }

    @Override
    public void wakeUp() {
        if (!this.isUndoable()) {
            return;
        }
        File file = this.versionManagement.getActualScanRevision();
        if (file.exists()) {
            this.readSerializedChromatogram(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeSerializedChromatogram(File file) {
        assert (file != null) : String.valueOf(this.getClass().getName()) + " writeSerializedFile: The file must not be null.";
        ObjectOutputStream outputStream = null;
        try {
            try {
                outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                outputStream.writeObject(this.scans);
                return;
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException e2) {
                    logger.warn((Object)e2);
                }
                return;
            }
            catch (IOException e) {
                logger.warn((Object)e);
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException e3) {
                    logger.warn((Object)e3);
                }
                return;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readSerializedChromatogram(File file) {
        assert (file != null) : String.valueOf(this.getClass().getName()) + " readSerializedFile: The file must not be null.";
        ObjectInputStream inputStream = null;
        try {
            try {
                inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                Object inputObject = inputStream.readObject();
                if (!(inputObject instanceof ArrayList)) return;
                this.scans = null;
                this.scans = (ArrayList)inputObject;
                return;
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e2) {
                    logger.warn((Object)e2);
                }
                return;
            }
            catch (IOException e) {
                logger.warn((Object)e);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e3) {
                    logger.warn((Object)e3);
                }
                return;
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)e);
                if (inputStream == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e4) {
                    logger.warn((Object)e4);
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IVersionManagement getVersionManagement() {
        return this.versionManagement;
    }

    public IEditHistory getEditHistory() {
        return this.editHistory;
    }

    @Override
    public IBaselineModel getBaselineModel() {
        return this.baselineModel;
    }

    @Override
    public void addChromatogramUpdateListener(IChromatogramUpdateListener listener) {
        this.updateSupport.add(listener);
    }

    @Override
    public void removeChromatogramUpdateListener(IChromatogramUpdateListener listener) {
        this.updateSupport.remove(listener);
    }

    protected void fireUpdateChange(final boolean forceReload) {
        this.recalculateTheNoiseFactor();
        for (final IChromatogramUpdateListener listener : this.updateSupport) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    logger.warn((Object)exception);
                }

                public void run() throws Exception {
                    listener.update(forceReload);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    @Override
    public String extractNameFromDirectory(String nameDefault, String directoryExtension) {
        File file = this.getFile();
        if (file == null) {
            return nameDefault;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.getFile().getAbsolutePath(), File.separator);
        int element = tokenizer.countTokens() - 1;
        int i = 1;
        while (i < element) {
            if (tokenizer.hasMoreElements()) {
                tokenizer.nextToken();
            }
            ++i;
        }
        if (tokenizer.hasMoreElements()) {
            nameDefault = tokenizer.nextToken();
        }
        if (nameDefault != null) {
            nameDefault = nameDefault.substring(0, nameDefault.length() - directoryExtension.length());
        }
        return nameDefault;
    }

    @Override
    public String extractNameFromFile(String nameDefault) {
        String fileName;
        File file = this.getFile();
        if (file != null && (fileName = file.getName()) != "" && fileName != null) {
            String[] parts = fileName.split("\\.");
            if (parts.length > 2) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < parts.length - 1) {
                    builder.append(parts[i]);
                    builder.append(".");
                    ++i;
                }
                String name = builder.toString();
                nameDefault = name.substring(0, name.length() - 1);
            } else if (parts.length == 2) {
                nameDefault = parts[0];
            }
        }
        return nameDefault;
    }

    @Override
    public void addChromatogramResult(IChromatogramResult chromatogramResult) {
        if (chromatogramResult != null) {
            this.chromatogramResults.put(chromatogramResult.getIdentifier(), chromatogramResult);
        }
    }

    @Override
    public IChromatogramResult getChromatogramResult(String identifier) {
        return this.chromatogramResults.get(identifier);
    }

    @Override
    public void deleteChromatogramResult(String identifier) {
        this.chromatogramResults.remove(identifier);
    }

    @Override
    public void removeAllChromatogramResults() {
        this.chromatogramResults.clear();
    }

    @Override
    public Collection<IChromatogramResult> getChromatogramResults() {
        return this.chromatogramResults.values();
    }

    @Override
    public String getShortInfo() {
        return this.shortInfo;
    }

    @Override
    public void setShortInfo(String shortInfo) {
        if (shortInfo != null) {
            this.shortInfo = shortInfo;
        }
    }

    @Override
    public String getDetailedInfo() {
        return this.detailedInfo;
    }

    @Override
    public void setDetailedInfo(String detailedInfo) {
        if (detailedInfo != null) {
            this.detailedInfo = detailedInfo;
        }
    }

    @Override
    public String getSampleGroup() {
        return this.sampleGroup;
    }

    @Override
    public void setSampleGroup(String sampleGroup) {
        if (sampleGroup != null) {
            this.sampleGroup = sampleGroup;
        }
    }

    @Override
    public String getBarcode() {
        return this.barcode;
    }

    @Override
    public void setBarcode(String barcode) {
        if (barcode != null) {
            this.barcode = barcode;
        }
    }

    @Override
    public String getBarcodeType() {
        return this.barcodeType;
    }

    @Override
    public void setBarcodeType(String barcodeType) {
        if (barcodeType != null) {
            this.barcodeType = barcodeType;
        }
    }

    @Override
    public double getSampleWeight() {
        return this.sampleWeight;
    }

    @Override
    public void setSampleWeight(double sampleWeight) {
        if (sampleWeight >= 0.0) {
            this.sampleWeight = sampleWeight;
        }
    }

    @Override
    public String getWeightUnit() {
        return this.weightUnit;
    }

    @Override
    public void setWeightUnit(String weightUnit) {
        if (weightUnit != null) {
            this.weightUnit = weightUnit;
        }
    }

    @Override
    public String getDataName() {
        return this.dataName;
    }

    @Override
    public void setDataName(String dataName) {
        if (dataName != null) {
            this.dataName = dataName;
        }
    }

    @Override
    public List<IChromatogram> getReferencedChromatograms() {
        return this.referencedChromatograms;
    }

    @Override
    public void addReferencedChromatogram(IChromatogram chromatogram) {
        this.referencedChromatograms.add(chromatogram);
    }

    @Override
    public void removeReferencedChromatogram(IChromatogram chromatogram) {
        this.referencedChromatograms.remove(chromatogram);
    }

    @Override
    public String getChromatogramIntegratorDescription() {
        return this.chromatogramIntegratorDescription;
    }

    @Override
    public void setChromatogramIntegratorDescription(String chromatogramIntegratorDescription) {
        if (chromatogramIntegratorDescription != null) {
            this.chromatogramIntegratorDescription = chromatogramIntegratorDescription;
        }
    }

    @Override
    public double getChromatogramIntegratedArea() {
        return this.getIntegratedArea(this.chromatogramIntegrationEntries);
    }

    @Override
    public void setChromatogramIntegratedArea(List<IIntegrationEntry> chromatogramIntegrationEntries, String chromatogramIntegratorDescription) {
        if (chromatogramIntegrationEntries != null) {
            this.setChromatogramIntegratorDescription(chromatogramIntegratorDescription);
            this.chromatogramIntegrationEntries = chromatogramIntegrationEntries;
        }
    }

    @Override
    public List<IIntegrationEntry> getChromatogramIntegrationEntries() {
        return this.chromatogramIntegrationEntries;
    }

    @Override
    public String getBackgroundIntegratorDescription() {
        return this.backgroundIntegratorDescription;
    }

    @Override
    public void setBackgroundIntegratorDescription(String backgroundIntegratorDescription) {
        if (backgroundIntegratorDescription != null) {
            this.backgroundIntegratorDescription = backgroundIntegratorDescription;
        }
    }

    @Override
    public double getBackgroundIntegratedArea() {
        return this.getIntegratedArea(this.backgroundIntegrationEntries);
    }

    @Override
    public void setBackgroundIntegratedArea(List<IIntegrationEntry> backgroundIntegrationEntries, String backgroundIntegratorDescription) {
        if (backgroundIntegrationEntries != null) {
            this.setBackgroundIntegratorDescription(backgroundIntegratorDescription);
            this.backgroundIntegrationEntries = backgroundIntegrationEntries;
        }
    }

    @Override
    public List<IIntegrationEntry> getBackgroundIntegrationEntries() {
        return this.backgroundIntegrationEntries;
    }

    private double getIntegratedArea(List<IIntegrationEntry> integrationEntries) {
        double integratedArea = 0.0;
        if (integrationEntries.size() > 0) {
            for (IIntegrationEntry integrationEntry : integrationEntries) {
                integratedArea += integrationEntry.getIntegratedArea();
            }
        }
        return integratedArea;
    }

    @Override
    public void removeAllBackgroundIntegrationEntries() {
        this.backgroundIntegrationEntries.clear();
    }

    @Override
    public void removeAllChromatogramIntegrationEntries() {
        this.chromatogramIntegrationEntries.clear();
    }

    @Override
    public void doOperation(IChromatogramProcessor chromatogramProcessor, IProgressMonitor monitor) {
        boolean isUndoable = this.isUndoable();
        this.doOperation(chromatogramProcessor, isUndoable, true, monitor);
    }

    @Override
    public void doOperation(IChromatogramProcessor chromatogramProcessor, boolean isUndoable, boolean isDataModifying, IProgressMonitor monitor) {
        if (chromatogramProcessor == null) {
            return;
        }
        IChromatogramSelection chromatogramSelection = chromatogramProcessor.getChromatogramSelection();
        if (chromatogramSelection != null && chromatogramSelection.getChromatogram() == this) {
            File file;
            if (isUndoable && this.getVersionManagement().isBaseRevision()) {
                monitor.subTask("Save the actual state.");
                file = this.getVersionManagement().getActualScanRevision();
                this.writeSerializedChromatogram(file);
            }
            if (isDataModifying) {
                this.removeAllPeaks();
                this.removeAllTargets();
                this.removeAllChromatogramResults();
                IBaselineModel baselineModel = this.getBaselineModel();
                if (baselineModel != null) {
                    baselineModel.removeBaseline();
                }
            }
            chromatogramProcessor.execute(monitor);
            if (isUndoable) {
                monitor.subTask("Save the undoable state.");
                this.getVersionManagement().doOperation();
                file = this.getVersionManagement().getActualScanRevision();
                this.writeSerializedChromatogram(file);
            }
            monitor.subTask("Edit the history entries.");
            this.getEditHistory().add((IEditInformation)new EditInformation(chromatogramProcessor.getDescription()));
            chromatogramSelection.getChromatogram().recalculateTheNoiseFactor();
            this.fireUpdate(chromatogramSelection);
        }
    }

    @Override
    public void redoOperation(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection != null && chromatogramSelection.getChromatogram() == this && this.isUndoable()) {
            File file = this.getVersionManagement().getNextScanRevision();
            if (file.exists()) {
                this.readSerializedChromatogram(file);
                this.getVersionManagement().redoOperation();
                this.getEditHistory().add((IEditInformation)new EditInformation("redo operation performed"));
            }
            this.fireUpdate(chromatogramSelection);
        }
    }

    @Override
    public void undoOperation(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection != null && chromatogramSelection.getChromatogram() == this && this.isUndoable()) {
            File file = this.getVersionManagement().getPreviousScanRevision();
            if (file.exists()) {
                this.readSerializedChromatogram(file);
                this.getVersionManagement().undoOperation();
                this.getEditHistory().add((IEditInformation)new EditInformation("undo operation performed"));
            }
            this.fireUpdate(chromatogramSelection);
        }
    }

    @Override
    public void removeAllPeaks() {
    }

    @Override
    public int getNumberOfPeaks() {
        return 0;
    }

    @Override
    public void removeAllTargets() {
    }

    @Override
    public void setUnloaded() {
        this.unloaded = true;
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }

    @Override
    public boolean containsScanCycles() {
        int defaultCycleNumber = 1;
        for (IScan scan : this.scans) {
            if (scan.getCycleNumber() == defaultCycleNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IScan> getScanCycleScans(int scanCycle) {
        ArrayList<IScan> scanCycleScans = new ArrayList<IScan>();
        if (scanCycle > 0) {
            if (this.containsScanCycles()) {
                for (IScan scan : this.scans) {
                    if (scan.getCycleNumber() != scanCycle) continue;
                    scanCycleScans.add(scan);
                }
            } else if (scanCycle == 1) {
                scanCycleScans.addAll(this.scans);
            }
        }
        return scanCycleScans;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        IChromatogram other = (IChromatogram)otherObject;
        return this.getNumberOfScans() == other.getNumberOfScans() && this.getTotalSignal() == other.getTotalSignal() && this.getMinSignal() == other.getMinSignal() && this.getMaxSignal() == other.getMaxSignal() && this.getStartRetentionTime() == other.getStartRetentionTime() && this.getStopRetentionTime() == other.getStopRetentionTime();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.getNumberOfScans()).hashCode() + 9 * Float.valueOf(this.getTotalSignal()).hashCode() + 11 * Float.valueOf(this.getMinSignal()).hashCode() + 9 * Float.valueOf(this.getMaxSignal()).hashCode() + 7 * Integer.valueOf(this.getStartRetentionTime()).hashCode() + 9 * Integer.valueOf(this.getStopRetentionTime()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("numberOfScans=" + this.getNumberOfScans());
        builder.append(",");
        builder.append("totalSignal=" + this.getTotalSignal());
        builder.append(",");
        builder.append("minSignal=" + this.getMinSignal());
        builder.append(",");
        builder.append("maxSignal=" + this.getMaxSignal());
        builder.append(",");
        builder.append("startRetentionTime=" + this.getStartRetentionTime());
        builder.append(",");
        builder.append("stopRetentionTime=" + this.getStopRetentionTime());
        builder.append("]");
        return builder.toString();
    }
}

