/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.SnipCalculator;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonValueComparator;
import org.eclipse.core.runtime.IProgressMonitor;

public class FilterSupplier {
    public void applySnipFilter(List<IScanMSD> massSpectra, int iterations, int transitions, double magnificationFactor, IProgressMonitor monitor) {
        for (IScanMSD massSpectrum : massSpectra) {
            int i = 1;
            while (i <= transitions) {
                this.applySnipTransition(massSpectrum, iterations, magnificationFactor, monitor);
                ++i;
            }
        }
    }

    private void applySnipTransition(IScanMSD massSpectrum, int iterations, double magnificationFactor, IProgressMonitor monitor) {
        int extraValues = 6;
        List ions = massSpectrum.getIons();
        Collections.sort(ions, new IonValueComparator());
        float[] intensityValues = this.getIntensityValues(ions, extraValues);
        SnipCalculator snipCalculator = new SnipCalculator();
        snipCalculator.calculateBaselineIntensityValues(intensityValues, iterations, monitor);
        this.applySnipBaselineToSubtractIons(ions, intensityValues, extraValues, magnificationFactor);
    }

    private float[] getIntensityValues(List<IIon> ions, int extraValues) {
        float[] intensityValues = new float[ions.size() + extraValues * 2];
        int counter = 0;
        int i = 0;
        while (i < extraValues) {
            intensityValues[counter++] = 1.0f;
            ++i;
        }
        for (IIon ion : ions) {
            intensityValues[counter++] = ion.getAbundance();
        }
        i = 0;
        while (i < extraValues) {
            intensityValues[counter++] = 1.0f;
            ++i;
        }
        return intensityValues;
    }

    private void applySnipBaselineToSubtractIons(List<IIon> ions, float[] intensityValues, int extraValues, double magnificationFactor) {
        ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
        int counter = 0;
        int i = 0;
        while (i < extraValues) {
            ++counter;
            ++i;
        }
        for (IIon ion : ions) {
            float baselineIntensity = intensityValues[counter++];
            baselineIntensity = (float)((double)baselineIntensity * magnificationFactor);
            float abundance = ion.getAbundance() - baselineIntensity;
            if (abundance <= 0.0f) {
                ionsToRemove.add(ion);
                continue;
            }
            try {
                ion.setAbundance(abundance);
            }
            catch (AbundanceLimitExceededException abundanceLimitExceededException) {}
        }
        ions.removeAll(ionsToRemove);
    }
}

