/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.BuildFileCreator;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExportUtil {
    private static Comparator<IJavaProject> javaProjectComparator;
    private static Comparator<IFile> fileComparator;
    private static Comparator<IType> typeComparator;
    public static final String NEWLINE;

    static {
        NEWLINE = System.getProperty("line.separator");
    }

    private ExportUtil() {
    }

    public static IResource getResource(ISelection selection) {
        Iterator iter;
        if (selection instanceof IStructuredSelection && (iter = ((IStructuredSelection)selection).iterator()).hasNext()) {
            IAdaptable adaptable = (IAdaptable)iter.next();
            return (IResource)adaptable.getAdapter(IResource.class);
        }
        return null;
    }

    public static IJavaProject getJavaProjectByName(String name) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists()) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public static String getProjectRoot(IJavaProject project) {
        if (project == null) {
            return null;
        }
        IResource resource = project.getResource();
        if (resource == null) {
            return null;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return location.toString();
    }

    public static String resolve(IPath file) {
        if (file == null) {
            return null;
        }
        try {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(file);
            URI uri = f.getLocationURI();
            return uri != null ? uri.toString() : f.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String projectName = ExportUtil.removePrefix(file.toString(), "/");
            IJavaProject project = ExportUtil.getJavaProjectByName(projectName);
            if (project != null) {
                return ExportUtil.getProjectRoot(project);
            }
            return file.toOSString();
        }
    }

    public static IJavaProject getJavaProject(String root) {
        Path path = new Path(root);
        if (path.segmentCount() == 1) {
            return ExportUtil.getJavaProjectByName(root);
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (resource != null && resource.getType() == 4 && resource.exists()) {
            return (IJavaProject)JavaCore.create((IResource)resource);
        }
        return null;
    }

    public static String removeProjectRoot(String file, IProject project) {
        String res = ExportUtil.removePrefix(file, String.valueOf('/') + project.getName() + '/');
        if (res.equals(String.valueOf('/') + project.getName())) {
            return ".";
        }
        return res;
    }

    public static String replaceProjectRoot(String file, IProject project, String newProjectRoot) {
        String res = ExportUtil.removeProjectRoot(file, project);
        if (res.equals(".")) {
            return newProjectRoot;
        }
        if (newProjectRoot == null) {
            return res;
        }
        if (!res.equals(file)) {
            return String.valueOf(newProjectRoot) + '/' + res;
        }
        return res;
    }

    public static List<IJavaProject> getClasspathProjects(IJavaProject project) throws JavaModelException {
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        IClasspathEntry[] entries = project.getRawClasspath();
        ExportUtil.addClasspathProjects(projects, entries);
        return ExportUtil.sortProjectsUsingBuildOrder(projects);
    }

    private static void addClasspathProjects(List<IJavaProject> projects, IClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            String subProjectRoot;
            IJavaProject subProject;
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getContentKind() == 1 && classpathEntry.getEntryKind() == 2 && (subProject = ExportUtil.getJavaProject(subProjectRoot = classpathEntry.getPath().toString())) != null) {
                projects.add(subProject);
            }
            ++i;
        }
    }

    public static List<IJavaProject> getClasspathProjectsRecursive(IJavaProject project) throws JavaModelException {
        LinkedList<IJavaProject> result = new LinkedList<IJavaProject>();
        ExportUtil.getClasspathProjectsRecursive(project, result);
        return ExportUtil.sortProjectsUsingBuildOrder(result);
    }

    private static void getClasspathProjectsRecursive(IJavaProject project, LinkedList<IJavaProject> result) throws JavaModelException {
        List<IJavaProject> projects = ExportUtil.getClasspathProjects(project);
        for (IJavaProject javaProject : projects) {
            if (result.contains(javaProject)) continue;
            result.addFirst(javaProject);
            ExportUtil.getClasspathProjectsRecursive(javaProject, result);
        }
    }

    private static List<IJavaProject> sortProjectsUsingBuildOrder(List<IJavaProject> javaProjects) {
        if (javaProjects.isEmpty()) {
            return javaProjects;
        }
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(javaProjects.size());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] buildOrder = workspace.getDescription().getBuildOrder();
        if (buildOrder == null) {
            IProject[] projects = new IProject[javaProjects.size()];
            int i = 0;
            for (IJavaProject javaProject : javaProjects) {
                projects[i] = javaProject.getProject();
                ++i;
            }
            IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
            projects = po.projects;
            buildOrder = new String[projects.length];
            i = 0;
            while (i < projects.length) {
                buildOrder[i] = projects[i].getName();
                ++i;
            }
        }
        int i = 0;
        while (i < buildOrder.length && !javaProjects.isEmpty()) {
            String projectName = buildOrder[i];
            Iterator<IJavaProject> iter = javaProjects.iterator();
            while (iter.hasNext()) {
                IJavaProject javaProject;
                javaProject = iter.next();
                if (!javaProject.getProject().getName().equals(projectName)) continue;
                result.add(javaProject);
                iter.remove();
            }
            ++i;
        }
        result.addAll(javaProjects);
        return result;
    }

    public static IMarker getCyclicDependencyMarker(IJavaProject javaProject) throws CoreException {
        IMarker[] markers = javaProject.getProject().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 1);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                return marker;
            }
            ++i;
        }
        return null;
    }

    public static IType[] findTestsInContainer(String containerHandle) {
        IJavaElement container = JavaCore.create((String)containerHandle);
        if (container == null) {
            return new IType[0];
        }
        try {
            return JUnitCore.findTestTypes((IJavaElement)container, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            AntUIPlugin.log(e);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        return new IType[0];
    }

    public static synchronized Comparator<IJavaProject> getJavaProjectComparator() {
        if (javaProjectComparator == null) {
            javaProjectComparator = new JavaProjectComparator();
        }
        return javaProjectComparator;
    }

    public static synchronized Comparator<IFile> getIFileComparator() {
        if (fileComparator == null) {
            fileComparator = new IFileComparator();
        }
        return fileComparator;
    }

    public static synchronized Comparator<IType> getITypeComparator() {
        if (typeComparator == null) {
            typeComparator = new TypeComparator();
        }
        return typeComparator;
    }

    public static String removePrefix(String s, String prefix) {
        if (s == null) {
            return null;
        }
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static String removeSuffix(String s, String suffix) {
        if (s == null) {
            return null;
        }
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String removePrefixAndSuffix(String s, String prefix, String suffix) {
        return ExportUtil.removePrefix(ExportUtil.removeSuffix(s, suffix), prefix);
    }

    public static String toString(Document doc) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean indentFallback = false;
        try {
            factory.setAttribute("indent-number", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            indentFallback = true;
        }
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (indentFallback) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        transformer.transform(source, result);
        return writer.toString();
    }

    public static Document parseXmlFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        Document doc = factory.newDocumentBuilder().parse(file);
        return doc;
    }

    public static Document parseXmlString(String s) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(s.getBytes()));
        return doc;
    }

    public static String toString(Collection<String> c, String separator) {
        StringBuffer b = new StringBuffer();
        Iterator<String> iter = c.iterator();
        while (iter.hasNext()) {
            b.append(iter.next());
            b.append(separator);
        }
        if (c.size() > 0) {
            b.delete(b.length() - separator.length(), b.length());
        }
        return b.toString();
    }

    public static List<String> removeDuplicates(List<String> l) {
        ArrayList<String> res = new ArrayList<String>();
        for (String element : l) {
            if (res.contains(element)) continue;
            res.add(element);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsUserFile(String filename) {
        File buildFile = new File(filename);
        if (!buildFile.exists()) return false;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(buildFile));
                try {
                    int i = BuildFileCreator.WARNING.indexOf(NEWLINE);
                    String warning = BuildFileCreator.WARNING.substring(0, i);
                    String line = in.readLine();
                    if (line != null) {
                    }
                    return true;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (in == null) return false;
                    in.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean validateEdit(Shell shell, IFile file) {
        return file.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell).isOK();
    }

    public static Set<IFile> validateEdit(Shell shell, List<IFile> files) throws CoreException {
        TreeSet<IFile> confirmedFiles = new TreeSet<IFile>(ExportUtil.getIFileComparator());
        if (files.size() == 0) {
            return confirmedFiles;
        }
        IStatus status = files.get(0).getWorkspace().validateEdit(files.toArray(new IFile[files.size()]), (Object)shell);
        if (status.isMultiStatus() && status.getChildren().length > 0) {
            int i = 0;
            while (i < status.getChildren().length) {
                IStatus statusChild = status.getChildren()[i];
                if (statusChild.isOK()) {
                    confirmedFiles.add(files.get(i));
                }
                ++i;
            }
        } else if (status.isOK()) {
            for (IFile file : files) {
                confirmedFiles.add(file);
            }
        }
        if (status.getSeverity() == 4) {
            StringBuffer message = new StringBuffer(String.valueOf(status.getPlugin()) + ": " + status.getMessage() + NEWLINE);
            if (status.isMultiStatus()) {
                int i = 0;
                while (i < status.getChildren().length) {
                    IStatus statusChild = status.getChildren()[i];
                    message.append(String.valueOf(statusChild.getMessage()) + NEWLINE);
                    ++i;
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 0, message.toString(), null));
        }
        return confirmedFiles;
    }

    public static boolean isDefaultClasspath(IJavaProject project, EclipseClasspath classpath) {
        List<String> list = ExportUtil.removeDuplicates(classpath.rawClassPathEntries);
        if (list.size() != 2) {
            return false;
        }
        String entry1 = list.get(0);
        String entry2 = list.get(1);
        if (!EclipseClasspath.isJreReference(entry1)) {
            return false;
        }
        if (EclipseClasspath.isProjectReference(entry2)) {
            IJavaProject referencedProject = EclipseClasspath.resolveProjectReference(entry2);
            if (referencedProject == null) {
                return false;
            }
            if (referencedProject.getProject().getName().equals(project.getProject().getName())) {
                return true;
            }
        }
        return false;
    }

    public static void addVariable(Map<String, String> variable2valueMap, String s, String projectRoot) {
        if (s == null || s.equals("")) {
            return;
        }
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            File file;
            String value;
            String variable = matcher.group();
            try {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variable);
            }
            catch (CoreException coreException) {
                value = variable;
            }
            variable = ExportUtil.removePrefixAndSuffix(variable, "${", "}");
            if (variable.startsWith("env_var:")) {
                value = "env." + variable.substring("env_var:".length());
            }
            if ((file = new File(value)).exists()) {
                value = ExportUtil.getRelativePath(file.getAbsolutePath(), projectRoot);
            }
            variable2valueMap.put(variable, value);
        }
    }

    public static String getRelativePath(String otherLocation, String basePath) {
        Path location = new Path(otherLocation);
        Path base = new Path(basePath);
        if (location.getDevice() != null && !location.getDevice().equalsIgnoreCase(base.getDevice()) || !location.isAbsolute()) {
            return otherLocation;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments((IPath)location);
        String temp = "";
        int j = 0;
        while (j < baseCount - count) {
            temp = String.valueOf(temp) + "../";
            ++j;
        }
        String relative = new Path(temp).append(location.removeFirstSegments(count)).toString();
        if (relative.length() == 0) {
            relative = ".";
        }
        return relative;
    }

    private static class IFileComparator
    implements Comparator<IFile> {
        private IFileComparator() {
        }

        @Override
        public int compare(IFile o1, IFile o2) {
            IFile f1 = o1;
            IFile f2 = o2;
            return f1.toString().compareTo(f2.toString());
        }
    }

    private static class JavaProjectComparator
    implements Comparator<IJavaProject> {
        private JavaProjectComparator() {
        }

        @Override
        public int compare(IJavaProject o1, IJavaProject o2) {
            IJavaProject j1 = o1;
            IJavaProject j2 = o2;
            return j1.getProject().getName().compareTo(j2.getProject().getName());
        }
    }

    private static class TypeComparator
    implements Comparator<IType> {
        private TypeComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            IType t1 = o1;
            IType t2 = o2;
            return t1.getFullyQualifiedName().compareTo(t2.getFullyQualifiedName());
        }
    }
}

