/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesExportConverter;

public abstract class AbstractRetentionIndicesExportConverter
implements IRetentionIndicesExportConverter {
    @Override
    public void validate(File file) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        if (file == null) {
            throw new FileNotFoundException();
        }
        this.createDirectoriesAndFiles(file);
        if (!file.canWrite()) {
            throw new FileIsNotWriteableException("Can't write the retention indices file: " + file.getAbsoluteFile());
        }
    }

    private void createDirectoriesAndFiles(File file) throws FileIsNotWriteableException, IOException {
        if (file.isDirectory()) {
            if (!file.exists() && !file.mkdirs()) {
                throw new FileIsNotWriteableException("The given retention indices directory " + file + " can not be created.");
            }
        } else {
            File newFile = new File(file.getParentFile().getAbsolutePath());
            if (!newFile.exists() && !newFile.mkdirs()) {
                throw new FileIsNotWriteableException("The given retention indices directory " + file + " can not be created.");
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new FileIsNotWriteableException("The given retention indices file " + file + " can not be created.");
            }
        }
    }
}

